/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.io;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;

public class TypedProtobufWritable<M extends Message>
extends ProtobufWritable<M> {
    public TypedProtobufWritable() {
        super(null, null);
    }

    public TypedProtobufWritable(M obj) {
        super(obj, null);
        if (obj != null) {
            this.setConverter(obj.getClass());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        String className = WritableUtils.readString((DataInput)in);
        if (!className.isEmpty()) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Byte stream does not have a valid class identifier", ex);
            }
            this.setConverter(clazz);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Message obj = (Message)this.get();
        if (obj == null) {
            WritableUtils.writeString((DataOutput)out, (String)"");
        } else {
            WritableUtils.writeString((DataOutput)out, (String)obj.getClass().getName());
        }
    }

    @Override
    public void set(M m) {
        super.set(m);
        if (m != null) {
            this.setConverter(m.getClass());
        }
    }
}

