/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class IntegerListInputSplit
extends InputSplit
implements Writable {
    private static final Log LOG = LogFactory.getLog(IntegerListInputSplit.class);
    protected long min;
    protected long max;

    public IntegerListInputSplit() {
    }

    public IntegerListInputSplit(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("Attempt to create IntegerListInputSplit with min > max, min = " + min + " and max = " + max);
        }
        LOG.info((Object)("Creating IntegerListInputSplit with InputSplit [" + min + ", " + max + "]"));
        this.min = min;
        this.max = max;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getLength() throws IOException, InterruptedException {
        return this.max - this.min + 1L;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[0];
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.min);
        dataOutput.writeLong(this.max);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.min = dataInput.readLong();
        this.max = dataInput.readLong();
    }
}

