/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input.combine;

import com.twitter.elephantbird.util.Pair;
import com.twitter.elephantbird.util.SplitUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeInputSplit
extends InputSplit
implements Writable,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeInputSplit.class);
    private long totalSplitSizes = 0L;
    private List<InputSplit> splits = new ArrayList<InputSplit>();
    private Configuration conf = null;
    private String[] locations;

    public CompositeInputSplit() {
    }

    public CompositeInputSplit(List<InputSplit> splits) throws IOException, InterruptedException {
        for (InputSplit split : splits) {
            this.add(split);
        }
    }

    public void add(InputSplit split) throws IOException, InterruptedException {
        this.splits.add(split);
        this.totalSplitSizes += split.getLength();
        this.locations = null;
    }

    public List<InputSplit> getSplits() {
        return this.splits;
    }

    public InputSplit get(int i) {
        return this.splits.get(i);
    }

    public long getLength() {
        return this.totalSplitSizes;
    }

    public long getLength(int i) throws IOException, InterruptedException {
        return this.splits.get(i).getLength();
    }

    public String[] getLocations() throws IOException, InterruptedException {
        if (this.locations == null) {
            HashMap<String, Integer> hosts = new HashMap<String, Integer>();
            for (InputSplit s : this.splits) {
                String[] hints = s.getLocations();
                if (hints == null) continue;
                for (String host : hints) {
                    Integer value = (Integer)hosts.get(host);
                    if (value == null) {
                        value = 0;
                    }
                    Integer n = value;
                    Integer n2 = value = Integer.valueOf(value + 1);
                    hosts.put(host, value);
                }
            }
            if (hosts.size() < 5) {
                this.locations = hosts.keySet().toArray(new String[hosts.size()]);
            } else {
                PriorityQueue<Pair<String, Integer>> queue = new PriorityQueue<Pair<String, Integer>>(hosts.size(), new Comparator<Pair<String, Integer>>(){

                    @Override
                    public int compare(Pair<String, Integer> o1, Pair<String, Integer> o2) {
                        return -o1.getSecond().compareTo(o2.getSecond());
                    }
                });
                for (Map.Entry entry : hosts.entrySet()) {
                    queue.add(new Pair(entry.getKey(), entry.getValue()));
                }
                this.locations = new String[]{(String)((Pair)queue.remove()).getFirst(), (String)((Pair)queue.remove()).getFirst(), (String)((Pair)queue.remove()).getFirst(), (String)((Pair)queue.remove()).getFirst(), (String)((Pair)queue.remove()).getFirst()};
            }
        }
        return this.locations;
    }

    public String[] getLocation(int i) throws IOException, InterruptedException {
        return this.splits.get(i).getLocations();
    }

    public void write(DataOutput out) throws IOException {
        if (this.conf == null) {
            throw new IOException("Hadoop Configuration not set via setConf");
        }
        WritableUtils.writeVInt((DataOutput)out, (int)this.splits.size());
        for (InputSplit split : this.splits) {
            SplitUtil.serializeInputSplit(this.conf, (DataOutputStream)out, split);
        }
    }

    public void readFields(DataInput in) throws IOException {
        if (this.conf == null) {
            throw new IOException("Hadoop Configuration not set via setConf");
        }
        int card = WritableUtils.readVInt((DataInput)in);
        this.splits = new ArrayList<InputSplit>();
        for (int i = 0; i < card; ++i) {
            this.splits.add(SplitUtil.deserializeInputSplit(this.conf, (DataInputStream)in));
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

