/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.output;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.mapreduce.io.ProtobufConverter;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.mapreduce.io.ThriftConverter;
import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.util.Codecs;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TBase;

public class LzoBinaryB64LineRecordWriter<M, W extends BinaryWritable<M>>
extends RecordWriter<M, W> {
    private final BinaryConverter<M> converter;
    private final DataOutputStream out;
    private final Base64 base64;

    public LzoBinaryB64LineRecordWriter(BinaryConverter<M> converter, DataOutputStream out) {
        this.converter = converter;
        this.out = out;
        this.base64 = Codecs.createStandardBase64();
    }

    public void write(M nullWritable, W writable) throws IOException {
        byte[] b64Bytes = this.base64.encode(this.converter.toBytes(((BinaryWritable)writable).get()));
        this.out.write(b64Bytes);
        this.out.write(10);
    }

    public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.out.close();
    }

    public static <M extends TBase<?, ?>> LzoBinaryB64LineRecordWriter<M, ThriftWritable<M>> newThriftWriter(Class<M> tClass, DataOutputStream out) {
        return new LzoBinaryB64LineRecordWriter(ThriftConverter.newInstance(tClass), out);
    }

    public static <M extends Message> LzoBinaryB64LineRecordWriter<M, ProtobufWritable<M>> newProtobufWriter(Class<M> tClass, DataOutputStream out) {
        return new LzoBinaryB64LineRecordWriter(ProtobufConverter.newInstance(tClass), out);
    }
}

