/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class StreamSearcher {
    protected byte[] pattern_;
    protected int[] borders_;
    public static final int MAX_PATTERN_LENGTH = 1024;

    public StreamSearcher(byte[] pattern) {
        this.setPattern(pattern);
    }

    public void setPattern(byte[] pattern) {
        this.pattern_ = Arrays.copyOf(pattern, pattern.length);
        this.borders_ = new int[this.pattern_.length + 1];
        this.preProcess();
    }

    public long search(InputStream stream) throws IOException {
        int b;
        long bytesRead = 0L;
        int j = 0;
        while ((b = stream.read()) != -1) {
            ++bytesRead;
            while (j >= 0 && (byte)b != this.pattern_[j]) {
                j = this.borders_[j];
            }
            if (++j != this.pattern_.length) continue;
            return bytesRead;
        }
        return -1L;
    }

    protected void preProcess() {
        int j;
        int i = 0;
        this.borders_[i] = j = -1;
        while (i < this.pattern_.length) {
            while (j >= 0 && this.pattern_[i] != this.pattern_[j]) {
                j = this.borders_[j];
            }
            this.borders_[++i] = ++j;
        }
    }
}

