/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.pig.load.LzoBaseLoadFunc;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.Utils;

public class LzoRawBytesLoader
extends LzoBaseLoadFunc {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    private TypeRef<byte[]> typeRef = new TypeRef<byte[]>(byte[].class){};

    public InputFormat<LongWritable, BinaryWritable<byte[]>> getInputFormat() throws IOException {
        return new MultiInputFormat(this.typeRef);
    }

    public Tuple getNext() throws IOException {
        byte[] bytes = this.getNextBinaryValue(this.typeRef);
        return bytes != null ? tupleFactory.newTuple((Object)new DataByteArray(bytes)) : null;
    }

    @Override
    public ResourceSchema getSchema(String filename, Job job) throws IOException {
        return new ResourceSchema(Utils.getSchemaFromString((String)"bytes : bytearray"));
    }
}

