/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.common.collect.Maps;
import com.twitter.elephantbird.mapreduce.input.LzoW3CLogInputFormat;
import com.twitter.elephantbird.mapreduce.input.LzoW3CLogRecordReader;
import com.twitter.elephantbird.pig.load.LzoBaseLoadFunc;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoW3CLogLoader
extends LzoBaseLoadFunc
implements LoadMetadata {
    protected static final Logger LOG = LoggerFactory.getLogger(LzoW3CLogLoader.class);
    protected static final TupleFactory tupleFactory_ = TupleFactory.getInstance();
    protected final String fileURI;

    public LzoW3CLogLoader(String fileURI) throws IOException {
        LOG.debug("Initialize LzoW3CLogLoader from " + fileURI);
        this.fileURI = fileURI;
    }

    public Tuple getNext() throws IOException {
        LzoW3CLogRecordReader w3CLogRecordReader = (LzoW3CLogRecordReader)this.reader;
        if (w3CLogRecordReader == null) {
            return null;
        }
        try {
            MapWritable value_;
            if (w3CLogRecordReader.nextKeyValue() && (value_ = w3CLogRecordReader.getCurrentValue()) != null) {
                HashMap values = Maps.newHashMap();
                for (Writable key : value_.keySet()) {
                    Writable value = value_.get((Object)key);
                    values.put(key.toString(), value != null ? value.toString() : null);
                }
                this.incrCounter(LzoW3CLogLoaderCounters.LinesW3CDecoded, 1L);
                this.incrCounter(LzoW3CLogLoaderCounters.UnparseableLines, w3CLogRecordReader.getBadRecordsSkipped());
                return tupleFactory_.newTuple((Object)values);
            }
        }
        catch (InterruptedException e) {
            int errCode = 6018;
            String errMsg = "Error while reading input";
            throw new ExecException(errMsg, errCode, 16, (Throwable)e);
        }
        return null;
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    public InputFormat getInputFormat() {
        return LzoW3CLogInputFormat.newInstance((String)this.fileURI);
    }

    @Override
    public String[] getPartitionKeys(String arg0, Job arg1) throws IOException {
        return null;
    }

    @Override
    public ResourceSchema getSchema(String arg0, Job arg1) throws IOException {
        return new ResourceSchema(new Schema(new Schema.FieldSchema("data", 100)));
    }

    @Override
    public ResourceStatistics getStatistics(String arg0, Job arg1) throws IOException {
        return null;
    }

    @Override
    public void setPartitionFilter(Expression arg0) throws IOException {
    }

    protected static enum LzoW3CLogLoaderCounters {
        LinesW3CDecoded,
        UnparseableLines;

    }
}

