/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;

public class LongWritableConverter
extends AbstractWritableConverter<LongWritable> {
    public LongWritableConverter() {
        super(new LongWritable());
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema schema = new ResourceSchema.ResourceFieldSchema();
        schema.setType((byte)15);
        return schema;
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        return this.bytesToLong(dataByteArray.get());
    }

    @Override
    protected String toCharArray(LongWritable writable) throws IOException {
        return String.valueOf(writable.get());
    }

    @Override
    protected Integer toInteger(LongWritable writable) throws IOException {
        return (int)writable.get();
    }

    @Override
    protected Long toLong(LongWritable writable) throws IOException {
        return writable.get();
    }

    @Override
    protected Float toFloat(LongWritable writable) throws IOException {
        return Float.valueOf(writable.get());
    }

    @Override
    protected Double toDouble(LongWritable writable) throws IOException {
        return writable.get();
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema schema) throws IOException {
        switch (schema.getType()) {
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 55: {
                return;
            }
        }
        throw new IOException("Pig type '" + DataType.findTypeName((byte)schema.getType()) + "' unsupported");
    }

    @Override
    protected LongWritable toWritable(String value) throws IOException {
        return this.toWritable(Long.parseLong(value));
    }

    @Override
    protected LongWritable toWritable(Integer value) throws IOException {
        return this.toWritable(value.longValue());
    }

    @Override
    protected LongWritable toWritable(Long value) throws IOException {
        ((LongWritable)this.writable).set(value.longValue());
        return (LongWritable)this.writable;
    }

    @Override
    protected LongWritable toWritable(Float value) throws IOException {
        return this.toWritable(value.longValue());
    }

    @Override
    protected LongWritable toWritable(Double value) throws IOException {
        return this.toWritable(value.longValue());
    }
}

