/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.hadoop.compression.lzo.LzopInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pig.impl.io.BufferedPositionedInputStream;

public class LzoBufferedPositionedInputStream
extends BufferedPositionedInputStream {
    private LzopInputStream lzopIn_ = null;
    private long start_ = 0L;

    public LzoBufferedPositionedInputStream(InputStream in, long pos) {
        super(in, pos);
        if (in instanceof LzopInputStream) {
            this.lzopIn_ = (LzopInputStream)in;
            this.start_ = pos;
        }
    }

    public long getPosition() throws IOException {
        if (this.lzopIn_ != null) {
            return this.start_ + this.lzopIn_.getCompressedBytesRead();
        }
        return super.getPosition();
    }

    public long skip(long toSkip) throws IOException {
        long pos = this.getPosition();
        while (this.getPosition() - pos < toSkip && super.skip(toSkip) != 0L) {
        }
        return this.getPosition() - pos;
    }
}

