/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.pig.util.ProtobufToPig;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.thrift.TBase;

public class PigUtil {
    public static final boolean Pig9orNewer;

    public static Class<?> getClass(String className) {
        try {
            return PigContext.resolveClassName((String)className);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not instantiate " + className, e);
        }
    }

    public static Class<? extends Message> getProtobufClass(String protoClassName) {
        try {
            Class<?> protoClass = PigUtil.getClass(protoClassName);
            return protoClass.asSubclass(Message.class);
        }
        catch (RuntimeException e) {
            return Protobufs.getProtobufClass((String)protoClassName);
        }
    }

    public static Descriptors.Descriptor getProtobufDescriptor(Class<? extends Message> protoClass) {
        try {
            return (Descriptors.Descriptor)protoClass.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to get Descriptor for Message type '%s'", protoClass.getName()), e);
        }
    }

    public static Descriptors.Descriptor getProtobufDescriptor(String protoClassName) {
        return PigUtil.getProtobufDescriptor(PigUtil.getProtobufClass(protoClassName));
    }

    public static <M extends Message> TypeRef<M> getProtobufTypeRef(String protoClassName) {
        return new TypeRef<M>(PigUtil.getProtobufClass(protoClassName)){};
    }

    public static <T extends TBase<?, ?>> TypeRef<T> getThriftTypeRef(String thriftClassName) {
        return ThriftUtils.getTypeRef(PigUtil.getClass(thriftClassName));
    }

    public static Schema outputSchemaForProtobuf(ProtobufToPig protoToPig, TypeRef<? extends Message> typeRef) {
        Schema outSchema;
        try {
            outSchema = protoToPig.toSchema(Protobufs.getMessageDescriptor((Class)typeRef.getRawClass()));
            if (outSchema.size() > 1) {
                outSchema = new Schema(new Schema.FieldSchema(typeRef.getRawClass().getSimpleName(), outSchema, 110));
            }
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
        return outSchema;
    }

    public static Schema outputSchemaForThrift(TypeRef<? extends TBase<?, ?>> typeRef) {
        Schema outSchema;
        try {
            outSchema = ThriftToPig.toSchema(typeRef.getRawClass());
            if (outSchema.size() > 1) {
                outSchema = new Schema(new Schema.FieldSchema(typeRef.getRawClass().getSimpleName(), outSchema, 110));
            }
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
        return outSchema;
    }

    static {
        boolean methodFound = false;
        try {
            Class<?> cls = Class.forName("org.apache.pig.EvalFunc");
            methodFound = cls.getMethod("getCacheFiles", new Class[0]) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Pig9orNewer = methodFound;
    }
}

