/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.TypeRef;
import java.util.List;
import org.apache.pig.LoadPushDown;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.thrift.TBase;

public class ProjectedThriftTupleFactory<T extends TBase<?, ?>> {
    private static TupleFactory tf = TupleFactory.getInstance();
    private int[] requiredFields;
    private final TStructDescriptor tStructDesc;

    public ProjectedThriftTupleFactory(TypeRef<T> typeRef, LoadPushDown.RequiredFieldList requiredFieldList) {
        this.tStructDesc = TStructDescriptor.getInstance((Class)typeRef.getRawClass());
        int numFields = this.tStructDesc.getFields().size();
        if (requiredFieldList != null) {
            List tupleFields = requiredFieldList.getFields();
            this.requiredFields = new int[tupleFields.size()];
            int i = 0;
            for (LoadPushDown.RequiredField f : tupleFields) {
                Preconditions.checkState((f.getIndex() < numFields ? 1 : 0) != 0, (Object)"Projected index is out of range");
                this.requiredFields[i++] = f.getIndex();
            }
        } else {
            this.requiredFields = new int[numFields];
            for (int i = 0; i < numFields; ++i) {
                this.requiredFields[i] = i;
            }
        }
    }

    public Tuple newTuple(T tObject) throws ExecException {
        int size = this.requiredFields.length;
        List tFields = this.tStructDesc.getFields();
        Tuple tuple = tf.newTuple(size);
        for (int i = 0; i < size; ++i) {
            int idx = this.requiredFields[i];
            Object value = this.tStructDesc.getFieldValue(idx, tObject);
            tuple.set(i, ThriftToPig.toPigObject((TStructDescriptor.Field)tFields.get(idx), value, true));
        }
        return tuple;
    }
}

