/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.internal.exceptions;

import com.google.common.net.MediaType;
import com.twitter.finagle.CancelledRequestException;
import com.twitter.finagle.Failure;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finatra.http.exceptions.DefaultExceptionMapper;
import com.twitter.finatra.http.exceptions.HttpException;
import com.twitter.finatra.http.exceptions.HttpResponseException;
import com.twitter.finatra.http.internal.exceptions.FinatraDefaultExceptionMapper$;
import com.twitter.finatra.http.response.ErrorsResponse;
import com.twitter.finatra.http.response.ResponseBuilder;
import javax.inject.Inject;
import javax.inject.Singleton;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Singleton
@ScalaSignature(bytes="\u0006\u00011<Q!\u0001\u0002\t\u0002=\tQDR5oCR\u0014\u0018\rR3gCVdG/\u0012=dKB$\u0018n\u001c8NCB\u0004XM\u001d\u0006\u0003\u0007\u0011\t!\"\u001a=dKB$\u0018n\u001c8t\u0015\t)a!\u0001\u0005j]R,'O\\1m\u0015\t9\u0001\"\u0001\u0003iiR\u0004(BA\u0005\u000b\u0003\u001d1\u0017N\\1ue\u0006T!a\u0003\u0007\u0002\u000fQ<\u0018\u000e\u001e;fe*\tQ\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051CA\u000fGS:\fGO]1EK\u001a\fW\u000f\u001c;Fq\u000e,\u0007\u000f^5p]6\u000b\u0007\u000f]3s'\t\tB\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\u0005\u00067E!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=AqAH\tC\u0002\u0013%q$\u0001\u0005NCb$U\r\u001d;i+\u0005\u0001\u0003CA\u000b\"\u0013\t\u0011cCA\u0002J]RDa\u0001J\t!\u0002\u0013\u0001\u0013!C'bq\u0012+\u0007\u000f\u001e5!\u0011\u00151\u0013\u0003\"\u0003(\u00035)hn\u001e:ba\u001a\u000b\u0017\u000e\\;sKR\u0019\u0001\u0006\u000e\u001f\u0011\u0005%\ndB\u0001\u00160\u001d\tYc&D\u0001-\u0015\tic\"\u0001\u0004=e>|GOP\u0005\u0002/%\u0011\u0001GF\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00114GA\u0005UQJ|w/\u00192mK*\u0011\u0001G\u0006\u0005\u0006k\u0015\u0002\rAN\u0001\bM\u0006LG.\u001e:f!\t9$(D\u00019\u0015\tI$\"A\u0004gS:\fw\r\\3\n\u0005mB$a\u0002$bS2,(/\u001a\u0005\u0006{\u0015\u0002\r\u0001I\u0001\u0006I\u0016\u0004H\u000f\u001b\u0004\u0005%\t\u0001qhE\u0002?)\u0001\u0003\"!Q\"\u000e\u0003\tS!a\u0001\u0004\n\u0005\u0011\u0013%A\u0006#fM\u0006,H\u000e^#yG\u0016\u0004H/[8o\u001b\u0006\u0004\b/\u001a:\t\u0011\u0019s$\u0011!Q\u0001\n\u001d\u000b\u0001B]3ta>t7/\u001a\t\u0003\u0011*k\u0011!\u0013\u0006\u0003\r\u001aI!aS%\u0003\u001fI+7\u000f]8og\u0016\u0014U/\u001b7eKJDQa\u0007 \u0005\u00025#\"AT(\u0011\u0005Aq\u0004\"\u0002$M\u0001\u00049\u0005F\u0001'R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0004j]*,7\r\u001e\u0006\u0002-\u0006)!.\u0019<bq&\u0011\u0001l\u0015\u0002\u0007\u0013:TWm\u0019;\t\u000bisD\u0011I.\u0002\u0015Q|'+Z:q_:\u001cX\rF\u0002]C\u001a\u0004\"!X0\u000e\u0003yS!a\u0002\u001d\n\u0005\u0001t&\u0001\u0003*fgB|gn]3\t\u000b\tL\u0006\u0019A2\u0002\u000fI,\u0017/^3tiB\u0011Q\fZ\u0005\u0003Kz\u0013qAU3rk\u0016\u001cH\u000fC\u0003h3\u0002\u0007\u0001&A\u0005uQJ|w/\u00192mK\"\u0012a(\u001b\t\u0003%*L!a[*\u0003\u0013MKgn\u001a7fi>t\u0007")
public class FinatraDefaultExceptionMapper
implements DefaultExceptionMapper {
    private final ResponseBuilder response;

    @Override
    public Response toResponse(Request request, Throwable throwable) {
        Object object;
        Throwable throwable2 = throwable;
        if (throwable2 instanceof HttpException) {
            HttpException httpException = (HttpException)throwable2;
            ResponseBuilder.EnrichedResponse builder = this.response.status(httpException.statusCode());
            object = httpException.mediaType().is(MediaType.JSON_UTF_8) ? builder.json(new ErrorsResponse(httpException.errors())) : builder.plain(httpException.errors().mkString(", "));
        } else if (throwable2 instanceof HttpResponseException) {
            HttpResponseException httpResponseException = (HttpResponseException)throwable2;
            object = httpResponseException.response();
        } else if (throwable2 instanceof CancelledRequestException) {
            CancelledRequestException cancelledRequestException = (CancelledRequestException)throwable2;
            object = this.response.clientClosed().handled(request, (Throwable)cancelledRequestException, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        } else if (throwable2 instanceof Failure) {
            Failure failure = (Failure)throwable2;
            Throwable throwable3 = FinatraDefaultExceptionMapper$.MODULE$.com$twitter$finatra$http$internal$exceptions$FinatraDefaultExceptionMapper$$unwrapFailure(failure, FinatraDefaultExceptionMapper$.MODULE$.com$twitter$finatra$http$internal$exceptions$FinatraDefaultExceptionMapper$$MaxDepth());
            Object object2 = throwable3 instanceof Failure ? this.response.internalServerError().unhandled(request, (Throwable)failure, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).jsonError() : this.toResponse(request, throwable3);
            object = object2;
        } else {
            object = this.response.internalServerError().unhandled(request, throwable2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).jsonError();
        }
        return object;
    }

    @Inject
    public FinatraDefaultExceptionMapper(ResponseBuilder response) {
        this.response = response;
    }
}

