/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.internal.server;

import com.twitter.app.Flag;
import com.twitter.app.Flaggable$;
import com.twitter.conversions.storage$;
import com.twitter.conversions.time$;
import com.twitter.finagle.Announcement;
import com.twitter.finagle.CodecFactory;
import com.twitter.finagle.Service;
import com.twitter.finagle.builder.Server;
import com.twitter.finagle.builder.ServerBuilder;
import com.twitter.finagle.builder.ServerBuilder$;
import com.twitter.finagle.builder.ServerConfig;
import com.twitter.finagle.builder.ServerConfigEvidence;
import com.twitter.finagle.http.Http;
import com.twitter.finagle.http.Http$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.service.NullService$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finatra.conversions.string$;
import com.twitter.finatra.http.internal.server.BaseHttpServer;
import com.twitter.finatra.http.internal.server.BaseHttpServer$;
import com.twitter.inject.server.PortUtils$;
import com.twitter.util.Await$;
import com.twitter.util.Awaitable;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.StorageUnit;
import com.twitter.util.Time;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class BaseHttpServer$class {
    public static String defaultFinatraHttpPort(BaseHttpServer $this) {
        return ":8888";
    }

    public static StorageUnit defaultMaxRequestSize(BaseHttpServer $this) {
        return storage$.MODULE$.intToStorageUnitableWholeNumber(5).megabytes();
    }

    public static boolean defaultTracingEnabled(BaseHttpServer $this) {
        return true;
    }

    public static String defaultHttpsPort(BaseHttpServer $this) {
        return "";
    }

    public static String defaultCertificatePath(BaseHttpServer $this) {
        return "";
    }

    public static String defaultKeyPath(BaseHttpServer $this) {
        return "";
    }

    public static Duration defaultShutdownTimeout(BaseHttpServer $this) {
        return time$.MODULE$.intToTimeableNumber(1).minute();
    }

    public static String defaultHttpServerName(BaseHttpServer $this) {
        return "http";
    }

    public static String defaultHttpsServerName(BaseHttpServer $this) {
        return "https";
    }

    public static boolean failfastOnFlagsNotParsed(BaseHttpServer $this) {
        return true;
    }

    public static Service httpService(BaseHttpServer $this) {
        return NullService$.MODULE$;
    }

    public static Http httpCodec(BaseHttpServer $this) {
        return new Http(Http$.MODULE$.apply$default$1(), Http$.MODULE$.apply$default$2(), Http$.MODULE$.apply$default$3(), Http$.MODULE$.apply$default$4(), Http$.MODULE$.apply$default$5(), Http$.MODULE$.apply$default$6(), Http$.MODULE$.apply$default$7(), Http$.MODULE$.apply$default$8(), Http$.MODULE$.apply$default$9(), Http$.MODULE$.apply$default$10(), Http$.MODULE$.apply$default$11()).maxRequestSize((StorageUnit)$this.com$twitter$finatra$http$internal$server$BaseHttpServer$$maxRequestSizeFlag().apply()).enableTracing(BoxesRunTime.unboxToBoolean((Object)$this.com$twitter$finatra$http$internal$server$BaseHttpServer$$tracingEnabledFlag().apply())).streaming($this.streamRequest());
    }

    public static boolean streamRequest(BaseHttpServer $this) {
        return false;
    }

    public static boolean disableAdminHttpServer(BaseHttpServer $this) {
        return false;
    }

    public static void configureHttpServer(BaseHttpServer $this, ServerBuilder serverBuilder) {
    }

    public static void configureHttpsServer(BaseHttpServer $this, ServerBuilder serverBuilder) {
    }

    public static void postWarmup(BaseHttpServer $this) {
        Future future2;
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$$super$postWarmup();
        if ($this.disableAdminHttpServer()) {
            $this.info((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disabling the Admin HTTP Server since disableAdminHttpServer=true";
                }
            });
            future2 = $this.adminHttpServer().close();
        } else {
            $this.com$twitter$finatra$http$internal$server$BaseHttpServer$$adminAnnounceFlag().get().foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseHttpServer $outer;

                public final Future<Announcement> apply(String addr) {
                    return this.$outer.adminHttpServer().announce(addr);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            future2 = BoxedUnit.UNIT;
        }
        BaseHttpServer$class.startHttpServer($this);
        BaseHttpServer$class.startHttpsServer($this);
    }

    public static void waitForServer(BaseHttpServer $this) {
        if ($this.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpServer() == null) {
            Await$.MODULE$.ready((Awaitable)$this.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpsServer());
        } else {
            Await$.MODULE$.ready((Awaitable)$this.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpServer());
        }
    }

    public static Option httpExternalPort(BaseHttpServer $this) {
        return Option$.MODULE$.apply((Object)$this.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpServer()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Server server) {
                return PortUtils$.MODULE$.getPort(server);
            }
        });
    }

    public static Option httpsExternalPort(BaseHttpServer $this) {
        return Option$.MODULE$.apply((Object)$this.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpsServer()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Server server) {
                return PortUtils$.MODULE$.getPort(server);
            }
        });
    }

    private static Option parsePort(BaseHttpServer $this, Flag port) {
        return string$.MODULE$.RichString((String)port.apply()).toOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final InetSocketAddress apply(String addrStr) {
                return PortUtils$.MODULE$.parseAddr(addrStr);
            }
        });
    }

    private static void startHttpServer(BaseHttpServer $this) {
        BaseHttpServer$class.parsePort($this, $this.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpPortFlag()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHttpServer $outer;

            public final void apply(InetSocketAddress port) {
                ServerBuilder serverBuilder = ServerBuilder$.MODULE$.apply().codec((CodecFactory)this.$outer.httpCodec()).bindTo((SocketAddress)port).reportTo((StatsReceiver)this.$outer.injector().instance(ManifestFactory$.MODULE$.classType(StatsReceiver.class))).name((String)this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpServerNameFlag().apply());
                this.$outer.configureHttpServer((ServerBuilder<Request, Response, ServerConfig.Yes, ServerConfig.Yes, ServerConfig.Yes>)serverBuilder);
                this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpServer_$eq(serverBuilder.build(this.$outer.httpService(), (ServerConfigEvidence)ServerConfigEvidence.FullyConfigured$.MODULE$));
                this.$outer.onExit((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseHttpServer$.anonfun.startHttpServer.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Await$.MODULE$.result((Awaitable)BaseHttpServer$class.com$twitter$finatra$http$internal$server$BaseHttpServer$$close(this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer(), this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer().com$twitter$finatra$http$internal$server$BaseHttpServer$$httpServer(), ((Duration)this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer().com$twitter$finatra$http$internal$server$BaseHttpServer$$shutdownTimeoutFlag().apply()).fromNow()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpAnnounceFlag().get().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseHttpServer$.anonfun.startHttpServer.1 $outer;

                    public final Future<Announcement> apply(String addr) {
                        return this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer().com$twitter$finatra$http$internal$server$BaseHttpServer$$httpServer().announce(addr);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.info((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseHttpServer$.anonfun.startHttpServer.1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"http server started on port: ").append(this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer().httpExternalPort().get()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ BaseHttpServer com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private static void startHttpsServer(BaseHttpServer $this) {
        BaseHttpServer$class.parsePort($this, $this.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpsPortFlag()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHttpServer $outer;

            public final void apply(InetSocketAddress port) {
                ServerBuilder qual$1 = ServerBuilder$.MODULE$.apply().codec((CodecFactory)this.$outer.httpCodec()).bindTo((SocketAddress)port).reportTo((StatsReceiver)this.$outer.injector().instance(ManifestFactory$.MODULE$.classType(StatsReceiver.class))).name((String)this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpsServerNameFlag().apply());
                String x$1 = (String)this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$certificatePathFlag().apply();
                String x$2 = (String)this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$keyPathFlag().apply();
                String x$3 = qual$1.tls$default$3();
                String x$4 = qual$1.tls$default$4();
                String x$5 = qual$1.tls$default$5();
                ServerBuilder serverBuilder = qual$1.tls(x$1, x$2, x$3, x$4, x$5);
                this.$outer.configureHttpsServer((ServerBuilder<Request, Response, ServerConfig.Yes, ServerConfig.Yes, ServerConfig.Yes>)serverBuilder);
                this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpsServer_$eq(serverBuilder.build(this.$outer.httpService(), (ServerConfigEvidence)ServerConfigEvidence.FullyConfigured$.MODULE$));
                this.$outer.onExit((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseHttpServer$.anonfun.startHttpsServer.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Await$.MODULE$.result((Awaitable)BaseHttpServer$class.com$twitter$finatra$http$internal$server$BaseHttpServer$$close(this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer(), this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer().com$twitter$finatra$http$internal$server$BaseHttpServer$$httpsServer(), ((Duration)this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer().com$twitter$finatra$http$internal$server$BaseHttpServer$$shutdownTimeoutFlag().apply()).fromNow()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$httpsAnnounceFlag().get().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseHttpServer$.anonfun.startHttpsServer.1 $outer;

                    public final Future<Announcement> apply(String addr) {
                        return this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer().com$twitter$finatra$http$internal$server$BaseHttpServer$$httpsServer().announce(addr);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.info((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseHttpServer$.anonfun.startHttpsServer.1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"https server started on port: ").append(this.$outer.com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer().httpsExternalPort()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ BaseHttpServer com$twitter$finatra$http$internal$server$BaseHttpServer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Future com$twitter$finatra$http$internal$server$BaseHttpServer$$close(BaseHttpServer $this, Server server, Time deadline) {
        return server == null ? Future$.MODULE$.Unit() : server.close(deadline);
    }

    public static void $init$(BaseHttpServer $this) {
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$httpPortFlag_$eq($this.flag().apply("http.port", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHttpServer $outer;

            public final String apply() {
                return this.$outer.defaultFinatraHttpPort();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "External HTTP server port", Flaggable$.MODULE$.ofString()));
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$maxRequestSizeFlag_$eq($this.flag().apply("maxRequestSize", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHttpServer $outer;

            public final StorageUnit apply() {
                return this.$outer.defaultMaxRequestSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "HTTP(s) Max Request Size", Flaggable$.MODULE$.ofStorageUnit()));
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$tracingEnabledFlag_$eq($this.flag().apply("tracingEnabled", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHttpServer $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.defaultTracingEnabled();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Tracing enabled", Flaggable$.MODULE$.ofBoolean()));
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$httpsPortFlag_$eq($this.flag().apply("https.port", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHttpServer $outer;

            public final String apply() {
                return this.$outer.defaultHttpsPort();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "HTTPs Port", Flaggable$.MODULE$.ofString()));
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$certificatePathFlag_$eq($this.flag().apply("cert.path", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHttpServer $outer;

            public final String apply() {
                return this.$outer.defaultCertificatePath();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "path to SSL certificate", Flaggable$.MODULE$.ofString()));
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$keyPathFlag_$eq($this.flag().apply("key.path", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHttpServer $outer;

            public final String apply() {
                return this.$outer.defaultKeyPath();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "path to SSL key", Flaggable$.MODULE$.ofString()));
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$shutdownTimeoutFlag_$eq($this.flag().apply("shutdown.time", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHttpServer $outer;

            public final Duration apply() {
                return this.$outer.defaultShutdownTimeout();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Maximum amount of time to wait for pending requests to complete on shutdown", Flaggable$.MODULE$.ofDuration()));
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$httpAnnounceFlag_$eq($this.flag().apply("http.announce", "Address to announce HTTP server to", Flaggable$.MODULE$.ofString(), ManifestFactory$.MODULE$.classType(String.class)));
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$httpsAnnounceFlag_$eq($this.flag().apply("https.announce", "Address to announce HTTPS server to", Flaggable$.MODULE$.ofString(), ManifestFactory$.MODULE$.classType(String.class)));
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$adminAnnounceFlag_$eq($this.flag().apply("admin.announce", "Address to announce admin server to", Flaggable$.MODULE$.ofString(), ManifestFactory$.MODULE$.classType(String.class)));
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$httpServerNameFlag_$eq($this.flag().apply("http.name", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHttpServer $outer;

            public final String apply() {
                return this.$outer.defaultHttpServerName();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Http server name", Flaggable$.MODULE$.ofString()));
        $this.com$twitter$finatra$http$internal$server$BaseHttpServer$_setter_$com$twitter$finatra$http$internal$server$BaseHttpServer$$httpsServerNameFlag_$eq($this.flag().apply("https.name", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHttpServer $outer;

            public final String apply() {
                return this.$outer.defaultHttpsServerName();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Https server name", Flaggable$.MODULE$.ofString()));
    }
}

