/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.json.internal.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.twitter.finatra.json.internal.caseclass.exceptions.FinatraJsonMappingException;
import org.joda.time.DateTime;
import scala.collection.mutable.StringBuilder;

public final class FinatraDatetimeDeserializer$
extends StdDeserializer<DateTime> {
    public static final FinatraDatetimeDeserializer$ MODULE$;

    static {
        new FinatraDatetimeDeserializer$();
    }

    public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) {
        try {
            block9: {
                DateTime dateTime;
                block8: {
                    JsonToken jsonToken;
                    block7: {
                        jsonToken = jp.getCurrentToken();
                        if (!JsonToken.VALUE_NUMBER_INT.equals(jsonToken)) break block7;
                        long value = jp.getLongValue();
                        if (value < 0L) {
                            throw new FinatraJsonMappingException("field cannot be negative");
                        }
                        dateTime = new DateTime(jp.getLongValue());
                        break block8;
                    }
                    if (!JsonToken.VALUE_STRING.equals(jsonToken)) break block9;
                    String value = jp.getText().trim();
                    if (value.isEmpty()) {
                        throw new FinatraJsonMappingException("field cannot be empty");
                    }
                    dateTime = new DateTime((Object)value);
                }
                return dateTime;
            }
            throw ctxt.mappingException(this.handledType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FinatraJsonMappingException(new StringBuilder().append((Object)"error parsing '").append((Object)jp.getText()).append((Object)"' into an ISO 8601 datetime").toString());
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FinatraDatetimeDeserializer$() {
        super(DateTime.class);
        MODULE$ = this;
    }
}

