/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi;

import com.google.common.collect.Lists;
import com.ullink.slack.simpleslackapi.SlackAttachment;
import java.util.Arrays;
import java.util.List;

public class SlackPreparedMessage {
    private final String message;
    private final boolean unfurl;
    private final boolean linkNames;
    private final SlackAttachment[] attachments;

    private SlackPreparedMessage(String message, boolean unfurl, boolean linkNames, SlackAttachment[] attachments) {
        this.message = message;
        this.unfurl = unfurl;
        this.linkNames = linkNames;
        this.attachments = attachments;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isUnfurl() {
        return this.unfurl;
    }

    public boolean isLinkNames() {
        return this.linkNames;
    }

    public SlackAttachment[] getAttachments() {
        return this.attachments;
    }

    public String toString() {
        return "SlackPreparedMessage{message='" + this.message + '\'' + ", unfurl=" + this.unfurl + ", attachments=" + Arrays.toString(this.attachments) + '}';
    }

    public static class Builder {
        String message;
        boolean unfurl;
        boolean linkNames;
        List<SlackAttachment> attachments = Lists.newArrayList();

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withUnfurl(boolean unfurl) {
            this.unfurl = unfurl;
            return this;
        }

        public Builder withLinkNames(boolean linkNames) {
            this.linkNames = linkNames;
            return this;
        }

        public Builder addAttachment(SlackAttachment attachment) {
            if (attachment != null) {
                this.attachments.add(attachment);
            }
            return this;
        }

        public Builder addAttachments(List<SlackAttachment> attachments) {
            if (attachments != null) {
                this.attachments.addAll(attachments);
            }
            return this;
        }

        public Builder withAttachments(List<SlackAttachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public SlackPreparedMessage build() {
            return new SlackPreparedMessage(this.message, this.unfurl, this.linkNames, this.attachments.toArray(new SlackAttachment[0]));
        }
    }
}

