/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.events;

import com.ullink.slack.simpleslackapi.SlackAttachment;
import com.ullink.slack.simpleslackapi.SlackBot;
import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackFile;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.events.SlackMessageEvent;
import java.util.ArrayList;
import java.util.Map;
import org.json.simple.JSONObject;

public interface SlackMessagePosted
extends SlackMessageEvent {
    public String getMessageContent();

    public SlackUser getSender();

    @Deprecated
    public SlackBot getBot();

    public SlackChannel getChannel();

    public SlackFile getSlackFile();

    public JSONObject getJsonSource();

    public String getTimestamp();

    public Map<String, Integer> getReactions();

    public int getTotalCountOfReactions();

    public MessageSubType getMessageSubType();

    public ArrayList<SlackAttachment> getAttachments();

    public static enum MessageSubType {
        BOT_MESSAGE("bot_message"),
        CHANNEL_ARCHIVE("channel_archive"),
        CHANNEL_JOIN("channel_join"),
        CHANNEL_LEAVE("channel_leave"),
        CHANNEL_LEFT("channel_left"),
        CHANNEL_NAME("channel_name"),
        CHANNEL_PURPOSE("channel_purpose"),
        CHANNEL_TOPIC("channel_topic"),
        CHANNEL_UNARCHIVE("channel_unarchive"),
        FILE_COMMENT("file_comment"),
        FILE_MENTION("file_mention"),
        FILE_SHARE("file_share"),
        GROUP_JOIN("group_join"),
        GROUP_LEAVE("group_leave"),
        GROUP_NAME("group_name"),
        GROUP_PURPOSE("group_purpose"),
        GROUP_TOPIC("group_topic"),
        GROUP_UNARCHIVE("group_unarchive"),
        ME_MESSAGE("me_message"),
        MESSAGE_CHANGED("message_changed"),
        MESSAGE_DELETED("message_deleted"),
        PINNED_ITEM("pinned_item"),
        UNPINNED_ITEM("unpinned_item"),
        UNKNOWN("");

        String code;

        private MessageSubType(String code) {
            this.code = code;
        }

        public static final MessageSubType fromCode(String code) {
            for (MessageSubType subType : MessageSubType.values()) {
                if (!subType.code.equals(code)) continue;
                return subType;
            }
            return UNKNOWN;
        }
    }
}

