/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackAction;
import com.ullink.slack.simpleslackapi.SlackAttachment;
import com.ullink.slack.simpleslackapi.SlackField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class SlackJSONAttachmentFormatter {
    SlackJSONAttachmentFormatter() {
    }

    public static List<JSONObject> encodeAttachments(SlackAttachment ... attachments) {
        ArrayList<JSONObject> toReturn = new ArrayList<JSONObject>();
        for (SlackAttachment attachment : attachments) {
            JSONObject attachmentJSON = new JSONObject();
            toReturn.add(attachmentJSON);
            if (attachment.getTitle() != null) {
                attachmentJSON.put((Object)"title", (Object)attachment.getTitle());
            }
            if (attachment.getThumbUrl() != null) {
                attachmentJSON.put((Object)"thumb_url", (Object)attachment.getThumbUrl());
            }
            if (attachment.getTitleLink() != null) {
                attachmentJSON.put((Object)"title_link", (Object)attachment.getTitleLink());
            }
            if (attachment.getText() != null) {
                attachmentJSON.put((Object)"text", (Object)attachment.getText());
            }
            if (attachment.getColor() != null) {
                attachmentJSON.put((Object)"color", (Object)attachment.getColor());
            }
            if (attachment.getPretext() != null) {
                attachmentJSON.put((Object)"pretext", (Object)attachment.getPretext());
            }
            if (attachment.getFallback() != null) {
                attachmentJSON.put((Object)"fallback", (Object)attachment.getFallback());
            }
            if (attachment.getCallbackId() != null) {
                attachmentJSON.put((Object)"callback_id", (Object)attachment.getCallbackId());
            }
            if (attachment.getAuthorName() != null) {
                attachmentJSON.put((Object)"author_name", (Object)attachment.getAuthorName());
            }
            if (attachment.getAuthorLink() != null) {
                attachmentJSON.put((Object)"author_link", (Object)attachment.getAuthorLink());
            }
            if (attachment.getAuthorIcon() != null) {
                attachmentJSON.put((Object)"author_icon", (Object)attachment.getAuthorIcon());
            }
            if (attachment.getImageUrl() != null) {
                attachmentJSON.put((Object)"image_url", (Object)attachment.getImageUrl());
            }
            if (attachment.getFooter() != null) {
                attachmentJSON.put((Object)"footer", (Object)attachment.getFooter());
            }
            if (attachment.getFooterIcon() != null) {
                attachmentJSON.put((Object)"footer_icon", (Object)attachment.getFooterIcon());
            }
            if (attachment.getMiscRootFields() != null) {
                for (Map.Entry<String, String> entry : attachment.getMiscRootFields().entrySet()) {
                    attachmentJSON.put((Object)entry.getKey(), (Object)entry.getValue());
                }
            }
            if (attachment.getMarkdown_in() != null && !attachment.getMarkdown_in().isEmpty()) {
                JSONArray array = new JSONArray();
                array.addAll(attachment.getMarkdown_in());
                attachmentJSON.put((Object)"mrkdwn_in", (Object)array);
            }
            if (attachment.getFields() != null && !attachment.getFields().isEmpty()) {
                attachmentJSON.put((Object)"fields", SlackJSONAttachmentFormatter.encodeAttachmentFields(attachment.getFields()));
            }
            if (attachment.getActions() == null || attachment.getActions().isEmpty()) continue;
            attachmentJSON.put((Object)"actions", SlackJSONAttachmentFormatter.encodeAttachmentActions(attachment.getActions()));
        }
        return toReturn;
    }

    private static List<JSONObject> encodeAttachmentFields(List<SlackField> fields) {
        ArrayList<JSONObject> toReturn = new ArrayList<JSONObject>();
        for (SlackField field : fields) {
            JSONObject fieldJSON = new JSONObject();
            toReturn.add(fieldJSON);
            if (field.getTitle() != null) {
                fieldJSON.put((Object)"title", (Object)field.getTitle());
            }
            if (field.getValue() != null) {
                fieldJSON.put((Object)"value", (Object)field.getValue());
            }
            fieldJSON.put((Object)"short", (Object)field.isShort());
        }
        return toReturn;
    }

    private static List<JSONObject> encodeAttachmentActions(List<SlackAction> actions) {
        ArrayList<JSONObject> toReturn = new ArrayList<JSONObject>();
        for (SlackAction action : actions) {
            JSONObject actionJSON = new JSONObject();
            toReturn.add(actionJSON);
            if (action.getName() != null) {
                actionJSON.put((Object)"name", (Object)action.getName());
            }
            if (action.getText() != null) {
                actionJSON.put((Object)"text", (Object)action.getText());
            }
            if (action.getType() != null) {
                actionJSON.put((Object)"type", (Object)action.getType());
            }
            if (action.getValue() == null) continue;
            actionJSON.put((Object)"value", (Object)action.getValue());
        }
        return toReturn;
    }
}

