/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackAttachment;
import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackFile;
import com.ullink.slack.simpleslackapi.SlackIntegration;
import com.ullink.slack.simpleslackapi.SlackPersona;
import com.ullink.slack.simpleslackapi.SlackSession;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.events.EventType;
import com.ullink.slack.simpleslackapi.events.PinAdded;
import com.ullink.slack.simpleslackapi.events.PinRemoved;
import com.ullink.slack.simpleslackapi.events.PresenceChange;
import com.ullink.slack.simpleslackapi.events.ReactionAdded;
import com.ullink.slack.simpleslackapi.events.ReactionRemoved;
import com.ullink.slack.simpleslackapi.events.SlackChannelArchived;
import com.ullink.slack.simpleslackapi.events.SlackChannelCreated;
import com.ullink.slack.simpleslackapi.events.SlackChannelDeleted;
import com.ullink.slack.simpleslackapi.events.SlackChannelJoined;
import com.ullink.slack.simpleslackapi.events.SlackChannelLeft;
import com.ullink.slack.simpleslackapi.events.SlackChannelRenamed;
import com.ullink.slack.simpleslackapi.events.SlackChannelUnarchived;
import com.ullink.slack.simpleslackapi.events.SlackEvent;
import com.ullink.slack.simpleslackapi.events.SlackGroupJoined;
import com.ullink.slack.simpleslackapi.events.SlackMessagePosted;
import com.ullink.slack.simpleslackapi.events.SlackUserChange;
import com.ullink.slack.simpleslackapi.impl.PinAddedImpl;
import com.ullink.slack.simpleslackapi.impl.PinRemovedImpl;
import com.ullink.slack.simpleslackapi.impl.PresenceChangeImpl;
import com.ullink.slack.simpleslackapi.impl.ReactionAddedImpl;
import com.ullink.slack.simpleslackapi.impl.ReactionRemovedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelArchivedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelCreatedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelDeletedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelJoinedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelLeftImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelRenamedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackChannelUnarchivedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackGroupJoinedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackIntegrationUser;
import com.ullink.slack.simpleslackapi.impl.SlackJSONParsingUtils;
import com.ullink.slack.simpleslackapi.impl.SlackMessageDeletedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackMessagePostedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackMessageUpdatedImpl;
import com.ullink.slack.simpleslackapi.impl.SlackUserChangeImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class SlackJSONMessageParser {
    private static final String COMMENT_PLACEHOLDER = "> and commented:";

    SlackJSONMessageParser() {
    }

    static SlackEvent decode(SlackSession slackSession, JSONObject obj) {
        String type = (String)obj.get((Object)"type");
        if (type == null) {
            return SlackEvent.UNKNOWN_EVENT;
        }
        EventType eventType = EventType.getByCode(type);
        switch (eventType) {
            case MESSAGE: {
                return SlackJSONMessageParser.extractMessageEvent(slackSession, obj);
            }
            case CHANNEL_CREATED: {
                return SlackJSONMessageParser.extractChannelCreatedEvent(slackSession, obj);
            }
            case CHANNEL_ARCHIVE: {
                return SlackJSONMessageParser.extractChannelArchiveEvent(slackSession, obj);
            }
            case CHANNEL_DELETED: {
                return SlackJSONMessageParser.extractChannelDeletedEvent(slackSession, obj);
            }
            case CHANNEL_RENAME: {
                return SlackJSONMessageParser.extractChannelRenamedEvent(slackSession, obj);
            }
            case CHANNEL_UNARCHIVE: {
                return SlackJSONMessageParser.extractChannelUnarchiveEvent(slackSession, obj);
            }
            case CHANNEL_JOINED: {
                return SlackJSONMessageParser.extractChannelJoinedEvent(slackSession, obj);
            }
            case CHANNEL_LEFT: {
                return SlackJSONMessageParser.extractChannelLeftEvent(slackSession, obj);
            }
            case GROUP_JOINED: {
                return SlackJSONMessageParser.extractGroupJoinedEvent(slackSession, obj);
            }
            case REACTION_ADDED: {
                return SlackJSONMessageParser.extractReactionAddedEvent(slackSession, obj);
            }
            case REACTION_REMOVED: {
                return SlackJSONMessageParser.extractReactionRemovedEvent(slackSession, obj);
            }
            case USER_CHANGE: {
                return SlackJSONMessageParser.extractUserChangeEvent(slackSession, obj);
            }
            case PRESENCE_CHANGE: {
                return SlackJSONMessageParser.extractPresenceChangeEvent(slackSession, obj);
            }
            case PIN_ADDED: {
                return SlackJSONMessageParser.extractPinAddedEvent(slackSession, obj);
            }
            case PIN_REMOVED: {
                return SlackJSONMessageParser.extractPinRemovedEvent(slackSession, obj);
            }
        }
        return SlackEvent.UNKNOWN_EVENT;
    }

    private static SlackChannelJoined extractChannelJoinedEvent(SlackSession slackSession, JSONObject obj) {
        JSONObject channelJSONObject = (JSONObject)obj.get((Object)"channel");
        SlackChannel slackChannel = SlackJSONMessageParser.parseChannelDescription(channelJSONObject);
        return new SlackChannelJoinedImpl(slackChannel);
    }

    private static SlackChannelLeft extractChannelLeftEvent(SlackSession slackSession, JSONObject obj) {
        String channelId = (String)obj.get((Object)"channel");
        SlackChannel slackChannel = slackSession.findChannelById(channelId);
        return new SlackChannelLeftImpl(slackChannel);
    }

    private static SlackGroupJoined extractGroupJoinedEvent(SlackSession slackSession, JSONObject obj) {
        JSONObject channelJSONObject = (JSONObject)obj.get((Object)"channel");
        SlackChannel slackChannel = SlackJSONMessageParser.parseChannelDescription(channelJSONObject);
        return new SlackGroupJoinedImpl(slackChannel);
    }

    private static SlackChannelRenamed extractChannelRenamedEvent(SlackSession slackSession, JSONObject obj) {
        String channelId = (String)obj.get((Object)"channel");
        String newName = (String)obj.get((Object)"name");
        return new SlackChannelRenamedImpl(slackSession.findChannelById(channelId), newName);
    }

    private static SlackChannelDeleted extractChannelDeletedEvent(SlackSession slackSession, JSONObject obj) {
        String channelId = (String)obj.get((Object)"channel");
        return new SlackChannelDeletedImpl(slackSession.findChannelById(channelId));
    }

    private static SlackChannelUnarchived extractChannelUnarchiveEvent(SlackSession slackSession, JSONObject obj) {
        String channelId = (String)obj.get((Object)"channel");
        String userId = (String)obj.get((Object)"user");
        return new SlackChannelUnarchivedImpl(slackSession.findChannelById(channelId), slackSession.findUserById(userId));
    }

    private static SlackChannelArchived extractChannelArchiveEvent(SlackSession slackSession, JSONObject obj) {
        String channelId = (String)obj.get((Object)"channel");
        String userId = (String)obj.get((Object)"user");
        return new SlackChannelArchivedImpl(slackSession.findChannelById(channelId), slackSession.findUserById(userId));
    }

    private static SlackChannelCreated extractChannelCreatedEvent(SlackSession slackSession, JSONObject obj) {
        JSONObject channelJSONObject = (JSONObject)obj.get((Object)"channel");
        SlackChannel channel = SlackJSONMessageParser.parseChannelDescription(channelJSONObject);
        String creatorId = (String)channelJSONObject.get((Object)"creator");
        SlackUser user = slackSession.findUserById(creatorId);
        return new SlackChannelCreatedImpl(channel, user);
    }

    private static SlackEvent extractMessageEvent(SlackSession slackSession, JSONObject obj) {
        String channelId = (String)obj.get((Object)"channel");
        SlackChannel channel = SlackJSONMessageParser.getChannel(slackSession, channelId);
        String ts = (String)obj.get((Object)"ts");
        SlackMessageSubType subType = SlackMessageSubType.getByCode((String)obj.get((Object)"subtype"));
        switch (subType) {
            case MESSAGE_CHANGED: {
                return SlackJSONMessageParser.parseMessageUpdated(obj, channel, ts);
            }
            case MESSAGE_DELETED: {
                return SlackJSONMessageParser.parseMessageDeleted(obj, channel, ts);
            }
            case FILE_SHARE: {
                return SlackJSONMessageParser.parseMessagePublishedWithFile(obj, channel, ts, slackSession);
            }
        }
        return SlackJSONMessageParser.parseMessagePublished(obj, channel, ts, slackSession);
    }

    private static SlackChannel getChannel(SlackSession slackSession, String channelId) {
        if (channelId != null) {
            if (channelId.startsWith("D")) {
                return new SlackChannelImpl(channelId, channelId, "", "", true, false);
            }
            return slackSession.findChannelById(channelId);
        }
        return null;
    }

    private static SlackMessageUpdatedImpl parseMessageUpdated(JSONObject obj, SlackChannel channel, String ts) {
        JSONObject message = (JSONObject)obj.get((Object)"message");
        String text = (String)message.get((Object)"text");
        String messageTs = (String)message.get((Object)"ts");
        SlackMessageUpdatedImpl toto = new SlackMessageUpdatedImpl(channel, messageTs, ts, text);
        ArrayList<SlackAttachment> attachments = SlackJSONMessageParser.extractAttachmentsFromMessageJSON(message);
        toto.setAttachments(attachments);
        return toto;
    }

    private static SlackMessageDeletedImpl parseMessageDeleted(JSONObject obj, SlackChannel channel, String ts) {
        String deletedTs = (String)obj.get((Object)"deleted_ts");
        return new SlackMessageDeletedImpl(channel, deletedTs, ts);
    }

    private static SlackMessagePostedImpl parseMessagePublished(JSONObject obj, SlackChannel channel, String ts, SlackSession slackSession) {
        String text = (String)obj.get((Object)"text");
        String userId = (String)obj.get((Object)"user");
        if (userId == null) {
            userId = (String)obj.get((Object)"bot_id");
        }
        String subtype = (String)obj.get((Object)"subtype");
        SlackUser user = slackSession.findUserById(userId);
        if (user == null) {
            SlackIntegration integration = slackSession.findIntegrationById(userId);
            if (integration == null) {
                throw new IllegalStateException("unknown user id: " + userId);
            }
            user = new SlackIntegrationUser(integration);
        }
        Map<String, Integer> reacs = SlackJSONMessageParser.extractReactionsFromMessageJSON(obj);
        ArrayList<SlackAttachment> attachments = SlackJSONMessageParser.extractAttachmentsFromMessageJSON(obj);
        SlackMessagePostedImpl message = new SlackMessagePostedImpl(text, null, user, channel, ts, null, obj, SlackMessagePosted.MessageSubType.fromCode(subtype));
        message.setReactions(reacs);
        message.setAttachments(attachments);
        return message;
    }

    private static void parseSlackFileFromRaw(JSONObject rawFile, SlackFile file) {
        file.setId((String)rawFile.get((Object)"id"));
        file.setName((String)rawFile.get((Object)"name"));
        file.setTitle((String)rawFile.get((Object)"title"));
        file.setMimetype((String)rawFile.get((Object)"mimetype"));
        file.setFiletype((String)rawFile.get((Object)"filetype"));
        file.setUrl((String)rawFile.get((Object)"url"));
        file.setUrlDownload((String)rawFile.get((Object)"url_download"));
        file.setUrlPrivate((String)rawFile.get((Object)"url_private"));
        file.setUrlPrivateDownload((String)rawFile.get((Object)"url_private_download"));
        file.setThumb64((String)rawFile.get((Object)"thumb_64"));
        file.setThumb80((String)rawFile.get((Object)"thumb_80"));
        file.setThumb160((String)rawFile.get((Object)"thumb_160"));
        file.setThumb360((String)rawFile.get((Object)"thumb_360"));
        file.setThumb480((String)rawFile.get((Object)"thumb_480"));
        file.setThumb720((String)rawFile.get((Object)"thumb_720"));
        try {
            file.setOriginalH((Long)rawFile.get((Object)"original_h"));
            file.setOriginalW((Long)rawFile.get((Object)"original_w"));
            file.setImageExifRotation((Long)rawFile.get((Object)"image_exif_rotation"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        file.setPermalink((String)rawFile.get((Object)"permalink"));
        file.setPermalinkPublic((String)rawFile.get((Object)"permalink_public"));
    }

    private static SlackMessagePostedImpl parseMessagePublishedWithFile(JSONObject obj, SlackChannel channel, String ts, SlackSession slackSession) {
        SlackFile file = new SlackFile();
        if (obj.get((Object)"file") != null) {
            JSONObject rawFile = (JSONObject)obj.get((Object)"file");
            SlackJSONMessageParser.parseSlackFileFromRaw(rawFile, file);
        }
        String text = (String)obj.get((Object)"text");
        String subtype = (String)obj.get((Object)"subtype");
        String comment = null;
        int idx = text.indexOf(COMMENT_PLACEHOLDER);
        if (idx != -1) {
            comment = text.substring(idx + COMMENT_PLACEHOLDER.length());
        }
        file.setComment(comment);
        String userId = (String)obj.get((Object)"user");
        SlackUser user = slackSession.findUserById(userId);
        return new SlackMessagePostedImpl(text, user, user, channel, ts, file, obj, SlackMessagePosted.MessageSubType.fromCode(subtype));
    }

    private static SlackChannel parseChannelDescription(JSONObject channelJSONObject) {
        String id = (String)channelJSONObject.get((Object)"id");
        String name = (String)channelJSONObject.get((Object)"name");
        String topic = (String)((Map)channelJSONObject.get((Object)"topic")).get("value");
        String purpose = (String)((Map)channelJSONObject.get((Object)"purpose")).get("value");
        return new SlackChannelImpl(id, name, topic, purpose, id.startsWith("D"), id.startsWith("D"));
    }

    private static ReactionAdded extractReactionAddedEvent(SlackSession slackSession, JSONObject obj) {
        JSONObject item = (JSONObject)obj.get((Object)"item");
        String emojiName = (String)obj.get((Object)"reaction");
        String messageId = (String)item.get((Object)"ts");
        String fileId = (String)item.get((Object)"file");
        String fileCommentId = (String)item.get((Object)"file_comment");
        String channelId = (String)item.get((Object)"channel");
        SlackChannel channel = channelId != null ? slackSession.findChannelById(channelId) : null;
        SlackUser user = slackSession.findUserById((String)obj.get((Object)"user"));
        return new ReactionAddedImpl(emojiName, user, channel, messageId, fileId, fileCommentId);
    }

    private static SlackUserChange extractUserChangeEvent(SlackSession slackSession, JSONObject obj) {
        JSONObject user = (JSONObject)obj.get((Object)"user");
        SlackUser slackUser = SlackJSONParsingUtils.buildSlackUser(user);
        return new SlackUserChangeImpl(slackUser);
    }

    private static PresenceChange extractPresenceChangeEvent(SlackSession slackSession, JSONObject obj) {
        String userId = (String)obj.get((Object)"user");
        String presence = (String)obj.get((Object)"presence");
        SlackPersona.SlackPresence value = SlackPersona.SlackPresence.UNKNOWN;
        if ("active".equals(presence)) {
            value = SlackPersona.SlackPresence.ACTIVE;
        } else if ("away".equals(presence)) {
            value = SlackPersona.SlackPresence.AWAY;
        }
        return new PresenceChangeImpl(userId, value);
    }

    private static ReactionRemoved extractReactionRemovedEvent(SlackSession slackSession, JSONObject obj) {
        JSONObject item = (JSONObject)obj.get((Object)"item");
        String emojiName = (String)obj.get((Object)"reaction");
        String messageId = (String)item.get((Object)"ts");
        String fileId = (String)item.get((Object)"file");
        String fileCommentId = (String)item.get((Object)"file_comment");
        String channelId = (String)item.get((Object)"channel");
        SlackChannel channel = channelId != null ? slackSession.findChannelById(channelId) : null;
        SlackUser user = slackSession.findUserById((String)obj.get((Object)"user"));
        return new ReactionRemovedImpl(emojiName, user, channel, messageId, fileId, fileCommentId);
    }

    private static PinRemoved extractPinRemovedEvent(SlackSession slackSession, JSONObject obj) {
        String senderId = (String)obj.get((Object)"user");
        SlackUser sender = slackSession.findUserById(senderId);
        String channelId = (String)obj.get((Object)"channel_id");
        SlackChannel channel = slackSession.findChannelById(channelId);
        JSONObject item = (JSONObject)obj.get((Object)"item");
        String messageType = (String)item.get((Object)"type");
        SlackFile file = null;
        String message = null;
        if ("file".equals(messageType)) {
            file = new SlackFile();
            SlackJSONMessageParser.parseSlackFileFromRaw((JSONObject)item.get((Object)"file"), file);
        } else if ("message".equals(messageType)) {
            JSONObject messageObj = (JSONObject)item.get((Object)"message");
            message = (String)messageObj.get((Object)"text");
        }
        String timestamp = (String)obj.get((Object)"event_ts");
        return new PinRemovedImpl(sender, channel, timestamp, file, message);
    }

    private static PinAdded extractPinAddedEvent(SlackSession slackSession, JSONObject obj) {
        String senderId = (String)obj.get((Object)"user");
        SlackUser sender = slackSession.findUserById(senderId);
        String channelId = (String)obj.get((Object)"channel_id");
        SlackChannel channel = slackSession.findChannelById(channelId);
        JSONObject item = (JSONObject)obj.get((Object)"item");
        String messageType = (String)item.get((Object)"type");
        SlackFile file = null;
        String message = null;
        if ("file".equals(messageType)) {
            file = new SlackFile();
            SlackJSONMessageParser.parseSlackFileFromRaw((JSONObject)item.get((Object)"file"), file);
        } else if ("message".equals(messageType)) {
            JSONObject messageObj = (JSONObject)item.get((Object)"message");
            message = (String)messageObj.get((Object)"text");
        }
        String timestamp = (String)obj.get((Object)"event_ts");
        return new PinAddedImpl(sender, channel, timestamp, file, message);
    }

    private static Map<String, Integer> extractReactionsFromMessageJSON(JSONObject obj) {
        HashMap<String, Integer> reacs = new HashMap<String, Integer>();
        JSONArray rawReactions = (JSONArray)obj.get((Object)"reactions");
        if (rawReactions != null) {
            for (Object rawReaction : rawReactions) {
                JSONObject reaction = (JSONObject)rawReaction;
                String emojiCode = reaction.get((Object)"name").toString();
                Integer count = Integer.valueOf(reaction.get((Object)"count").toString());
                reacs.put(emojiCode, count);
            }
        }
        return reacs;
    }

    public static Map<String, String> extractEmojisFromMessageJSON(JSONObject object) {
        HashMap<String, String> emojis = new HashMap<String, String>();
        for (Object o : object.entrySet()) {
            Map.Entry entry = (Map.Entry)o;
            emojis.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return emojis;
    }

    private static ArrayList<SlackAttachment> extractAttachmentsFromMessageJSON(JSONObject object) {
        if (object.get((Object)"attachments") == null) {
            return new ArrayList<SlackAttachment>();
        }
        ArrayList<SlackAttachment> attachments = new ArrayList<SlackAttachment>();
        for (Object o : (JSONArray)object.get((Object)"attachments")) {
            JSONObject obj = (JSONObject)o;
            SlackAttachment slackAttachment = new SlackAttachment();
            slackAttachment.setFallback((String)obj.get((Object)"fallback"));
            slackAttachment.setColor((String)obj.get((Object)"color"));
            slackAttachment.setPretext((String)obj.get((Object)"pretext"));
            slackAttachment.setAuthorName((String)obj.get((Object)"author_name"));
            slackAttachment.setAuthorLink((String)obj.get((Object)"author_link"));
            slackAttachment.setAuthorIcon((String)obj.get((Object)"author_icon"));
            slackAttachment.setTitle((String)obj.get((Object)"title"));
            slackAttachment.setTitleLink((String)obj.get((Object)"title_link"));
            slackAttachment.setText((String)obj.get((Object)"text"));
            slackAttachment.setThumbUrl((String)obj.get((Object)"thumb_url"));
            slackAttachment.setImageUrl((String)obj.get((Object)"image_url"));
            slackAttachment.setFooter((String)obj.get((Object)"footer"));
            slackAttachment.setFooterIcon((String)obj.get((Object)"footer_icon"));
            if (obj.get((Object)"fields") != null) {
                for (Object field : (JSONArray)obj.get((Object)"fields")) {
                    JSONObject f = (JSONObject)field;
                    slackAttachment.addField((String)f.get((Object)"title"), (String)f.get((Object)"value"), (Boolean)f.get((Object)"short"));
                }
            }
            attachments.add(slackAttachment);
        }
        return attachments;
    }

    public static enum SlackMessageSubType {
        CHANNEL_JOIN("channel_join"),
        CHANNEL_LEAVE("channel_leave"),
        MESSAGE_CHANGED("message_changed"),
        MESSAGE_DELETED("message_deleted"),
        OTHER("-"),
        FILE_SHARE("file_share");

        private static final Map<String, SlackMessageSubType> CODE_MAP;
        String code;

        public static SlackMessageSubType getByCode(String code) {
            SlackMessageSubType toReturn = CODE_MAP.get(code);
            if (toReturn == null) {
                return OTHER;
            }
            return toReturn;
        }

        private SlackMessageSubType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        static {
            CODE_MAP = new HashMap<String, SlackMessageSubType>();
            for (SlackMessageSubType enumValue : SlackMessageSubType.values()) {
                CODE_MAP.put(enumValue.getCode(), enumValue);
            }
        }
    }
}

