/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackIntegration;
import com.ullink.slack.simpleslackapi.SlackPersona;
import com.ullink.slack.simpleslackapi.SlackTeam;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.impl.SlackChannelImpl;
import com.ullink.slack.simpleslackapi.impl.SlackIntegrationImpl;
import com.ullink.slack.simpleslackapi.impl.SlackTeamImpl;
import com.ullink.slack.simpleslackapi.impl.SlackUserImpl;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class SlackJSONParsingUtils {
    private SlackJSONParsingUtils() {
    }

    static final SlackUser buildSlackUser(JSONObject jsonUser) {
        String id = (String)jsonUser.get((Object)"id");
        String name = (String)jsonUser.get((Object)"name");
        String realName = (String)jsonUser.get((Object)"real_name");
        String tz = (String)jsonUser.get((Object)"tz");
        String tzLabel = (String)jsonUser.get((Object)"tz_label");
        Long tzOffset = (Long)jsonUser.get((Object)"tz_offset");
        Boolean deleted = SlackJSONParsingUtils.ifNullFalse(jsonUser, "deleted");
        Boolean admin = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_admin");
        Boolean owner = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_owner");
        Boolean primaryOwner = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_primary_owner");
        Boolean restricted = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_restricted");
        Boolean ultraRestricted = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_ultra_restricted");
        Boolean bot = SlackJSONParsingUtils.ifNullFalse(jsonUser, "is_bot");
        JSONObject profileJSON = (JSONObject)jsonUser.get((Object)"profile");
        String email = "";
        String skype = "";
        String title = "";
        String phone = "";
        if (profileJSON != null) {
            email = (String)profileJSON.get((Object)"email");
            skype = (String)profileJSON.get((Object)"skype");
            title = (String)profileJSON.get((Object)"title");
            phone = (String)profileJSON.get((Object)"phone");
        }
        String presence = (String)jsonUser.get((Object)"presence");
        SlackPersona.SlackPresence slackPresence = SlackPersona.SlackPresence.UNKNOWN;
        if ("active".equals(presence)) {
            slackPresence = SlackPersona.SlackPresence.ACTIVE;
        }
        if ("away".equals(presence)) {
            slackPresence = SlackPersona.SlackPresence.AWAY;
        }
        return new SlackUserImpl(id, name, realName, email, skype, title, phone, deleted, admin, owner, primaryOwner, restricted, ultraRestricted, bot, tz, tzLabel, tzOffset == null ? null : new Integer(tzOffset.intValue()), slackPresence);
    }

    private static Boolean ifNullFalse(JSONObject jsonUser, String field) {
        Boolean deleted = (Boolean)jsonUser.get((Object)field);
        if (deleted == null) {
            deleted = false;
        }
        return deleted;
    }

    static final SlackChannelImpl buildSlackChannel(JSONObject jsonChannel, Map<String, SlackUser> knownUsersById) {
        String id = (String)jsonChannel.get((Object)"id");
        String name = (String)jsonChannel.get((Object)"name");
        String topic = null;
        if (jsonChannel.containsKey((Object)"topic")) {
            JSONObject jsonTopic = (JSONObject)jsonChannel.get((Object)"topic");
            topic = (String)jsonTopic.get((Object)"value");
        }
        String purpose = null;
        if (jsonChannel.containsKey((Object)"purpose")) {
            JSONObject jsonPurpose = (JSONObject)jsonChannel.get((Object)"purpose");
            purpose = (String)jsonPurpose.get((Object)"value");
        }
        boolean isMember = false;
        if (jsonChannel.containsKey((Object)"is_member")) {
            isMember = (Boolean)jsonChannel.get((Object)"is_member");
        }
        SlackChannelImpl toReturn = new SlackChannelImpl(id, name, topic, purpose, false, isMember);
        JSONArray membersJson = (JSONArray)jsonChannel.get((Object)"members");
        if (membersJson != null) {
            for (Object jsonMembersObject : membersJson) {
                String memberId = (String)jsonMembersObject;
                SlackUser user = knownUsersById.get(memberId);
                toReturn.addUser(user);
            }
        }
        return toReturn;
    }

    static final SlackChannelImpl buildSlackImChannel(JSONObject jsonChannel, Map<String, SlackUser> knownUsersById) {
        String id = (String)jsonChannel.get((Object)"id");
        SlackChannelImpl toReturn = new SlackChannelImpl(id, null, null, null, true, false);
        String memberId = (String)jsonChannel.get((Object)"user");
        SlackUser user = knownUsersById.get(memberId);
        toReturn.addUser(user);
        return toReturn;
    }

    static final SlackTeam buildSlackTeam(JSONObject jsonTeam) {
        String id = (String)jsonTeam.get((Object)"id");
        String name = (String)jsonTeam.get((Object)"name");
        String domain = (String)jsonTeam.get((Object)"domain");
        return new SlackTeamImpl(id, name, domain);
    }

    static final SlackIntegration buildSlackIntegration(JSONObject jsonIntegration) {
        String id = (String)jsonIntegration.get((Object)"id");
        String name = (String)jsonIntegration.get((Object)"name");
        boolean deleted = SlackJSONParsingUtils.ifNullFalse(jsonIntegration, "deleted");
        return new SlackIntegrationImpl(id, name, deleted);
    }
}

