/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackSession;
import com.ullink.slack.simpleslackapi.impl.SlackChannelReplyImpl;
import com.ullink.slack.simpleslackapi.impl.SlackEmojiReplyImpl;
import com.ullink.slack.simpleslackapi.impl.SlackJSONMessageParser;
import com.ullink.slack.simpleslackapi.impl.SlackMessageReplyImpl;
import com.ullink.slack.simpleslackapi.impl.SlackReplyImpl;
import com.ullink.slack.simpleslackapi.impl.SlackUserPresenceReplyImpl;
import com.ullink.slack.simpleslackapi.replies.ParsedSlackReply;
import com.ullink.slack.simpleslackapi.replies.SlackChannelReply;
import org.json.simple.JSONObject;

class SlackJSONReplyParser {
    SlackJSONReplyParser() {
    }

    static ParsedSlackReply decode(JSONObject obj, SlackSession session) {
        Boolean ok = (Boolean)obj.get((Object)"ok");
        String error = (String)obj.get((Object)"error");
        String presence = (String)obj.get((Object)"presence");
        if (presence != null) {
            return new SlackUserPresenceReplyImpl(ok, error, "active".equals(presence));
        }
        if (SlackJSONReplyParser.isMpim(obj) || SlackJSONReplyParser.isIm(obj) || SlackJSONReplyParser.isChannel(obj) || SlackJSONReplyParser.isGroup(obj)) {
            return SlackJSONReplyParser.buildSlackChannelReply(ok, error, obj, session);
        }
        if (SlackJSONReplyParser.isMessageReply(obj)) {
            Long replyTo = (Long)obj.get((Object)"reply_to");
            String timestamp = (String)obj.get((Object)"ts");
            return new SlackMessageReplyImpl(ok, error, obj, replyTo != null ? replyTo : -1L, timestamp);
        }
        if (SlackJSONReplyParser.isEmojiReply(obj)) {
            String timestamp = (String)obj.get((Object)"cache_ts");
            return new SlackEmojiReplyImpl(ok, error, SlackJSONMessageParser.extractEmojisFromMessageJSON((JSONObject)obj.get((Object)"emoji")), timestamp);
        }
        if (ok == null) {
            ok = Boolean.FALSE;
        }
        return new SlackReplyImpl(ok, error);
    }

    private static SlackChannelReply buildSlackChannelReply(Boolean ok, String error, JSONObject obj, SlackSession session) {
        String id = (String)obj.get((Object)"id");
        if (id != null) {
            return new SlackChannelReplyImpl(ok, error, obj, session.findChannelById(id));
        }
        JSONObject channelObj = (JSONObject)obj.get((Object)"channel");
        if (channelObj == null) {
            channelObj = (JSONObject)obj.get((Object)"group");
        }
        id = (String)channelObj.get((Object)"id");
        return new SlackChannelReplyImpl(ok, error, obj, session.findChannelById(id));
    }

    private static boolean isMessageReply(JSONObject obj) {
        return obj.get((Object)"ts") != null;
    }

    private static boolean isMpim(JSONObject obj) {
        Boolean isMpim = (Boolean)obj.get((Object)"is_mpim");
        return isMpim != null && isMpim.equals(Boolean.TRUE);
    }

    private static boolean isIm(JSONObject obj) {
        Boolean isIm = (Boolean)obj.get((Object)"is_im");
        return isIm != null && isIm.equals(Boolean.TRUE);
    }

    private static boolean isChannel(JSONObject obj) {
        Object channel = obj.get((Object)"channel");
        return channel != null && channel instanceof JSONObject;
    }

    private static boolean isGroup(JSONObject obj) {
        Boolean isGroup = (Boolean)obj.get((Object)"is_group");
        if (isGroup != null) {
            return isGroup;
        }
        Object group = obj.get((Object)"group");
        return group != null && group instanceof JSONObject;
    }

    private static boolean isEmojiReply(JSONObject obj) {
        Object emoji = obj.get((Object)"emoji");
        return emoji != null && emoji instanceof JSONObject;
    }
}

