/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackIntegration;
import com.ullink.slack.simpleslackapi.SlackPersona;
import com.ullink.slack.simpleslackapi.SlackTeam;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.impl.SlackChannelImpl;
import com.ullink.slack.simpleslackapi.impl.SlackJSONParsingUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SlackJSONSessionStatusParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackJSONSessionStatusParser.class);
    private Map<String, SlackChannel> channels = new HashMap<String, SlackChannel>();
    private Map<String, SlackUser> users = new HashMap<String, SlackUser>();
    private Map<String, SlackIntegration> integrations = new HashMap<String, SlackIntegration>();
    private SlackPersona sessionPersona;
    private SlackTeam team;
    private String webSocketURL;
    private String toParse;
    private String error;

    SlackJSONSessionStatusParser(String toParse) {
        this.toParse = toParse;
    }

    Map<String, SlackChannel> getChannels() {
        return this.channels;
    }

    Map<String, SlackUser> getUsers() {
        return this.users;
    }

    Map<String, SlackIntegration> getIntegrations() {
        return this.integrations;
    }

    public String getWebSocketURL() {
        return this.webSocketURL;
    }

    public String getError() {
        return this.error;
    }

    void parse() throws ParseException {
        LOGGER.debug("parsing session status : " + this.toParse);
        JSONParser parser = new JSONParser();
        JSONObject jsonResponse = (JSONObject)parser.parse(this.toParse);
        Boolean ok = (Boolean)jsonResponse.get((Object)"ok");
        if (Boolean.FALSE.equals(ok)) {
            this.error = (String)jsonResponse.get((Object)"error");
            return;
        }
        JSONArray usersJson = (JSONArray)jsonResponse.get((Object)"users");
        for (Object jsonObject : usersJson) {
            JSONObject jsonUser = (JSONObject)jsonObject;
            SlackUser slackUser = SlackJSONParsingUtils.buildSlackUser(jsonUser);
            LOGGER.debug("slack user found : " + slackUser.getId());
            this.users.put(slackUser.getId(), slackUser);
        }
        JSONArray integrationsJson = (JSONArray)jsonResponse.get((Object)"bots");
        if (integrationsJson != null) {
            for (Iterator jsonObject : integrationsJson) {
                JSONObject jsonIntegration = (JSONObject)jsonObject;
                SlackIntegration slackIntegration = SlackJSONParsingUtils.buildSlackIntegration(jsonIntegration);
                LOGGER.debug("slack integration found : " + slackIntegration.getId());
                this.integrations.put(slackIntegration.getId(), slackIntegration);
            }
        }
        JSONArray channelsJson = (JSONArray)jsonResponse.get((Object)"channels");
        for (Object jsonObject : channelsJson) {
            JSONObject jsonChannel = (JSONObject)jsonObject;
            SlackChannelImpl channel = SlackJSONParsingUtils.buildSlackChannel(jsonChannel, this.users);
            LOGGER.debug("slack public channel found : " + channel.getId());
            this.channels.put(channel.getId(), channel);
        }
        JSONArray groupsJson = (JSONArray)jsonResponse.get((Object)"groups");
        for (Object jsonObject : groupsJson) {
            JSONObject jsonChannel = (JSONObject)jsonObject;
            SlackChannelImpl channel = SlackJSONParsingUtils.buildSlackChannel(jsonChannel, this.users);
            LOGGER.debug("slack private group found : " + channel.getId());
            this.channels.put(channel.getId(), channel);
        }
        JSONArray imsJson = (JSONArray)jsonResponse.get((Object)"ims");
        for (Object jsonObject : imsJson) {
            JSONObject jsonChannel = (JSONObject)jsonObject;
            SlackChannelImpl channel = SlackJSONParsingUtils.buildSlackImChannel(jsonChannel, this.users);
            LOGGER.debug("slack im channel found : " + channel.getId());
            this.channels.put(channel.getId(), channel);
        }
        JSONObject selfJson = (JSONObject)jsonResponse.get((Object)"self");
        this.sessionPersona = SlackJSONParsingUtils.buildSlackUser(selfJson);
        JSONObject teamJson = (JSONObject)jsonResponse.get((Object)"team");
        this.team = SlackJSONParsingUtils.buildSlackTeam(teamJson);
        this.webSocketURL = (String)jsonResponse.get((Object)"url");
    }

    public SlackPersona getSessionPersona() {
        return this.sessionPersona;
    }

    public SlackTeam getTeam() {
        return this.team;
    }
}

