/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackIntegration;
import com.ullink.slack.simpleslackapi.SlackPersona;
import com.ullink.slack.simpleslackapi.SlackTeam;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.impl.SlackChannelImpl;
import com.ullink.slack.simpleslackapi.impl.SlackJSONParsingUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SlackJSONSessionStatusParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackJSONSessionStatusParser.class);
    private Map<String, SlackChannel> channels = new HashMap<String, SlackChannel>();
    private Map<String, SlackUser> users = new HashMap<String, SlackUser>();
    private Map<String, SlackIntegration> integrations = new HashMap<String, SlackIntegration>();
    private SlackPersona sessionPersona;
    private SlackTeam team;
    private String webSocketURL;
    private String toParse;
    private String error;

    SlackJSONSessionStatusParser(String toParse) {
        this.toParse = toParse;
    }

    Map<String, SlackChannel> getChannels() {
        return this.channels;
    }

    Map<String, SlackUser> getUsers() {
        return this.users;
    }

    Map<String, SlackIntegration> getIntegrations() {
        return this.integrations;
    }

    public String getWebSocketURL() {
        return this.webSocketURL;
    }

    public String getError() {
        return this.error;
    }

    void parse() {
        SlackChannelImpl channel;
        JsonObject jsonChannel;
        LOGGER.debug("parsing session status : " + this.toParse);
        JsonParser parser = new JsonParser();
        JsonObject jsonResponse = parser.parse(this.toParse).getAsJsonObject();
        Boolean ok = jsonResponse.get("ok").getAsBoolean();
        if (Boolean.FALSE.equals(ok)) {
            this.error = jsonResponse.get("error").getAsString();
            return;
        }
        JsonArray usersJson = jsonResponse.get("users").getAsJsonArray();
        for (Object jsonObject : usersJson) {
            JsonObject jsonUser = jsonObject.getAsJsonObject();
            SlackUser slackUser = SlackJSONParsingUtils.buildSlackUser(jsonUser);
            LOGGER.debug("slack user found : " + slackUser.getId());
            this.users.put(slackUser.getId(), slackUser);
        }
        if (jsonResponse.get("bots") != null) {
            JsonArray integrationsJson = jsonResponse.get("bots").getAsJsonArray();
            for (JsonElement jsonElement : integrationsJson) {
                JsonObject jsonIntegration = jsonElement.getAsJsonObject();
                SlackIntegration slackIntegration = SlackJSONParsingUtils.buildSlackIntegration(jsonIntegration);
                LOGGER.debug("slack integration found : " + slackIntegration.getId());
                this.integrations.put(slackIntegration.getId(), slackIntegration);
            }
        }
        JsonArray channelsJson = jsonResponse.get("channels").getAsJsonArray();
        for (Object jsonObject : channelsJson) {
            JsonObject jsonChannel2 = jsonObject.getAsJsonObject();
            SlackChannelImpl channel2 = SlackJSONParsingUtils.buildSlackChannel(jsonChannel2, this.users);
            LOGGER.debug("slack public channel found : " + channel2.getId());
            this.channels.put(channel2.getId(), channel2);
        }
        if (jsonResponse.get("groups") != null) {
            JsonArray groupsJson = jsonResponse.get("groups").getAsJsonArray();
            for (JsonElement jsonObject : groupsJson) {
                jsonChannel = jsonObject.getAsJsonObject();
                channel = SlackJSONParsingUtils.buildSlackChannel(jsonChannel, this.users);
                LOGGER.debug("slack private group found : " + channel.getId());
                this.channels.put(channel.getId(), channel);
            }
        }
        if (jsonResponse.get("ims") != null) {
            JsonArray imsJson = jsonResponse.get("ims").getAsJsonArray();
            for (JsonElement jsonObject : imsJson) {
                jsonChannel = jsonObject.getAsJsonObject();
                channel = SlackJSONParsingUtils.buildSlackImChannel(jsonChannel, this.users);
                LOGGER.debug("slack im channel found : " + channel.getId());
                this.channels.put(channel.getId(), channel);
            }
        }
        JsonObject selfJson = jsonResponse.get("self").getAsJsonObject();
        this.sessionPersona = SlackJSONParsingUtils.buildSlackUser(selfJson);
        JsonObject teamJson = jsonResponse.get("team").getAsJsonObject();
        this.team = SlackJSONParsingUtils.buildSlackTeam(teamJson);
        this.webSocketURL = jsonResponse.get("url").getAsString();
    }

    public SlackPersona getSessionPersona() {
        return this.sessionPersona;
    }

    public SlackTeam getTeam() {
        return this.team;
    }
}

