/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ullink.slack.simpleslackapi.ChannelHistoryModule;
import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackMessageHandle;
import com.ullink.slack.simpleslackapi.SlackSession;
import com.ullink.slack.simpleslackapi.events.ReactionAdded;
import com.ullink.slack.simpleslackapi.events.ReactionRemoved;
import com.ullink.slack.simpleslackapi.events.SlackMessagePosted;
import com.ullink.slack.simpleslackapi.impl.GsonHelper;
import com.ullink.slack.simpleslackapi.impl.SlackJSONMessageParser;
import com.ullink.slack.simpleslackapi.listeners.ReactionAddedListener;
import com.ullink.slack.simpleslackapi.listeners.ReactionRemovedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackMessagePostedListener;
import com.ullink.slack.simpleslackapi.replies.GenericSlackReply;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalUnit;

public class ChannelHistoryModuleImpl
implements ChannelHistoryModule {
    private final SlackSession session;
    private static final String FETCH_CHANNEL_HISTORY_COMMAND = "conversations.history";
    private static final String FETCH_GROUP_HISTORY_COMMAND = "conversations.history";
    private static final String FETCH_IM_HISTORY_COMMAND = "conversations.history";
    private static final int DEFAULT_HISTORY_FETCH_SIZE = 1000;

    public ChannelHistoryModuleImpl(SlackSession session) {
        this.session = session;
    }

    @Override
    public SlackMessagePosted fetchMessageFromChannel(String channelId, String messageTimestamp) {
        List<SlackMessagePosted> retrievedList;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("channel", channelId);
        params.put("count", "1");
        params.put("latest", messageTimestamp);
        params.put("inclusive", "true");
        SlackChannel channel = this.session.findChannelById(channelId);
        switch (channel.getType()) {
            case INSTANT_MESSAGING: {
                retrievedList = this.fetchHistoryOfChannel(params, "conversations.history", ChannelHistoryModule.MessageSubTypeFilter.USERS_AND_INTERNAL_MESSAGES.getRetainedSubtypes());
                break;
            }
            case PRIVATE_GROUP: {
                retrievedList = this.fetchHistoryOfChannel(params, "conversations.history", ChannelHistoryModule.MessageSubTypeFilter.USERS_AND_INTERNAL_MESSAGES.getRetainedSubtypes());
                break;
            }
            default: {
                retrievedList = this.fetchHistoryOfChannel(params, "conversations.history", ChannelHistoryModule.MessageSubTypeFilter.USERS_AND_INTERNAL_MESSAGES.getRetainedSubtypes());
            }
        }
        if (retrievedList.size() > 0) {
            return retrievedList.get(0);
        }
        return null;
    }

    @Override
    public List<SlackMessagePosted> fetchHistoryOfChannel(String channelId) {
        return this.fetchHistoryOfChannel(channelId, null, -1);
    }

    @Override
    public List<SlackMessagePosted> fetchHistoryOfChannel(String channelId, LocalDate day) {
        return this.fetchHistoryOfChannel(channelId, day, -1);
    }

    @Override
    public List<SlackMessagePosted> fetchHistoryOfChannel(String channelId, int numberOfMessages) {
        return this.fetchHistoryOfChannel(channelId, null, numberOfMessages);
    }

    @Override
    public List<SlackMessagePosted> fetchHistoryOfChannel(String channelId, LocalDate day, int numberOfMessages) {
        return this.fetchHistoryOfChannel(channelId, day, numberOfMessages, ChannelHistoryModule.MessageSubTypeFilter.USERS_MESSAGES);
    }

    @Override
    public List<SlackMessagePosted> fetchHistoryOfChannel(String channelId, LocalDate day, int numberOfMessages, ChannelHistoryModule.MessageSubTypeFilter filter) {
        return this.fetchHistoryOfChannel(channelId, day, numberOfMessages, filter.getRetainedSubtypes());
    }

    @Override
    public List<SlackMessagePosted> fetchHistoryOfChannel(String channelId, LocalDate day, int numberOfMessages, Set<String> allowedSubtypes) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("channel", channelId);
        if (day != null) {
            ZonedDateTime start = ZonedDateTime.of((LocalDateTime)day.atStartOfDay(), (ZoneId)ZoneId.of((String)"UTC"));
            ZonedDateTime end = ZonedDateTime.of((LocalDateTime)day.atStartOfDay().plusDays(1L).minus(1L, (TemporalUnit)ChronoUnit.MILLIS), (ZoneId)ZoneId.of((String)"UTC"));
            params.put("oldest", this.convertDateToSlackTimestamp(start));
            params.put("latest", this.convertDateToSlackTimestamp(end));
        }
        if (numberOfMessages > -1) {
            params.put("count", String.valueOf(numberOfMessages));
        } else {
            params.put("count", String.valueOf(1000));
        }
        SlackChannel channel = this.session.findChannelById(channelId);
        switch (channel.getType()) {
            case INSTANT_MESSAGING: {
                return this.fetchHistoryOfChannel(params, "conversations.history", allowedSubtypes);
            }
            case PRIVATE_GROUP: {
                return this.fetchHistoryOfChannel(params, "conversations.history", allowedSubtypes);
            }
        }
        return this.fetchHistoryOfChannel(params, "conversations.history", allowedSubtypes);
    }

    private List<SlackMessagePosted> fetchHistoryOfChannel(Map<String, String> params, String command, Set<String> retainedMessageSubtypes) {
        SlackMessageHandle<GenericSlackReply> handle = this.session.postGenericSlackCommand(params, command);
        GenericSlackReply replyEv = handle.getReply();
        String answer = replyEv.getPlainAnswer();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(answer).getAsJsonObject();
        JsonArray events = GsonHelper.getJsonArrayOrNull(jsonObject.get("messages"));
        ArrayList<SlackMessagePosted> messages = new ArrayList<SlackMessagePosted>();
        if (events != null) {
            for (JsonElement eventJson : events) {
                JsonObject event = eventJson.getAsJsonObject();
                String subtype = GsonHelper.getStringOrNull(event.get("subtype"));
                if (subtype != null && !retainedMessageSubtypes.contains(subtype)) continue;
                messages.add((SlackMessagePosted)SlackJSONMessageParser.decode(this.session, event));
            }
        }
        return messages;
    }

    @Override
    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String channelId) {
        return this.fetchUpdatingHistoryOfChannel(channelId, null, -1);
    }

    @Override
    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String channelId, LocalDate day) {
        return this.fetchUpdatingHistoryOfChannel(channelId, day, -1);
    }

    @Override
    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String channelId, int numberOfMessages) {
        return this.fetchUpdatingHistoryOfChannel(channelId, null, numberOfMessages);
    }

    @Override
    public List<SlackMessagePosted> fetchUpdatingHistoryOfChannel(String channelId, LocalDate day, int numberOfMessages) {
        List<SlackMessagePosted> messages = this.fetchHistoryOfChannel(channelId, day, numberOfMessages);
        this.session.addReactionAddedListener(new ChannelHistoryReactionAddedListener(messages));
        this.session.addReactionRemovedListener(new ChannelHistoryReactionRemovedListener(messages));
        this.session.addMessagePostedListener(new ChannelHistoryMessagePostedListener(messages));
        return messages;
    }

    private String convertDateToSlackTimestamp(ZonedDateTime date) {
        return date.toInstant().toEpochMilli() / 1000L + ".123456";
    }

    public static class ChannelHistoryMessagePostedListener
    implements SlackMessagePostedListener {
        List<SlackMessagePosted> messages;

        public ChannelHistoryMessagePostedListener(List<SlackMessagePosted> initialMessages) {
            this.messages = initialMessages;
        }

        @Override
        public void onEvent(SlackMessagePosted event, SlackSession session) {
            this.messages.add(event);
        }
    }

    public static class ChannelHistoryReactionRemovedListener
    implements ReactionRemovedListener {
        List<SlackMessagePosted> messages;

        public ChannelHistoryReactionRemovedListener(List<SlackMessagePosted> initialMessages) {
            this.messages = initialMessages;
        }

        @Override
        public void onEvent(ReactionRemoved event, SlackSession session) {
            String emojiName = event.getEmojiName();
            for (SlackMessagePosted message : this.messages) {
                for (String reaction : message.getReactions().keySet()) {
                    if (!emojiName.equals(reaction)) continue;
                    int count = message.getReactions().get(emojiName);
                    if (count == 1) {
                        message.getReactions().remove(emojiName);
                    } else {
                        message.getReactions().put(emojiName, --count);
                    }
                    return;
                }
            }
        }
    }

    public static class ChannelHistoryReactionAddedListener
    implements ReactionAddedListener {
        List<SlackMessagePosted> messages;

        public ChannelHistoryReactionAddedListener(List<SlackMessagePosted> initialMessages) {
            this.messages = initialMessages;
        }

        @Override
        public void onEvent(ReactionAdded event, SlackSession session) {
            String emojiName = event.getEmojiName();
            for (SlackMessagePosted message : this.messages) {
                for (String reaction : message.getReactions().keySet()) {
                    if (!emojiName.equals(reaction)) continue;
                    int count = message.getReactions().get(emojiName);
                    message.getReactions().put(emojiName, ++count);
                    return;
                }
                message.getReactions().put(emojiName, 1);
            }
        }
    }
}

