/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ullink.slack.simpleslackapi.SlackAttachment;
import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackChatConfiguration;
import com.ullink.slack.simpleslackapi.SlackMessageHandle;
import com.ullink.slack.simpleslackapi.SlackPersona;
import com.ullink.slack.simpleslackapi.SlackPreparedMessage;
import com.ullink.slack.simpleslackapi.SlackPresence;
import com.ullink.slack.simpleslackapi.SlackSession;
import com.ullink.slack.simpleslackapi.SlackTeam;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.WebSocketContainerProvider;
import com.ullink.slack.simpleslackapi.blocks.Block;
import com.ullink.slack.simpleslackapi.events.PinAdded;
import com.ullink.slack.simpleslackapi.events.PinRemoved;
import com.ullink.slack.simpleslackapi.events.PresenceChange;
import com.ullink.slack.simpleslackapi.events.ReactionAdded;
import com.ullink.slack.simpleslackapi.events.ReactionRemoved;
import com.ullink.slack.simpleslackapi.events.SlackChannelArchived;
import com.ullink.slack.simpleslackapi.events.SlackChannelCreated;
import com.ullink.slack.simpleslackapi.events.SlackChannelDeleted;
import com.ullink.slack.simpleslackapi.events.SlackChannelJoined;
import com.ullink.slack.simpleslackapi.events.SlackChannelLeft;
import com.ullink.slack.simpleslackapi.events.SlackChannelRenamed;
import com.ullink.slack.simpleslackapi.events.SlackChannelUnarchived;
import com.ullink.slack.simpleslackapi.events.SlackConnected;
import com.ullink.slack.simpleslackapi.events.SlackDisconnected;
import com.ullink.slack.simpleslackapi.events.SlackEvent;
import com.ullink.slack.simpleslackapi.events.SlackGroupJoined;
import com.ullink.slack.simpleslackapi.events.SlackMessageDeleted;
import com.ullink.slack.simpleslackapi.events.SlackMessagePosted;
import com.ullink.slack.simpleslackapi.events.SlackMessageUpdated;
import com.ullink.slack.simpleslackapi.events.UnknownEvent;
import com.ullink.slack.simpleslackapi.events.UserTyping;
import com.ullink.slack.simpleslackapi.events.userchange.SlackTeamJoin;
import com.ullink.slack.simpleslackapi.events.userchange.SlackUserChange;
import com.ullink.slack.simpleslackapi.events.userchange.SlackUserChangeEvent;
import com.ullink.slack.simpleslackapi.impl.AbstractSlackSessionImpl;
import com.ullink.slack.simpleslackapi.impl.DefaultWebSocketContainerProvider;
import com.ullink.slack.simpleslackapi.impl.SlackJSONAttachmentFormatter;
import com.ullink.slack.simpleslackapi.impl.SlackJSONBlockFormatter;
import com.ullink.slack.simpleslackapi.impl.SlackJSONMessageParser;
import com.ullink.slack.simpleslackapi.impl.SlackJSONParsingUtils;
import com.ullink.slack.simpleslackapi.impl.SlackJSONReplyParser;
import com.ullink.slack.simpleslackapi.impl.SlackPersonaImpl;
import com.ullink.slack.simpleslackapi.impl.SlackProfileImpl;
import com.ullink.slack.simpleslackapi.impl.SlackRateLimitRetryStrategy;
import com.ullink.slack.simpleslackapi.impl.SlackResponseHandler;
import com.ullink.slack.simpleslackapi.listeners.PresenceChangeListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelArchivedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelCreatedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelDeletedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelRenamedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackChannelUnarchivedListener;
import com.ullink.slack.simpleslackapi.listeners.SlackEventListener;
import com.ullink.slack.simpleslackapi.listeners.SlackTeamJoinListener;
import com.ullink.slack.simpleslackapi.listeners.SlackUserChangeListener;
import com.ullink.slack.simpleslackapi.replies.EmojiSlackReply;
import com.ullink.slack.simpleslackapi.replies.GenericSlackReply;
import com.ullink.slack.simpleslackapi.replies.ParsedSlackReply;
import com.ullink.slack.simpleslackapi.replies.SlackChannelReply;
import com.ullink.slack.simpleslackapi.replies.SlackMessageReply;
import com.ullink.slack.simpleslackapi.replies.SlackReply;
import com.ullink.slack.simpleslackapi.replies.SlackReplyImpl;
import com.ullink.slack.simpleslackapi.replies.SlackUserPresenceReply;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SlackWebSocketSessionImpl
extends AbstractSlackSessionImpl
implements SlackSession,
MessageHandler.Whole<String> {
    private static final String DEFAULT_SLACK_API_SCHEME = "https";
    private static final String DEFAULT_SLACK_API_HOST = "slack.com";
    private static final String DEFAULT_SLACK_API_PATH = "/api";
    private static final String DEFAULT_SLACK_API_HTTPS_ROOT = "https://slack.com/api/";
    private static final String MULTIPARTY_DIRECT_MESSAGE_OPEN_CHANNEL_COMMAND = "mpim.open";
    private static final String FILE_UPLOAD_COMMAND = "files.upload";
    private static final String INVITE_USER_COMMAND = "users.admin.invite";
    private static final String LIST_EMOJI_COMMAND = "emoji.list";
    private static final String AUTH_TEST_COMMAND = "auth.test";
    private static final String APPS_CONNECTIONS_OPEN_COMMAND = "apps.connections.open";
    private static final String APP_LEVEL_API_PREFIX = "apps";
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackWebSocketSessionImpl.class);
    private static final int DEFAULT_HEARTBEAT_IN_MILLIS = 30000;
    private volatile Session websocketSession;
    private final String authToken;
    private final String appLevelToken;
    private String slackApiBase = "https://slack.com/api/";
    private String proxyAddress;
    private int proxyPort = -1;
    HttpHost proxyHost;
    private String proxyUser;
    private String proxyPassword;
    private volatile long lastPingSent;
    private volatile long lastPingAck;
    private final AtomicLong messageId = new AtomicLong();
    private final boolean reconnectOnDisconnection;
    private final boolean isRateLimitSupported;
    private final boolean legacyMode;
    private volatile boolean wantDisconnect;
    private Thread connectionMonitoringThread;
    private final EventDispatcher dispatcher = new EventDispatcher();
    private final long heartbeat;
    private final WebSocketContainerProvider webSocketContainerProvider;
    private volatile String webSocketConnectionURL;
    private final PresenceChangeListener INTERNAL_PRESENCE_CHANGE_LISTENER = (event, session) -> {
        SlackUser user = (SlackUser)this.users.get(event.getUserId());
        SlackPersonaImpl persona = (SlackPersonaImpl)user;
        SlackProfileImpl profile = persona.getProfile().toBuilder().presence(event.getPresence()).build();
        SlackPersonaImpl newUser = ((SlackPersonaImpl)user).toBuilder().profile(profile).build();
        this.users.put(event.getUserId(), newUser);
    };
    private final SlackChannelArchivedListener INTERNAL_CHANNEL_ARCHIVE_LISTENER = (event, session) -> {
        SlackChannel channel = (SlackChannel)this.channels.get(event.getSlackChannel().getId());
        SlackChannel newChannel = channel.toBuilder().isArchived(true).build();
        this.channels.put(newChannel.getId(), newChannel);
    };
    private final SlackChannelCreatedListener INTERNAL_CHANNEL_CREATED_LISTENER = (event, session) -> this.channels.put(event.getSlackChannel().getId(), event.getSlackChannel());
    private final SlackChannelDeletedListener INTERNAL_CHANNEL_DELETED_LISTENER = (event, session) -> this.channels.remove(event.getSlackChannel().getId());
    private final SlackChannelRenamedListener INTERNAL_CHANNEL_RENAMED_LISTENER = (event, session) -> {
        SlackChannel channel = (SlackChannel)this.channels.get(event.getSlackChannel().getId());
        SlackChannel newChannel = channel.toBuilder().name(event.getNewName()).build();
        this.channels.put(newChannel.getId(), newChannel);
    };
    private final SlackChannelUnarchivedListener INTERNAL_CHANNEL_UNARCHIVED_LISTENER = (event, session) -> {
        SlackChannel channel = (SlackChannel)this.channels.get(event.getSlackChannel().getId());
        SlackChannel newChannel = channel.toBuilder().isArchived(false).build();
        this.channels.put(newChannel.getId(), newChannel);
    };
    private final SlackTeamJoinListener INTERNAL_TEAM_JOIN_LISTENER = (event, session) -> this.users.put(event.getUser().getId(), event.getUser());
    private final SlackUserChangeListener INTERNAL_USER_CHANGE_LISTENER = (event, session) -> this.users.put(event.getUser().getId(), event.getUser());

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessageToUser(SlackUser user, SlackPreparedMessage message) {
        SlackChannel iMChannel = this.getIMChannelForUser(user);
        return this.sendMessage(iMChannel, message);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessageToUser(String userName, SlackPreparedMessage preparedMessage) {
        return this.sendMessageToUser(this.findUserByUserName(userName), preparedMessage);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessageToUser(SlackUser user, String message, SlackAttachment attachment) {
        SlackChannel iMChannel = this.getIMChannelForUser(user);
        return this.sendMessage(iMChannel, message, attachment, DEFAULT_CONFIGURATION);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessageToUser(String userName, String message, SlackAttachment attachment) {
        return this.sendMessageToUser(this.findUserByUserName(userName), message, attachment);
    }

    private SlackChannel getIMChannelForUser(SlackUser user) {
        SlackMessageHandle<GenericSlackReply> reply = this.openDirectMessageChannel(user);
        String channelAnswer = reply.getReply().getPlainAnswer();
        JsonParser parser = new JsonParser();
        String channelId = parser.parse(channelAnswer).getAsJsonObject().get("channel").getAsJsonObject().get("id").getAsString();
        SlackChannel channel = this.findChannelById(channelId);
        return channel;
    }

    SlackWebSocketSessionImpl(WebSocketContainerProvider webSocketContainerProvider, String authToken, String appLevelToken, String slackApiBase, boolean reconnectOnDisconnection, boolean isRateLimitSupported, long heartbeat, TimeUnit unit, boolean legacyMode) {
        this(webSocketContainerProvider, authToken, appLevelToken, slackApiBase, null, null, -1, null, null, reconnectOnDisconnection, isRateLimitSupported, heartbeat, unit, legacyMode);
    }

    SlackWebSocketSessionImpl(WebSocketContainerProvider webSocketContainerProvider, String authToken, String appLevelToken, String slackApiBase, Proxy.Type proxyType, String proxyAddress, int proxyPort, String proxyUser, String proxyPassword, boolean reconnectOnDisconnection, boolean isRateLimitSupported, long heartbeat, TimeUnit unit, boolean legacyMode) {
        this.authToken = authToken;
        this.appLevelToken = appLevelToken;
        if (slackApiBase != null) {
            this.slackApiBase = slackApiBase;
        }
        if (proxyType != null && proxyType != Proxy.Type.DIRECT) {
            this.proxyAddress = proxyAddress;
            this.proxyPort = proxyPort;
            this.proxyHost = new HttpHost(proxyAddress, proxyPort);
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
        }
        this.reconnectOnDisconnection = reconnectOnDisconnection;
        this.isRateLimitSupported = isRateLimitSupported;
        this.legacyMode = legacyMode;
        this.heartbeat = heartbeat != 0L ? unit.toMillis(heartbeat) : 30000L;
        this.webSocketContainerProvider = webSocketContainerProvider != null ? webSocketContainerProvider : new DefaultWebSocketContainerProvider(this.proxyAddress, this.proxyPort, this.proxyUser, this.proxyPassword);
        this.addInternalListeners();
    }

    private void addInternalListeners() {
        this.addPresenceChangeListener(this.INTERNAL_PRESENCE_CHANGE_LISTENER);
        this.addChannelArchivedListener(this.INTERNAL_CHANNEL_ARCHIVE_LISTENER);
        this.addChannelCreatedListener(this.INTERNAL_CHANNEL_CREATED_LISTENER);
        this.addChannelDeletedListener(this.INTERNAL_CHANNEL_DELETED_LISTENER);
        this.addChannelRenamedListener(this.INTERNAL_CHANNEL_RENAMED_LISTENER);
        this.addChannelUnarchivedListener(this.INTERNAL_CHANNEL_UNARCHIVED_LISTENER);
        this.addSlackTeamJoinListener(this.INTERNAL_TEAM_JOIN_LISTENER);
        this.addSlackUserChangeListener(this.INTERNAL_USER_CHANGE_LISTENER);
    }

    @Override
    public void connect() throws IOException {
        this.wantDisconnect = false;
        this.connectImpl();
        LOGGER.debug("starting actions monitoring");
        this.startConnectionMonitoring();
    }

    @Override
    public void disconnect() {
        this.wantDisconnect = true;
        LOGGER.debug("Disconnecting from the Slack server");
        this.disconnectImpl();
        this.stopConnectionMonitoring();
    }

    public void reconnect() throws IOException {
        while (true) {
            if (!this.isConnected()) break;
            this.disconnectImpl();
        }
        this.connectImpl();
    }

    @Override
    public boolean isConnected() {
        return this.websocketSession != null && this.websocketSession.isOpen();
    }

    private void connectImpl() throws IOException {
        JsonParser parser = new JsonParser();
        LOGGER.info("connecting to slack");
        this.refetchUsers();
        this.fecthChannels(parser);
        String authTestAnswer = this.authTest().getReply().getPlainAnswer();
        JsonObject authTestJson = parser.parse(authTestAnswer).getAsJsonObject();
        String user_id = authTestJson.get("user_id").getAsString();
        String team_name = authTestJson.get("team").getAsString();
        String team_id = authTestJson.get("team_id").getAsString();
        String domain = authTestJson.get("url").getAsString();
        this.team = new SlackTeam(team_id, team_name, domain);
        String userInfoAnswer = this.getUserInfo(user_id).getReply().getPlainAnswer();
        JsonObject userInfoJson = parser.parse(userInfoAnswer).getAsJsonObject().get("user").getAsJsonObject();
        this.sessionPersona = SlackJSONParsingUtils.buildSlackUser(userInfoJson);
        if (this.legacyMode) {
            HttpClient httpClient = this.getHttpClient();
            HttpPost request = new HttpPost(this.slackApiBase + "rtm.connect");
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            request.setHeader("Authorization", "Bearer " + this.authToken);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            LOGGER.debug(response.getStatusLine().toString());
            JsonObject jsonResponse = parser.parse(this.consumeToString(response.getEntity().getContent())).getAsJsonObject();
            Boolean ok = jsonResponse.get("ok").getAsBoolean();
            if (Boolean.FALSE.equals(ok)) {
                String error = jsonResponse.get("error").getAsString();
                LOGGER.error("Error during authentication : " + error);
                throw new ConnectException(error);
            }
            this.webSocketConnectionURL = jsonResponse.get("url").getAsString();
        } else {
            String appsConnectionsOpenAnswer = this.appsConnectionsOpen().getReply().getPlainAnswer();
            JsonObject appsConnectionsOpenJson = parser.parse(appsConnectionsOpenAnswer).getAsJsonObject();
            this.webSocketConnectionURL = appsConnectionsOpenJson.get("url").getAsString();
        }
        LOGGER.info("Team " + this.team.getId() + " : " + this.team.getName());
        LOGGER.info("Self " + this.sessionPersona.getId() + " : " + this.sessionPersona.getUserName());
        LOGGER.info(this.users.size() + " users found on this session");
        LOGGER.info(this.channels.size() + " channels found on this session");
        LOGGER.debug("retrieved websocket URL : " + this.webSocketConnectionURL);
        this.establishWebsocketConnection();
    }

    private void establishWebsocketConnection() throws IOException {
        this.lastPingSent = 0L;
        this.lastPingAck = 0L;
        WebSocketContainer client = this.webSocketContainerProvider.getWebSocketContainer();
        SlackWebSocketSessionImpl handler = this;
        LOGGER.debug("initiating actions to websocket");
        try {
            this.websocketSession = client.connectToServer((Object)new Endpoint((MessageHandler)handler){
                final /* synthetic */ MessageHandler val$handler;
                {
                    this.val$handler = messageHandler;
                }

                public void onOpen(Session session, EndpointConfig config) {
                    session.addMessageHandler(this.val$handler);
                }

                public void onError(Session session, Throwable thr) {
                    LOGGER.error("Endpoint#onError called", thr);
                }
            }, URI.create(this.webSocketConnectionURL));
        }
        catch (DeploymentException e) {
            LOGGER.error(e.toString());
            throw new IOException(e);
        }
        if (this.websocketSession == null) {
            throw new IOException("Unable to establish a connection to this websocket URL " + this.webSocketConnectionURL);
        }
        SlackConnected slackConnected = new SlackConnected(this.sessionPersona);
        this.dispatcher.dispatch(slackConnected);
        LOGGER.debug("websocket actions established");
        LOGGER.info("slack session ready");
    }

    private String consumeToString(InputStream content) throws IOException {
        StringBuilder buf = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(content, Charset.forName(StandardCharsets.UTF_8.name())));){
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                buf.append((char)c);
            }
        }
        return buf.toString();
    }

    private void disconnectImpl() {
        if (this.websocketSession != null) {
            try {
                this.websocketSession.close();
            }
            catch (IOException slackDisconnected) {
            }
            finally {
                SlackDisconnected slackDisconnected = new SlackDisconnected(this.sessionPersona);
                this.dispatcher.dispatch(slackDisconnected);
                this.websocketSession = null;
            }
        }
    }

    private void startConnectionMonitoring() {
        this.connectionMonitoringThread = new Thread(){

            @Override
            public void run() {
                LOGGER.debug("monitoring thread started");
                block7: while (true) {
                    try {
                        while (true) {
                            Thread.sleep(SlackWebSocketSessionImpl.this.heartbeat);
                            if (SlackWebSocketSessionImpl.this.wantDisconnect) {
                                this.interrupt();
                            }
                            if (SlackWebSocketSessionImpl.this.lastPingSent != SlackWebSocketSessionImpl.this.lastPingAck || SlackWebSocketSessionImpl.this.websocketSession == null) {
                                LOGGER.warn("Connection lost...");
                                try {
                                    if (SlackWebSocketSessionImpl.this.websocketSession != null) {
                                        SlackWebSocketSessionImpl.this.websocketSession.close();
                                    }
                                }
                                catch (IOException e) {
                                    LOGGER.error("exception while trying to close the websocket ", (Throwable)e);
                                }
                                SlackWebSocketSessionImpl.this.websocketSession = null;
                                if (SlackWebSocketSessionImpl.this.reconnectOnDisconnection) {
                                    SlackWebSocketSessionImpl.this.reconnect();
                                    continue;
                                }
                                this.interrupt();
                                continue;
                            }
                            SlackWebSocketSessionImpl.this.lastPingSent = SlackWebSocketSessionImpl.this.getNextMessageId();
                            LOGGER.debug("sending ping " + SlackWebSocketSessionImpl.this.lastPingSent);
                            try {
                                if (SlackWebSocketSessionImpl.this.websocketSession.isOpen()) {
                                    SlackWebSocketSessionImpl.this.websocketSession.getBasicRemote().sendText("{\"type\":\"ping\",\"id\":" + SlackWebSocketSessionImpl.this.lastPingSent + "}");
                                    continue block7;
                                }
                                if (!SlackWebSocketSessionImpl.this.reconnectOnDisconnection) continue block7;
                                SlackWebSocketSessionImpl.this.reconnect();
                                continue block7;
                            }
                            catch (IllegalStateException e) {
                                LOGGER.warn("exception caught while using websocket ", (Throwable)e);
                                if (!SlackWebSocketSessionImpl.this.reconnectOnDisconnection) continue;
                                SlackWebSocketSessionImpl.this.reconnect();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("monitoring thread interrupted");
                    }
                    catch (IOException e) {
                        LOGGER.error("unexpected exception on monitoring thread ", (Throwable)e);
                        continue;
                    }
                    break;
                }
                LOGGER.debug("monitoring thread stopped");
            }
        };
        if (!this.wantDisconnect) {
            this.connectionMonitoringThread.start();
        }
    }

    private void stopConnectionMonitoring() {
        if (this.connectionMonitoringThread != null) {
            while (true) {
                try {
                    this.connectionMonitoringThread.interrupt();
                    this.connectionMonitoringThread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(SlackChannel channel, SlackPreparedMessage preparedMessage, SlackChatConfiguration chatConfiguration) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel can't be null");
        }
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("text", preparedMessage.getMessage());
        if (chatConfiguration.isAsUser()) {
            arguments.put("as_user", "true");
        }
        if (chatConfiguration.getAvatar() == SlackChatConfiguration.Avatar.ICON_URL) {
            arguments.put("icon_url", chatConfiguration.getAvatarDescription());
        }
        if (chatConfiguration.getAvatar() == SlackChatConfiguration.Avatar.EMOJI) {
            arguments.put("icon_emoji", chatConfiguration.getAvatarDescription());
        }
        if (chatConfiguration.getUserName() != null) {
            arguments.put("username", chatConfiguration.getUserName());
        }
        if (preparedMessage.getAttachments() != null && preparedMessage.getAttachments().size() > 0) {
            arguments.put("attachments", SlackJSONAttachmentFormatter.encodeAttachments(preparedMessage.getAttachments()).toString());
        }
        if (preparedMessage.getBlocks() != null && preparedMessage.getBlocks().size() > 0) {
            arguments.put("blocks", SlackJSONBlockFormatter.encodeBlocks(preparedMessage.getBlocks()));
        }
        if (!preparedMessage.isUnfurl()) {
            arguments.put("unfurl_links", "false");
            arguments.put("unfurl_media", "false");
        }
        if (preparedMessage.isLinkNames()) {
            arguments.put("link_names", "1");
        }
        if (preparedMessage.getThreadTimestamp() != null) {
            arguments.put("thread_ts", preparedMessage.getThreadTimestamp());
            if (preparedMessage.isReplyBroadcast()) {
                arguments.put("reply_broadcast", "true");
            }
        }
        this.postSlackCommand(arguments, "chat.postMessage", handle, SlackMessageReply.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> deleteMessage(String timeStamp, String channelId) {
        return this.deleteMessage(timeStamp, this.findChannelById(channelId));
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(String channelId, SlackPreparedMessage preparedMessage, SlackChatConfiguration chatConfiguration) {
        return this.sendMessage(this.findChannelById(channelId), preparedMessage, chatConfiguration);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(String channelId, SlackPreparedMessage preparedMessage) {
        return this.sendMessage(this.findChannelById(channelId), preparedMessage);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(String channelId, String message, SlackAttachment attachment, SlackChatConfiguration chatConfiguration, boolean unfurl) {
        return this.sendMessage(this.findChannelById(channelId), message, attachment, chatConfiguration, unfurl);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(String channelId, String message, SlackAttachment attachment, SlackChatConfiguration chatConfiguration) {
        return this.sendMessage(this.findChannelById(channelId), message, attachment, chatConfiguration);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(String channelId, String message, SlackAttachment attachment, boolean unfurl) {
        return this.sendMessage(this.findChannelById(channelId), message, attachment, unfurl);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(String channelId, String message, SlackAttachment attachment) {
        return this.sendMessage(this.findChannelById(channelId), message, attachment);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(String channelId, String message, boolean unfurl) {
        return this.sendMessage(this.findChannelById(channelId), message, unfurl);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessage(String channelId, String message) {
        return this.sendMessage(this.findChannelById(channelId), message);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(SlackChannel channel, SlackUser user, SlackPreparedMessage preparedMessage, SlackChatConfiguration chatConfiguration) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("text", preparedMessage.getMessage());
        arguments.put("user", user.getId());
        if (chatConfiguration.isAsUser()) {
            arguments.put("as_user", "true");
        }
        if (chatConfiguration.getAvatar() == SlackChatConfiguration.Avatar.ICON_URL) {
            arguments.put("icon_url", chatConfiguration.getAvatarDescription());
        }
        if (chatConfiguration.getAvatar() == SlackChatConfiguration.Avatar.EMOJI) {
            arguments.put("icon_emoji", chatConfiguration.getAvatarDescription());
        }
        if (chatConfiguration.getUserName() != null) {
            arguments.put("username", chatConfiguration.getUserName());
        }
        if (preparedMessage.getAttachments() != null && preparedMessage.getAttachments().size() > 0) {
            arguments.put("attachments", SlackJSONAttachmentFormatter.encodeAttachments(preparedMessage.getAttachments()).toString());
        }
        if (preparedMessage.getBlocks() != null && preparedMessage.getBlocks().size() > 0) {
            arguments.put("blocks", SlackJSONBlockFormatter.encodeBlocks(preparedMessage.getBlocks()));
        }
        if (!preparedMessage.isUnfurl()) {
            arguments.put("unfurl_links", "false");
            arguments.put("unfurl_media", "false");
        }
        if (preparedMessage.isLinkNames()) {
            arguments.put("link_names", "1");
        }
        if (preparedMessage.getThreadTimestamp() != null) {
            arguments.put("thread_ts", preparedMessage.getThreadTimestamp());
            if (preparedMessage.isReplyBroadcast()) {
                arguments.put("reply_broadcast", "true");
            }
        }
        this.postSlackCommand(arguments, "chat.postEphemeral", handle, SlackMessageReply.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendFileToUser(String userName, InputStream data, String fileName) {
        return this.sendFileToUser(this.findUserByUserName(userName), data, fileName);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendFileToUser(SlackUser user, InputStream data, String fileName) {
        SlackChannel iMChannel = this.getIMChannelForUser(user);
        return this.sendFile(iMChannel, data, fileName);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendFile(SlackChannel channel, InputStream data, String fileName) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channels", channel.getId());
        arguments.put("filename", fileName);
        this.postSlackCommandWithFile(arguments, data, fileName, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendFile(SlackChannel channel, InputStream data, String fileName, String title, String initialComment) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channels", channel.getId());
        arguments.put("filename", fileName);
        arguments.put("title", title);
        arguments.put("initial_comment", initialComment);
        this.postSlackCommandWithFile(arguments, data, fileName, handle);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(String channelId, String user, SlackPreparedMessage preparedMessage, SlackChatConfiguration chatConfiguration) {
        return this.sendEphemeralMessage(this.findChannelById(channelId), this.findUserByUserName(user), preparedMessage, chatConfiguration);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(String channelId, String user, SlackPreparedMessage preparedMessage) {
        return this.sendEphemeralMessage(this.findChannelById(channelId), this.findUserByUserName(user), preparedMessage);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(String channelId, String user, String message, SlackAttachment attachment, SlackChatConfiguration chatConfiguration, boolean unfurl) {
        return this.sendEphemeralMessage(this.findChannelById(channelId), this.findUserByUserName(user), message, attachment, chatConfiguration, unfurl);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(String channelId, String user, String message, SlackAttachment attachment, SlackChatConfiguration chatConfiguration) {
        return this.sendEphemeralMessage(this.findChannelById(channelId), this.findUserByUserName(user), message, attachment, chatConfiguration);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(String channelId, String user, String message, SlackAttachment attachment, boolean unfurl) {
        return this.sendEphemeralMessage(this.findChannelById(channelId), this.findUserByUserName(user), message, attachment, unfurl);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(String channelId, String user, String message, SlackAttachment attachment) {
        return this.sendEphemeralMessage(this.findChannelById(channelId), this.findUserByUserName(user), message, attachment);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(String channelId, String user, String message, boolean unfurl) {
        return this.sendEphemeralMessage(this.findChannelById(channelId), this.findUserByUserName(user), message, unfurl);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendEphemeralMessage(String channelId, String user, String message) {
        return this.sendEphemeralMessage(this.findChannelById(channelId), this.findUserByUserName(user), message);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendFile(String channelId, InputStream data, String fileName) {
        return this.sendFile(this.findChannelById(channelId), data, fileName);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendFile(String channelId, InputStream data, String fileName, String title, String initialComment) {
        return this.sendFile(this.findChannelById(channelId), data, fileName, title, initialComment);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> deleteMessage(String timeStamp, SlackChannel channel) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("ts", timeStamp);
        this.postSlackCommand(arguments, "chat.delete", handle, SlackMessageReply.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> updateMessage(String timeStamp, SlackChannel channel, String message) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("ts", timeStamp);
        arguments.put("channel", channel.getId());
        arguments.put("text", message);
        this.postSlackCommand(arguments, "chat.update", handle, SlackMessageReply.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> updateMessage(String timeStamp, SlackChannel channel, String message, SlackAttachment[] attachments) {
        return this.updateMessage(timeStamp, channel, message, attachments, new ArrayList<Block>());
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> updateMessage(String timeStamp, SlackChannel channel, String message, SlackAttachment[] attachments, List<Block> blocks) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("ts", timeStamp);
        arguments.put("channel", channel.getId());
        arguments.put("text", message);
        arguments.put("attachments", SlackJSONAttachmentFormatter.encodeAttachments(attachments).toString());
        arguments.put("blocks", SlackJSONBlockFormatter.encodeBlocks(blocks));
        this.postSlackCommand(arguments, "chat.update", handle, SlackMessageReply.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> addReactionToMessage(SlackChannel channel, String messageTimeStamp, String emojiCode) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("timestamp", messageTimeStamp);
        arguments.put("name", emojiCode);
        this.postSlackCommand(arguments, "reactions.add", handle, SlackMessageReply.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> removeReactionFromMessage(SlackChannel channel, String messageTimeStamp, String emojiCode) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("timestamp", messageTimeStamp);
        arguments.put("name", emojiCode);
        this.postSlackCommand(arguments, "reactions.remove", handle, SlackMessageReply.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> joinChannel(String channelName) {
        SlackMessageHandle<SlackChannelReply> handle = new SlackMessageHandle<SlackChannelReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("name", channelName);
        this.postSlackCommand(arguments, "conversations.join", handle, SlackChannelReply.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> setChannelTopic(SlackChannel channel, String topic) {
        SlackMessageHandle<SlackChannelReply> handle = new SlackMessageHandle<SlackChannelReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("topic", topic);
        this.postSlackCommand(arguments, "conversations.setTopic", handle, SlackChannelReply.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> leaveChannel(SlackChannel channel) {
        SlackMessageHandle<SlackChannelReply> handle = new SlackMessageHandle<SlackChannelReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        this.postSlackCommand(arguments, "conversations.leave", handle, SlackChannelReply.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> inviteToChannel(SlackChannel channel, SlackUser user) {
        SlackMessageHandle<SlackChannelReply> handle = new SlackMessageHandle<SlackChannelReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        arguments.put("users", user.getId());
        if (this.users.containsKey(user.getId())) {
            channel.addUser(user);
        }
        this.postSlackCommand(arguments, "conversations.invite", handle, SlackChannelReply.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<ParsedSlackReply> archiveChannel(SlackChannel channel) {
        SlackMessageHandle<ParsedSlackReply> handle = new SlackMessageHandle<ParsedSlackReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        this.postSlackCommand(arguments, "conversations.archive", handle, SlackReplyImpl.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<ParsedSlackReply> unarchiveChannel(SlackChannel channel) {
        SlackMessageHandle<ParsedSlackReply> handle = new SlackMessageHandle<ParsedSlackReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("channel", channel.getId());
        this.postSlackCommand(arguments, "conversations.unarchive", handle, SlackReplyImpl.class);
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> updateMessage(String timeStamp, String channelId, String message) {
        return this.updateMessage(timeStamp, this.findChannelById(channelId), message);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> updateMessage(String timeStamp, String channelId, String message, SlackAttachment[] attachments) {
        return this.updateMessage(timeStamp, this.findChannelById(channelId), message, attachments);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> updateMessage(String timeStamp, String channelId, String message, SlackAttachment[] attachments, List<Block> blocks) {
        return this.updateMessage(timeStamp, this.findChannelById(channelId), message, attachments, blocks);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessageOverWebSocket(String channelId, String message) {
        return this.sendMessageOverWebSocket(this.findChannelById(channelId), message);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> addReactionToMessage(String channelId, String messageTimeStamp, String emojiCode) {
        return this.addReactionToMessage(this.findChannelById(channelId), messageTimeStamp, emojiCode);
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> removeReactionFromMessage(String channelId, String messageTimeStamp, String emojiCode) {
        return this.removeReactionFromMessage(this.findChannelById(channelId), messageTimeStamp, emojiCode);
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> setChannelTopic(String channelId, String topic) {
        return this.setChannelTopic(this.findChannelById(channelId), topic);
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> leaveChannel(String channelId) {
        return this.leaveChannel(this.findChannelById(channelId));
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> inviteToChannel(String channelId, SlackUser user) {
        return this.inviteToChannel(this.findChannelById(channelId), user);
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> inviteToChannel(String channelId, String userName) {
        return this.inviteToChannel(this.findChannelById(channelId), this.findUserByUserName(userName));
    }

    @Override
    public SlackMessageHandle<ParsedSlackReply> archiveChannel(String channelId) {
        return this.archiveChannel(this.findChannelById(channelId));
    }

    @Override
    public SlackMessageHandle<ParsedSlackReply> unarchiveChannel(String channelId) {
        return this.unarchiveChannel(this.findChannelById(channelId));
    }

    @Override
    public SlackMessageHandle<GenericSlackReply> openDirectMessageChannel(SlackUser user) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("users", user.getId());
        SlackMessageHandle<GenericSlackReply> handle = this.postGenericSlackCommand(arguments, "conversations.open");
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackChannelReply> openMultipartyDirectMessageChannel(SlackUser ... users) {
        SlackMessageHandle<SlackChannelReply> handle = new SlackMessageHandle<SlackChannelReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < users.length; ++i) {
            if (i != 0) {
                strBuilder.append(',');
            }
            strBuilder.append(users[i].getId());
        }
        arguments.put("users", strBuilder.toString());
        this.postSlackCommand(arguments, MULTIPARTY_DIRECT_MESSAGE_OPEN_CHANNEL_COMMAND, handle, SlackChannelReply.class);
        if (!((SlackChannelReply)handle.getReply()).isOk()) {
            LOGGER.debug("Error occurred while performing command: '" + handle.getReply().getErrorMessage() + "'");
            return null;
        }
        return handle;
    }

    @Override
    public SlackMessageHandle<EmojiSlackReply> listEmoji() {
        SlackMessageHandle<EmojiSlackReply> handle = new SlackMessageHandle<EmojiSlackReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        this.postSlackCommand(arguments, LIST_EMOJI_COMMAND, handle, EmojiSlackReply.class);
        return handle;
    }

    public SlackMessageHandle<GenericSlackReply> listChannels() {
        return this.listChannels(null);
    }

    public SlackMessageHandle<GenericSlackReply> listChannels(String nextCursor) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", "1000");
        params.put("types", "public_channel,private_channel");
        if (nextCursor != null) {
            params.put("cursor", nextCursor);
        }
        return this.postGenericSlackCommand(params, "conversations.list");
    }

    public SlackMessageHandle<GenericSlackReply> listChannelMembers(String channel_id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("channel", channel_id);
        return this.postGenericSlackCommand(params, "conversations.members");
    }

    public SlackMessageHandle<GenericSlackReply> authTest() {
        return this.postGenericSlackCommand(AUTH_TEST_COMMAND);
    }

    public SlackMessageHandle<GenericSlackReply> appsConnectionsOpen() {
        return this.postGenericSlackCommand(APPS_CONNECTIONS_OPEN_COMMAND);
    }

    public SlackMessageHandle<GenericSlackReply> getUserInfo(String user_id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user_id);
        return this.postGenericSlackCommand(params, "users.info");
    }

    @Override
    public void refetchUsers() {
        LOGGER.info("Fetching users");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("presence", "1");
        SlackMessageHandle<GenericSlackReply> handle = this.postGenericSlackCommand(params, "users.list");
        GenericSlackReply replyEv = handle.getReply();
        String answer = replyEv.getPlainAnswer();
        JsonParser parser = new JsonParser();
        JsonObject answerJson = parser.parse(answer).getAsJsonObject();
        JsonArray membersjson = answerJson.get("members").getAsJsonArray();
        HashMap<String, SlackUser> members = new HashMap<String, SlackUser>();
        if (membersjson != null) {
            for (JsonElement member : membersjson) {
                SlackUser user = SlackJSONParsingUtils.buildSlackUser(member.getAsJsonObject());
                members.put(user.getId(), user);
            }
        }
        this.users = members;
    }

    private void fecthChannels(JsonParser parser) {
        String nextCursor = null;
        int nbChannels = 1;
        LOGGER.info("Fetching channels");
        do {
            String channelsAnswer = this.listChannels(nextCursor).getReply().getPlainAnswer();
            JsonObject answerJson = parser.parse(channelsAnswer).getAsJsonObject();
            nextCursor = answerJson.get("response_metadata").getAsJsonObject().get("next_cursor").getAsString();
            JsonArray channelsJson = answerJson.get("channels").getAsJsonArray();
            for (JsonElement jsonObject : channelsJson) {
                JsonObject jsonChannel = jsonObject.getAsJsonObject();
                SlackChannel channel = SlackJSONParsingUtils.buildSlackChannel(jsonChannel);
                LOGGER.debug("slack public channel found : " + channel.getId());
                this.channels.put(channel.getId(), channel);
                if (nbChannels % 1000 == 0) {
                    LOGGER.info(nbChannels + " channels loaded");
                }
                ++nbChannels;
            }
        } while (nextCursor != null && !nextCursor.isEmpty());
    }

    private <T extends SlackReply> void postSlackCommand(Map<String, String> params, String command, SlackMessageHandle handle, Class<T> replyType) {
        HttpClient client = this.getHttpClient();
        HttpPost request = new HttpPost(this.slackApiBase + command);
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> arg : params.entrySet()) {
            if ("token".equals(arg.getKey())) continue;
            nameValuePairList.add(new BasicNameValuePair(arg.getKey(), arg.getValue()));
        }
        if (command.contains(APP_LEVEL_API_PREFIX)) {
            request.setHeader("Authorization", "Bearer " + this.appLevelToken);
        } else {
            request.setHeader("Authorization", "Bearer " + this.authToken);
        }
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList, "UTF-8"));
            SlackReply reply = (SlackReply)client.execute((HttpUriRequest)request, new SlackResponseHandler<T>(replyType));
            handle.setReply(reply);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <T extends SlackReply> void postSlackCommandWithFile(Map<String, String> params, InputStream fileContent, String fileName, SlackMessageHandle handle) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.slackApiBase + FILE_UPLOAD_COMMAND);
            for (Map.Entry<String, String> arg : params.entrySet()) {
                if ("token".equals(arg.getKey())) continue;
                uriBuilder.setParameter(arg.getKey(), arg.getValue());
            }
            HttpPost request = new HttpPost(uriBuilder.toString());
            request.setHeader("Content-Type", "application/x-www-form-urlencoded");
            request.setHeader("Authorization", "Bearer " + this.authToken);
            HttpClient client = this.getHttpClient();
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody("file", fileContent, ContentType.DEFAULT_BINARY, fileName);
            request.setEntity(builder.build());
            SlackReply reply = (SlackReply)client.execute((HttpUriRequest)request, new SlackResponseHandler<SlackMessageReply>(SlackMessageReply.class));
            handle.setReply(reply);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public SlackMessageHandle<GenericSlackReply> postGenericSlackCommand(Map<String, String> params, String command) {
        HttpClient client = this.getHttpClient();
        HttpPost request = new HttpPost(this.slackApiBase + command);
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
        if (params != null) {
            for (Map.Entry<String, String> arg : params.entrySet()) {
                if ("token".equals(arg.getKey())) continue;
                nameValuePairList.add(new BasicNameValuePair(arg.getKey(), arg.getValue()));
            }
        }
        if (command.contains(APP_LEVEL_API_PREFIX)) {
            request.setHeader("Authorization", "Bearer " + this.appLevelToken);
        } else {
            request.setHeader("Authorization", "Bearer " + this.authToken);
        }
        try {
            SlackMessageHandle<GenericSlackReply> handle = new SlackMessageHandle<GenericSlackReply>(this.getNextMessageId());
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList, "UTF-8"));
            HttpResponse response = client.execute((HttpUriRequest)request);
            String jsonResponse = this.consumeToString(response.getEntity().getContent());
            LOGGER.debug("PostMessage return: " + jsonResponse);
            GenericSlackReply reply = new GenericSlackReply(jsonResponse);
            handle.setReply(reply);
            return handle;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public SlackMessageHandle<GenericSlackReply> postGenericSlackCommand(String command) {
        return this.postGenericSlackCommand(null, command);
    }

    private HttpClient getHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.proxyHost != null) {
            if (null == this.proxyUser) {
                builder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(this.proxyHost));
            } else {
                RequestConfig config = RequestConfig.custom().setProxy(this.proxyHost).build();
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(this.proxyHost), (Credentials)new UsernamePasswordCredentials(this.proxyUser, this.proxyPassword));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultRequestConfig(config);
            }
        }
        if (this.isRateLimitSupported) {
            builder.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new SlackRateLimitRetryStrategy());
        }
        return builder.build();
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendMessageOverWebSocket(SlackChannel channel, String message) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        try {
            JsonObject messageJSON = new JsonObject();
            messageJSON.addProperty("id", (Number)handle.getMessageId());
            messageJSON.addProperty("type", "message");
            messageJSON.addProperty("channel", channel.getId());
            messageJSON.addProperty("text", message);
            this.websocketSession.getBasicRemote().sendText(messageJSON.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendTyping(SlackChannel channel) {
        SlackMessageHandle<SlackMessageReply> handle = new SlackMessageHandle<SlackMessageReply>(this.getNextMessageId());
        try {
            JsonObject messageJSON = new JsonObject();
            messageJSON.addProperty("id", (Number)handle.getMessageId());
            messageJSON.addProperty("type", "typing");
            messageJSON.addProperty("channel", channel.getId());
            this.websocketSession.getBasicRemote().sendText(messageJSON.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handle;
    }

    @Override
    public SlackMessageHandle<SlackMessageReply> sendTyping(String channelId) {
        return this.sendTyping(channelId);
    }

    @Override
    public SlackPresence getPresence(SlackPersona persona) {
        HttpClient client = this.getHttpClient();
        HttpPost request = new HttpPost(this.slackApiBase + "users.getPresence");
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        request.setHeader("Authorization", "Bearer " + this.authToken);
        ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
        nameValuePairList.add(new BasicNameValuePair("user", persona.getId()));
        try {
            String presence;
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList, "UTF-8"));
            HttpResponse response = client.execute((HttpUriRequest)request);
            String jsonResponse = this.consumeToString(response.getEntity().getContent());
            LOGGER.debug("PostMessage return: " + jsonResponse);
            JsonObject resultObject = this.parseObject(jsonResponse);
            SlackUserPresenceReply reply = (SlackUserPresenceReply)SlackJSONReplyParser.decode(resultObject, this);
            if (!reply.isOk()) {
                return SlackPresence.UNKNOWN;
            }
            String string = presence = resultObject.get("presence") != null ? resultObject.get("presence").getAsString() : null;
            if ("active".equals(presence)) {
                return SlackPresence.ACTIVE;
            }
            if ("away".equals(presence)) {
                return SlackPresence.AWAY;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return SlackPresence.UNKNOWN;
    }

    @Override
    public void setPresence(SlackPresence presence) {
        if (presence == SlackPresence.UNKNOWN || presence == SlackPresence.ACTIVE) {
            throw new IllegalArgumentException("Presence must be either AWAY or AUTO");
        }
        HttpClient client = this.getHttpClient();
        HttpPost request = new HttpPost(this.slackApiBase + "users.setPresence");
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        request.setHeader("Authorization", "Bearer " + this.authToken);
        ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
        nameValuePairList.add(new BasicNameValuePair("presence", presence.toString().toLowerCase()));
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList, "UTF-8"));
            HttpResponse response = client.execute((HttpUriRequest)request);
            String JSONResponse = this.consumeToString(response.getEntity().getContent());
            LOGGER.debug("JSON Response=" + JSONResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private long getNextMessageId() {
        return this.messageId.getAndIncrement();
    }

    public void onMessage(String message) {
        JsonObject object = this.parseObject(message);
        LOGGER.debug("receiving from websocket " + message);
        if (object.get("type") == null) {
            LOGGER.info("unable to parse message, missing 'type' attribute: " + message);
            return;
        }
        if ("pong".equals(object.get("type").getAsString())) {
            this.lastPingAck = object.get("reply_to").getAsInt();
            LOGGER.debug("pong received " + this.lastPingAck);
        } else if ("reconnect_url".equals(object.get("type").getAsString())) {
            String newWebSocketConnectionURL = object.get("url").getAsString();
            LOGGER.debug("new websocket connection received " + newWebSocketConnectionURL);
        } else {
            SlackEvent slackEvent = SlackJSONMessageParser.decode(this, object);
            if (slackEvent instanceof SlackChannelCreated) {
                SlackChannelCreated slackChannelCreated = (SlackChannelCreated)slackEvent;
                this.channels.put(slackChannelCreated.getSlackChannel().getId(), slackChannelCreated.getSlackChannel());
            }
            if (slackEvent instanceof SlackGroupJoined) {
                SlackGroupJoined slackGroupJoined = (SlackGroupJoined)slackEvent;
                this.channels.put(slackGroupJoined.getSlackChannel().getId(), slackGroupJoined.getSlackChannel());
            }
            if (slackEvent instanceof SlackUserChangeEvent) {
                SlackUserChangeEvent slackUserChangeEvent = (SlackUserChangeEvent)slackEvent;
                this.users.put(slackUserChangeEvent.getUser().getId(), slackUserChangeEvent.getUser());
            }
            this.dispatcher.dispatch(slackEvent);
        }
    }

    private JsonObject parseObject(String json) {
        JsonParser parser = new JsonParser();
        return parser.parse(json).getAsJsonObject();
    }

    @Override
    public SlackMessageHandle<ParsedSlackReply> inviteUser(String email, String firstName, boolean setActive) {
        SlackMessageHandle<ParsedSlackReply> handle = new SlackMessageHandle<ParsedSlackReply>(this.getNextMessageId());
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("token", this.authToken);
        arguments.put("email", email);
        arguments.put("first_name", firstName);
        arguments.put("set_active", "" + setActive);
        this.postSlackCommand(arguments, INVITE_USER_COMMAND, handle, SlackReplyImpl.class);
        return handle;
    }

    @Override
    public long getHeartbeat() {
        return TimeUnit.MILLISECONDS.toSeconds(this.heartbeat);
    }

    public class EventDispatcher {
        void dispatch(SlackEvent event) {
            switch (event.getEventType()) {
                case SLACK_CHANNEL_ARCHIVED: {
                    this.dispatchImpl((SlackChannelArchived)event, SlackWebSocketSessionImpl.this.channelArchiveListener);
                    break;
                }
                case SLACK_CHANNEL_CREATED: {
                    this.dispatchImpl((SlackChannelCreated)event, SlackWebSocketSessionImpl.this.channelCreateListener);
                    break;
                }
                case SLACK_CHANNEL_DELETED: {
                    this.dispatchImpl((SlackChannelDeleted)event, SlackWebSocketSessionImpl.this.channelDeleteListener);
                    break;
                }
                case SLACK_CHANNEL_RENAMED: {
                    this.dispatchImpl((SlackChannelRenamed)event, SlackWebSocketSessionImpl.this.channelRenamedListener);
                    break;
                }
                case SLACK_CHANNEL_UNARCHIVED: {
                    this.dispatchImpl((SlackChannelUnarchived)event, SlackWebSocketSessionImpl.this.channelUnarchiveListener);
                    break;
                }
                case SLACK_CHANNEL_JOINED: {
                    this.dispatchImpl((SlackChannelJoined)event, SlackWebSocketSessionImpl.this.channelJoinedListener);
                    break;
                }
                case SLACK_CHANNEL_LEFT: {
                    this.dispatchImpl((SlackChannelLeft)event, SlackWebSocketSessionImpl.this.channelLeftListener);
                    break;
                }
                case SLACK_GROUP_JOINED: {
                    this.dispatchImpl((SlackGroupJoined)event, SlackWebSocketSessionImpl.this.groupJoinedListener);
                    break;
                }
                case SLACK_MESSAGE_DELETED: {
                    this.dispatchImpl((SlackMessageDeleted)event, SlackWebSocketSessionImpl.this.messageDeletedListener);
                    break;
                }
                case SLACK_MESSAGE_POSTED: {
                    this.dispatchImpl((SlackMessagePosted)event, SlackWebSocketSessionImpl.this.messagePostedListener);
                    break;
                }
                case SLACK_MESSAGE_UPDATED: {
                    this.dispatchImpl((SlackMessageUpdated)event, SlackWebSocketSessionImpl.this.messageUpdatedListener);
                    break;
                }
                case SLACK_CONNECTED: {
                    this.dispatchImpl((SlackConnected)event, SlackWebSocketSessionImpl.this.slackConnectedListener);
                    break;
                }
                case REACTION_ADDED: {
                    this.dispatchImpl((ReactionAdded)event, SlackWebSocketSessionImpl.this.reactionAddedListener);
                    break;
                }
                case REACTION_REMOVED: {
                    this.dispatchImpl((ReactionRemoved)event, SlackWebSocketSessionImpl.this.reactionRemovedListener);
                    break;
                }
                case SLACK_USER_CHANGE: {
                    this.dispatchImpl((SlackUserChange)event, SlackWebSocketSessionImpl.this.slackUserChangeListener);
                    break;
                }
                case SLACK_TEAM_JOIN: {
                    this.dispatchImpl((SlackTeamJoin)event, SlackWebSocketSessionImpl.this.slackTeamJoinListener);
                    break;
                }
                case PIN_ADDED: {
                    this.dispatchImpl((PinAdded)event, SlackWebSocketSessionImpl.this.pinAddedListener);
                    break;
                }
                case PIN_REMOVED: {
                    this.dispatchImpl((PinRemoved)event, SlackWebSocketSessionImpl.this.pinRemovedListener);
                    break;
                }
                case PRESENCE_CHANGE: {
                    this.dispatchImpl((PresenceChange)event, SlackWebSocketSessionImpl.this.presenceChangeListener);
                    break;
                }
                case SLACK_DISCONNECTED: {
                    this.dispatchImpl((SlackDisconnected)event, SlackWebSocketSessionImpl.this.slackDisconnectedListener);
                    break;
                }
                case USER_TYPING: {
                    this.dispatchImpl((UserTyping)event, SlackWebSocketSessionImpl.this.userTypingListener);
                    break;
                }
                default: {
                    if (event instanceof UnknownEvent) {
                        LOGGER.debug("event of type " + (Object)((Object)event.getEventType()) + " not handled: " + ((UnknownEvent)event).getJsonPayload());
                        break;
                    }
                    LOGGER.warn("event of type " + (Object)((Object)event.getEventType()) + " not handled: ");
                }
            }
        }

        private <E extends SlackEvent, L extends SlackEventListener<E>> void dispatchImpl(E event, List<L> listeners) {
            for (SlackEventListener listener : listeners) {
                try {
                    listener.onEvent(event, SlackWebSocketSessionImpl.this);
                }
                catch (Throwable thr) {
                    LOGGER.error("caught exception in dispatchImpl", thr);
                }
            }
        }
    }

    private static interface REACTIONS {
        public static final String ADD_COMMAND = "reactions.add";
        public static final String REMOVE_COMMAND = "reactions.remove";
    }

    private static interface USERS {
        public static final String SET_PRESENCE_COMMAND = "users.setPresence";
        public static final String GET_PRESENCE_COMMAND = "users.getPresence";
        public static final String LIST_COMMAND = "users.list";
        public static final String INFO_COMMAND = "users.info";
    }

    private static interface CHAT {
        public static final String POST_MESSAGE_COMMAND = "chat.postMessage";
        public static final String POST_EPHEMERAL_COMMAND = "chat.postEphemeral";
        public static final String DELETE_COMMAND = "chat.delete";
        public static final String UPDATE_COMMAND = "chat.update";
    }

    private static interface CONVERSATION {
        public static final String OPEN_COMMAND = "conversations.open";
        public static final String LEAVE_COMMAND = "conversations.leave";
        public static final String JOIN_COMMAND = "conversations.join";
        public static final String SET_TOPIC_COMMAND = "conversations.setTopic";
        public static final String INVITE_COMMAND = "conversations.invite";
        public static final String ARCHIVE_COMMAND = "conversations.archive";
        public static final String UNARCHIVE_COMMAND = "conversations.unarchive";
        public static final String LIST_COMMAND = "conversations.list";
        public static final String MEMBERS_COMMAND = "conversations.members";
    }
}

