/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BindResponseProtocolOp
implements ProtocolOp {
    public static final byte TYPE_SERVER_SASL_CREDENTIALS = -121;
    private static final long serialVersionUID = -7757619031268544913L;
    private final ASN1OctetString serverSASLCredentials;
    private final int resultCode;
    private final List<String> referralURLs;
    private final String diagnosticMessage;
    private final String matchedDN;

    public BindResponseProtocolOp(int resultCode, String matchedDN, String diagnosticMessage, List<String> referralURLs, ASN1OctetString serverSASLCredentials) {
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.diagnosticMessage = diagnosticMessage;
        this.referralURLs = referralURLs == null ? Collections.emptyList() : Collections.unmodifiableList(referralURLs);
        this.serverSASLCredentials = serverSASLCredentials == null ? null : new ASN1OctetString(-121, serverSASLCredentials.getValue());
    }

    BindResponseProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            ASN1StreamReaderSequence opSequence = reader.beginSequence();
            this.resultCode = reader.readEnumerated();
            String s = reader.readString();
            Validator.ensureNotNull(s);
            this.matchedDN = s.length() == 0 ? null : s;
            s = reader.readString();
            Validator.ensureNotNull(s);
            this.diagnosticMessage = s.length() == 0 ? null : s;
            ASN1OctetString creds = null;
            LinkedList<String> refs = new LinkedList<String>();
            while (opSequence.hasMoreElements()) {
                byte type = (byte)reader.peek();
                if (type == -93) {
                    ASN1StreamReaderSequence refSequence = reader.beginSequence();
                    while (refSequence.hasMoreElements()) {
                        refs.add(reader.readString());
                    }
                    continue;
                }
                if (type == -121) {
                    creds = new ASN1OctetString(type, reader.readBytes());
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_RESPONSE_INVALID_ELEMENT.get(StaticUtils.toHex(type)));
            }
            this.referralURLs = Collections.unmodifiableList(refs);
            this.serverSASLCredentials = creds;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getMatchedDN() {
        return this.matchedDN;
    }

    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    public ASN1OctetString getServerSASLCredentials() {
        return this.serverSASLCredentials;
    }

    @Override
    public byte getProtocolOpType() {
        return 97;
    }

    @Override
    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)97);
        buffer.addEnumerated(this.resultCode);
        buffer.addOctetString(this.matchedDN);
        buffer.addOctetString(this.diagnosticMessage);
        if (!this.referralURLs.isEmpty()) {
            ASN1BufferSequence refSequence = buffer.beginSequence((byte)-93);
            for (String s : this.referralURLs) {
                buffer.addOctetString(s);
            }
            refSequence.end();
        }
        if (this.serverSASLCredentials != null) {
            buffer.addElement(this.serverSASLCredentials);
        }
        opSequence.end();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("BindResponseProtocolOp(resultCode=");
        buffer.append(this.resultCode);
        if (this.matchedDN != null) {
            buffer.append(", matchedDN='");
            buffer.append(this.matchedDN);
            buffer.append('\'');
        }
        if (this.diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(this.diagnosticMessage);
            buffer.append('\'');
        }
        if (!this.referralURLs.isEmpty()) {
            buffer.append(", referralURLs={");
            Iterator<String> iterator = this.referralURLs.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

