/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExtendedRequestProtocolOp
implements ProtocolOp {
    public static final byte TYPE_OID = -128;
    public static final byte TYPE_VALUE = -127;
    private static final long serialVersionUID = -5343424210200494377L;
    private final ASN1OctetString value;
    private final String oid;

    public ExtendedRequestProtocolOp(String oid, ASN1OctetString value) {
        this.oid = oid;
        this.value = value == null ? null : new ASN1OctetString(-127, value.getValue());
    }

    ExtendedRequestProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            ASN1StreamReaderSequence opSequence = reader.beginSequence();
            this.oid = reader.readString();
            Validator.ensureNotNull(this.oid);
            this.value = opSequence.hasMoreElements() ? new ASN1OctetString(-127, reader.readBytes()) : null;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_EXTENDED_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getOID() {
        return this.oid;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    public byte getProtocolOpType() {
        return 119;
    }

    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)119);
        buffer.addOctetString((byte)-128, this.oid);
        if (this.value != null) {
            buffer.addElement(this.value);
        }
        opSequence.end();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ExtendedRequestProtocolOp(oid='");
        buffer.append(this.oid);
        buffer.append("')");
    }
}

