/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncHelper;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ModifyRequest
extends UpdatableLDAPRequest
implements ReadOnlyModifyRequest,
ResponseAcceptor,
ProtocolOp {
    private static final long serialVersionUID = -4747622844001634758L;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private final ArrayList<Modification> modifications;
    private int messageID = -1;
    private String dn;

    public ModifyRequest(String dn, Modification mod) {
        super(null);
        Validator.ensureNotNull(dn, mod);
        this.dn = dn;
        this.modifications = new ArrayList(1);
        this.modifications.add(mod);
    }

    public ModifyRequest(String dn, Modification ... mods) {
        super(null);
        Validator.ensureNotNull(dn, mods);
        Validator.ensureFalse(mods.length == 0, "ModifyRequest.mods must not be empty.");
        this.dn = dn;
        this.modifications = new ArrayList(mods.length);
        this.modifications.addAll(Arrays.asList(mods));
    }

    public ModifyRequest(String dn, List<Modification> mods) {
        super(null);
        Validator.ensureNotNull(dn, mods);
        Validator.ensureFalse(mods.isEmpty(), "ModifyRequest.mods must not be empty.");
        this.dn = dn;
        this.modifications = new ArrayList<Modification>(mods);
    }

    public ModifyRequest(DN dn, Modification mod) {
        super(null);
        Validator.ensureNotNull(dn, mod);
        this.dn = dn.toString();
        this.modifications = new ArrayList(1);
        this.modifications.add(mod);
    }

    public ModifyRequest(DN dn, Modification ... mods) {
        super(null);
        Validator.ensureNotNull(dn, mods);
        Validator.ensureFalse(mods.length == 0, "ModifyRequest.mods must not be empty.");
        this.dn = dn.toString();
        this.modifications = new ArrayList(mods.length);
        this.modifications.addAll(Arrays.asList(mods));
    }

    public ModifyRequest(DN dn, List<Modification> mods) {
        super(null);
        Validator.ensureNotNull(dn, mods);
        Validator.ensureFalse(mods.isEmpty(), "ModifyRequest.mods must not be empty.");
        this.dn = dn.toString();
        this.modifications = new ArrayList<Modification>(mods);
    }

    public ModifyRequest(String dn, Modification mod, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, mod);
        this.dn = dn;
        this.modifications = new ArrayList(1);
        this.modifications.add(mod);
    }

    public ModifyRequest(String dn, Modification[] mods, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, mods);
        Validator.ensureFalse(mods.length == 0, "ModifyRequest.mods must not be empty.");
        this.dn = dn;
        this.modifications = new ArrayList(mods.length);
        this.modifications.addAll(Arrays.asList(mods));
    }

    public ModifyRequest(String dn, List<Modification> mods, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, mods);
        Validator.ensureFalse(mods.isEmpty(), "ModifyRequest.mods must not be empty.");
        this.dn = dn;
        this.modifications = new ArrayList<Modification>(mods);
    }

    public ModifyRequest(DN dn, Modification mod, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, mod);
        this.dn = dn.toString();
        this.modifications = new ArrayList(1);
        this.modifications.add(mod);
    }

    public ModifyRequest(DN dn, Modification[] mods, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, mods);
        Validator.ensureFalse(mods.length == 0, "ModifyRequest.mods must not be empty.");
        this.dn = dn.toString();
        this.modifications = new ArrayList(mods.length);
        this.modifications.addAll(Arrays.asList(mods));
    }

    public ModifyRequest(DN dn, List<Modification> mods, Control[] controls) {
        super(controls);
        Validator.ensureNotNull(dn, mods);
        Validator.ensureFalse(mods.isEmpty(), "ModifyRequest.mods must not be empty.");
        this.dn = dn.toString();
        this.modifications = new ArrayList<Modification>(mods);
    }

    public ModifyRequest(String ... ldifModificationLines) throws LDIFException {
        super(null);
        LDIFChangeRecord changeRecord = LDIFReader.decodeChangeRecord(ldifModificationLines);
        if (!(changeRecord instanceof LDIFModifyChangeRecord)) {
            throw new LDIFException(LDAPMessages.ERR_MODIFY_INVALID_LDIF.get(), 0L, false, ldifModificationLines, null);
        }
        LDIFModifyChangeRecord modifyRecord = (LDIFModifyChangeRecord)changeRecord;
        ModifyRequest r = modifyRecord.toModifyRequest();
        this.dn = r.dn;
        this.modifications = r.modifications;
    }

    @Override
    public String getDN() {
        return this.dn;
    }

    public void setDN(String dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn;
    }

    public void setDN(DN dn) {
        Validator.ensureNotNull(dn);
        this.dn = dn.toString();
    }

    @Override
    public List<Modification> getModifications() {
        return Collections.unmodifiableList(this.modifications);
    }

    public void addModification(Modification mod) {
        Validator.ensureNotNull(mod);
        this.modifications.add(mod);
    }

    public boolean removeModification(Modification mod) {
        Validator.ensureNotNull(mod);
        return this.modifications.remove(mod);
    }

    public void setModifications(Modification mod) {
        Validator.ensureNotNull(mod);
        this.modifications.clear();
        this.modifications.add(mod);
    }

    public void setModifications(Modification[] mods) {
        Validator.ensureNotNull(mods);
        Validator.ensureFalse(mods.length == 0, "ModifyRequest.setModifications.mods must not be empty.");
        this.modifications.clear();
        this.modifications.addAll(Arrays.asList(mods));
    }

    public void setModifications(List<Modification> mods) {
        Validator.ensureNotNull(mods);
        Validator.ensureFalse(mods.isEmpty(), "ModifyRequest.setModifications.mods must not be empty.");
        this.modifications.clear();
        this.modifications.addAll(mods);
    }

    @Override
    public byte getProtocolOpType() {
        return 102;
    }

    @Override
    public void writeTo(ASN1Buffer writer) {
        ASN1BufferSequence requestSequence = writer.beginSequence((byte)102);
        writer.addOctetString(this.dn);
        ASN1BufferSequence modSequence = writer.beginSequence();
        for (Modification m : this.modifications) {
            m.writeTo(writer);
        }
        modSequence.end();
        requestSequence.end();
    }

    ASN1Element encodeProtocolOp() {
        ASN1Element[] modElements = new ASN1Element[this.modifications.size()];
        for (int i = 0; i < modElements.length; ++i) {
            modElements[i] = this.modifications.get(i).encode();
        }
        ASN1Element[] protocolOpElements = new ASN1Element[]{new ASN1OctetString(this.dn), new ASN1Sequence(modElements)};
        return new ASN1Sequence(102, protocolOpElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LDAPResult process(LDAPConnection connection, int depth) throws LDAPException {
        if (connection.synchronousMode()) {
            return this.processSync(connection, depth);
        }
        long requestTime = System.nanoTime();
        this.processAsync(connection, null);
        try {
            LDAPResponse response;
            try {
                long responseTimeout = this.getResponseTimeoutMillis(connection);
                response = responseTimeout > 0L ? this.responseQueue.poll(responseTimeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_MODIFY_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            LDAPResult lDAPResult = this.handleResponse(connection, response, requestTime, depth);
            return lDAPResult;
        }
        finally {
            connection.deregisterResponseAcceptor(this.messageID);
        }
    }

    int processAsync(LDAPConnection connection, AsyncResultListener resultListener) throws LDAPException {
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        if (resultListener == null) {
            connection.registerResponseAcceptor(this.messageID, this);
        } else {
            AsyncHelper helper = new AsyncHelper(connection, 103, resultListener, this.getIntermediateResponseListener());
            connection.registerResponseAcceptor(this.messageID, helper);
        }
        try {
            Debug.debugLDAPRequest(this);
            connection.getConnectionStatistics().incrementNumModifyRequests();
            connection.sendMessage(message);
            return this.messageID;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            connection.deregisterResponseAcceptor(this.messageID);
            throw le;
        }
    }

    private LDAPResult processSync(LDAPConnection connection, int depth) throws LDAPException {
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            connection.getConnectionInternals().getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(connection));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        long requestTime = System.nanoTime();
        Debug.debugLDAPRequest(this);
        connection.getConnectionStatistics().incrementNumModifyRequests();
        connection.sendMessage(message);
        LDAPResponse response = connection.readResponse(this.messageID);
        return this.handleResponse(connection, response, requestTime, depth);
    }

    private LDAPResult handleResponse(LDAPConnection connection, LDAPResponse response, long requestTime, int depth) throws LDAPException {
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_MODIFY_CLIENT_TIMEOUT.get(waitTime, connection.getHostPort()));
        }
        connection.getConnectionStatistics().incrementNumModifyResponses(System.nanoTime() - requestTime);
        if (response instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_MODIFY_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_MODIFY_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), message));
        }
        LDAPResult result = (LDAPResult)response;
        if (result.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(connection)) {
            if (depth >= connection.getConnectionOptions().getReferralHopLimit()) {
                return new LDAPResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), result.getMatchedDN(), result.getReferralURLs(), result.getResponseControls());
            }
            return this.followReferral(result, connection, depth);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPResult followReferral(LDAPResult referralResult, LDAPConnection connection, int depth) throws LDAPException {
        for (String urlString : referralResult.getReferralURLs()) {
            LDAPURL referralURL = new LDAPURL(urlString);
            String host = referralURL.getHost();
            if (host == null) continue;
            ModifyRequest modifyRequest = referralURL.baseDNProvided() ? new ModifyRequest(referralURL.getBaseDN(), this.modifications, this.getControls()) : this;
            LDAPConnection referralConn = connection.getReferralConnection(referralURL, connection);
            try {
                LDAPResult lDAPResult = modifyRequest.process(referralConn, depth + 1);
                referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                referralConn.close();
                return lDAPResult;
            }
            catch (Throwable throwable) {
                try {
                    referralConn.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    referralConn.close();
                    throw throwable;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
        }
        return referralResult;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public ModifyRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public ModifyRequest duplicate(Control[] controls) {
        ModifyRequest r = new ModifyRequest(this.dn, new ArrayList<Modification>(this.modifications), controls);
        if (this.followReferralsInternal() != null) {
            r.setFollowReferrals(this.followReferralsInternal());
        }
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    public LDIFModifyChangeRecord toLDIFChangeRecord() {
        return new LDIFModifyChangeRecord(this);
    }

    @Override
    public String[] toLDIF() {
        return this.toLDIFChangeRecord().toLDIF();
    }

    @Override
    public String toLDIFString() {
        return this.toLDIFChangeRecord().toLDIFString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ModifyRequest(dn='");
        buffer.append(this.dn);
        buffer.append("', mods={");
        for (int i = 0; i < this.modifications.size(); ++i) {
            Modification m = this.modifications.get(i);
            if (i > 0) {
                buffer.append(", ");
            }
            switch (m.getModificationType().intValue()) {
                case 0: {
                    buffer.append("ADD ");
                    break;
                }
                case 1: {
                    buffer.append("DELETE ");
                    break;
                }
                case 2: {
                    buffer.append("REPLACE ");
                    break;
                }
                case 3: {
                    buffer.append("INCREMENT ");
                }
            }
            buffer.append(m.getAttributeName());
        }
        buffer.append('}');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

