/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PreReadResponseControl
extends Control
implements DecodeableControl {
    public static final String PRE_READ_RESPONSE_OID = "1.3.6.1.1.13.1";
    private static final long serialVersionUID = -4719875382095056686L;
    private final ReadOnlyEntry entry;

    PreReadResponseControl() {
        this.entry = null;
    }

    public PreReadResponseControl(ReadOnlyEntry entry) {
        super(PRE_READ_RESPONSE_OID, false, PreReadResponseControl.encodeValue(entry));
        this.entry = entry;
    }

    public PreReadResponseControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        ASN1Sequence attrSequence;
        ASN1Sequence entrySequence;
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PRE_READ_RESPONSE_NO_VALUE.get());
        }
        try {
            ASN1Element entryElement = ASN1Element.decode(value.getValue());
            entrySequence = ASN1Sequence.decodeAsSequence(entryElement);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PRE_READ_RESPONSE_VALUE_NOT_SEQUENCE.get(ae), ae);
        }
        ASN1Element[] entryElements = entrySequence.elements();
        if (entryElements.length != 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PRE_READ_RESPONSE_INVALID_ELEMENT_COUNT.get(entryElements.length));
        }
        String dn = ASN1OctetString.decodeAsOctetString(entryElements[0]).stringValue();
        try {
            attrSequence = ASN1Sequence.decodeAsSequence(entryElements[1]);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PRE_READ_RESPONSE_ATTRIBUTES_NOT_SEQUENCE.get(ae), ae);
        }
        ASN1Element[] attrElements = attrSequence.elements();
        Attribute[] attrs = new Attribute[attrElements.length];
        for (int i = 0; i < attrElements.length; ++i) {
            try {
                attrs[i] = Attribute.decode(ASN1Sequence.decodeAsSequence(attrElements[i]));
                continue;
            }
            catch (ASN1Exception ae) {
                Debug.debugException(ae);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PRE_READ_RESPONSE_ATTR_NOT_SEQUENCE.get(ae), ae);
            }
        }
        this.entry = new ReadOnlyEntry(dn, attrs);
    }

    public PreReadResponseControl decodeControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        return new PreReadResponseControl(oid, isCritical, value);
    }

    private static ASN1OctetString encodeValue(ReadOnlyEntry entry) {
        Validator.ensureNotNull(entry);
        Collection<Attribute> attrs = entry.getAttributes();
        ArrayList<ASN1Sequence> attrElements = new ArrayList<ASN1Sequence>(attrs.size());
        for (Attribute a : attrs) {
            attrElements.add(a.encode());
        }
        ASN1Element[] entryElements = new ASN1Element[]{new ASN1OctetString(entry.getDN()), new ASN1Sequence(attrElements)};
        return new ASN1OctetString(new ASN1Sequence(entryElements).encode());
    }

    public ReadOnlyEntry getEntry() {
        return this.entry;
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PRE_READ_RESPONSE.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("PreReadResponseControl(entry=");
        this.entry.toString(buffer);
        buffer.append(", isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

