/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.ValuePattern;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class ModRateThread
extends Thread {
    private final AtomicBoolean stopRequested;
    private final AtomicLong errorCounter;
    private final AtomicLong modCounter;
    private final AtomicLong modDurations;
    private final AtomicReference<ResultCode> resultCode;
    private final byte[] charSet;
    private final CyclicBarrier startBarrier;
    private final int valueLength;
    private final LDAPConnection connection;
    private final ResultCodeCounter rcCounter;
    private final Random random;
    private final String[] attributes;
    private final AtomicReference<Thread> modThread;
    private final ValuePattern authzID;
    private final ValuePattern entryDN;
    private final FixedRateBarrier fixedRateBarrier;

    ModRateThread(int threadNumber, LDAPConnection connection, ValuePattern entryDN, String[] attributes, byte[] charSet, int valueLength, ValuePattern authzID, long randomSeed, CyclicBarrier startBarrier, AtomicLong modCounter, AtomicLong modDurations, AtomicLong errorCounter, ResultCodeCounter rcCounter, FixedRateBarrier rateBarrier) {
        this.setName("ModRate Thread " + threadNumber);
        this.setDaemon(true);
        this.connection = connection;
        this.entryDN = entryDN;
        this.attributes = attributes;
        this.charSet = charSet;
        this.valueLength = valueLength;
        this.authzID = authzID;
        this.modCounter = modCounter;
        this.modDurations = modDurations;
        this.errorCounter = errorCounter;
        this.rcCounter = rcCounter;
        this.startBarrier = startBarrier;
        this.fixedRateBarrier = rateBarrier;
        connection.setConnectionName("mod-" + threadNumber);
        this.resultCode = new AtomicReference<Object>(null);
        this.modThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
        this.random = new Random(randomSeed);
    }

    public void run() {
        this.modThread.set(ModRateThread.currentThread());
        Modification[] mods = new Modification[this.attributes.length];
        byte[] valueBytes = new byte[this.valueLength];
        ASN1OctetString[] values = new ASN1OctetString[1];
        ModifyRequest modifyRequest = new ModifyRequest("", mods);
        try {
            this.startBarrier.await();
        }
        catch (Exception e) {
            // empty catch block
        }
        while (!this.stopRequested.get()) {
            int i;
            modifyRequest.setDN(this.entryDN.nextValue());
            for (i = 0; i < this.valueLength; ++i) {
                valueBytes[i] = this.charSet[this.random.nextInt(this.charSet.length)];
            }
            values[0] = new ASN1OctetString(valueBytes);
            for (i = 0; i < this.attributes.length; ++i) {
                mods[i] = new Modification(ModificationType.REPLACE, this.attributes[i], values);
            }
            modifyRequest.setModifications(mods);
            if (this.authzID != null) {
                modifyRequest.setControls(new ProxiedAuthorizationV2RequestControl(this.authzID.nextValue()));
            }
            if (this.fixedRateBarrier != null) {
                this.fixedRateBarrier.await();
            }
            long startTime = System.nanoTime();
            try {
                this.connection.modify(modifyRequest);
            }
            catch (LDAPException le) {
                this.errorCounter.incrementAndGet();
                ResultCode rc = le.getResultCode();
                this.rcCounter.increment(rc);
                this.resultCode.compareAndSet(null, rc);
            }
            this.modCounter.incrementAndGet();
            this.modDurations.addAndGet(System.nanoTime() - startTime);
        }
        this.connection.close();
        this.modThread.set(null);
    }

    public ResultCode stopRunning() {
        Thread t;
        this.stopRequested.set(true);
        if (this.fixedRateBarrier != null) {
            this.fixedRateBarrier.shutdownRequested();
        }
        if ((t = this.modThread.get()) != null) {
            try {
                t.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }
}

