/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.util.ByteString;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ByteStringBuffer
implements Serializable {
    private static final int DEFAULT_INITIAL_CAPACITY = 20;
    private static final long serialVersionUID = 2899392249591230998L;
    private byte[] array;
    private int capacity;
    private int endPos;

    public ByteStringBuffer() {
        this(20);
    }

    public ByteStringBuffer(int initialCapacity) {
        this.array = new byte[initialCapacity];
        this.capacity = initialCapacity;
        this.endPos = 0;
    }

    public ByteStringBuffer append(byte b) {
        this.ensureCapacity(this.endPos + 1);
        this.array[this.endPos++] = b;
        return this;
    }

    public ByteStringBuffer append(byte[] b) throws NullPointerException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.append(b, 0, b.length);
    }

    public ByteStringBuffer append(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            String message = off < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(off) : (len < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(len) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(off, len, b.length));
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (len > 0) {
            this.ensureCapacity(this.endPos + len);
            System.arraycopy(b, off, this.array, this.endPos, len);
            this.endPos += len;
        }
        return this;
    }

    public ByteStringBuffer append(ByteString b) throws NullPointerException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BYTE_STRING_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        b.appendValueTo(this);
        return this;
    }

    public ByteStringBuffer append(ByteStringBuffer buffer) throws NullPointerException {
        if (buffer == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BUFFER_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.append(buffer.array, 0, buffer.endPos);
    }

    public ByteStringBuffer append(char c) {
        byte b = (byte)(c & 0x7F);
        if (b == c) {
            this.ensureCapacity(this.endPos + 1);
            this.array[this.endPos++] = b;
        } else {
            this.append(String.valueOf(c));
        }
        return this;
    }

    public ByteStringBuffer append(char[] c) throws NullPointerException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.append(c, 0, c.length);
    }

    public ByteStringBuffer append(char[] c, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (off < 0 || len < 0 || off + len > c.length) {
            String message = off < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(off) : (len < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(len) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(off, len, c.length));
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (len > 0) {
            this.ensureCapacity(this.endPos + len);
            int pos = off;
            int i = 0;
            while (i < len) {
                byte b = (byte)(c[pos] & 0x7F);
                if (b != c[pos]) {
                    this.append(String.valueOf(c, pos, off + len - pos));
                    break;
                }
                this.array[this.endPos++] = b;
                ++i;
                ++pos;
            }
        }
        return this;
    }

    public ByteStringBuffer append(CharSequence s) throws NullPointerException {
        if (s == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_CHAR_SEQUENCE_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        int length = s.length();
        this.ensureCapacity(this.endPos + length);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            byte b = (byte)(c & 0x7F);
            if (b != c) {
                this.append(StaticUtils.getBytes(((Object)s.subSequence(i, length)).toString()));
                break;
            }
            this.array[this.endPos++] = b;
        }
        return this;
    }

    public ByteStringBuffer insert(int pos, byte b) throws IndexOutOfBoundsException {
        if (pos < 0 || pos > this.endPos) {
            String message = pos < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(pos) : UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(pos, this.endPos);
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (pos == this.endPos) {
            return this.append(b);
        }
        this.ensureCapacity(this.endPos + 1);
        System.arraycopy(this.array, pos, this.array, pos + 1, this.endPos - pos);
        this.array[pos] = b;
        ++this.endPos;
        return this;
    }

    public ByteStringBuffer insert(int pos, byte[] b) throws NullPointerException, IndexOutOfBoundsException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.insert(pos, b, 0, b.length);
    }

    public ByteStringBuffer insert(int pos, byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (pos < 0 || pos > this.endPos || off < 0 || len < 0 || off + len > b.length) {
            String message = pos < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(pos) : (pos > this.endPos ? UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(pos, this.endPos) : (off < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(off) : (len < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(len) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(off, len, b.length))));
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (len == 0) {
            return this;
        }
        if (pos == this.endPos) {
            return this.append(b, off, len);
        }
        this.ensureCapacity(this.endPos + len);
        System.arraycopy(this.array, pos, this.array, pos + len, this.endPos - pos);
        System.arraycopy(b, off, this.array, pos, len);
        this.endPos += len;
        return this;
    }

    public ByteStringBuffer insert(int pos, ByteString b) throws NullPointerException, IndexOutOfBoundsException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BYTE_STRING_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.insert(pos, b.getValue());
    }

    public ByteStringBuffer insert(int pos, ByteStringBuffer buffer) throws NullPointerException, IndexOutOfBoundsException {
        if (buffer == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BUFFER_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.insert(pos, buffer.array, 0, buffer.endPos);
    }

    public ByteStringBuffer insert(int pos, char c) throws IndexOutOfBoundsException {
        if (pos < 0 || pos > this.endPos) {
            String message = pos < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(pos) : UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(pos, this.endPos);
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (pos == this.endPos) {
            return this.append(c);
        }
        byte b = (byte)(c & 0x7F);
        if (b == c) {
            this.ensureCapacity(this.endPos + 1);
            System.arraycopy(this.array, pos, this.array, pos + 1, this.endPos - pos);
            this.array[pos] = b;
            ++this.endPos;
        } else {
            this.insert(pos, String.valueOf(c));
        }
        return this;
    }

    public ByteStringBuffer insert(int pos, char[] c) throws NullPointerException, IndexOutOfBoundsException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.insert(pos, new String(c, 0, c.length));
    }

    public ByteStringBuffer insert(int pos, char[] c, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        return this.insert(pos, new String(c, off, len));
    }

    public ByteStringBuffer insert(int pos, CharSequence s) throws NullPointerException, IndexOutOfBoundsException {
        if (s == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_CHAR_SEQUENCE_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (pos < 0 || pos > this.endPos) {
            String message = pos < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(pos) : UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(pos, this.endPos);
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        if (pos == this.endPos) {
            return this.append(s);
        }
        return this.insert(pos, StaticUtils.getBytes(((Object)s).toString()));
    }

    public ByteStringBuffer set(byte b) {
        this.endPos = 0;
        return this.append(b);
    }

    public ByteStringBuffer set(byte[] b) throws NullPointerException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(b, 0, b.length);
    }

    public ByteStringBuffer set(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            String message = off < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(off) : (len < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(len) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(off, len, b.length));
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(b, off, len);
    }

    public ByteStringBuffer set(ByteString b) throws NullPointerException {
        if (b == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BYTE_STRING_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        b.appendValueTo(this);
        return this;
    }

    public ByteStringBuffer set(ByteStringBuffer buffer) throws NullPointerException {
        if (buffer == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BUFFER_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(buffer.array, 0, buffer.endPos);
    }

    public ByteStringBuffer set(char c) {
        this.endPos = 0;
        return this.append(c);
    }

    public ByteStringBuffer set(char[] c) throws NullPointerException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(c, 0, c.length);
    }

    public ByteStringBuffer set(char[] c, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        if (c == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        if (off < 0 || len < 0 || off + len > c.length) {
            String message = off < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(off) : (len < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(len) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(off, len, c.length));
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(message);
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(c, off, len);
    }

    public ByteStringBuffer set(CharSequence s) throws NullPointerException {
        if (s == null) {
            NullPointerException e = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_CHAR_SEQUENCE_NULL.get());
            Debug.debugCodingError(e);
            throw e;
        }
        this.endPos = 0;
        return this.append(s);
    }

    public ByteStringBuffer clear() {
        this.endPos = 0;
        return this;
    }

    public byte[] getBackingArray() {
        return this.array;
    }

    public boolean isEmpty() {
        return this.endPos == 0;
    }

    public int length() {
        return this.endPos;
    }

    public void setLength(int length) throws IndexOutOfBoundsException {
        if (length < 0) {
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(length));
            Debug.debugCodingError(e);
            throw e;
        }
        if (length > this.endPos) {
            this.ensureCapacity(length);
            Arrays.fill(this.array, this.endPos, length, (byte)0);
            this.endPos = length;
        } else {
            this.endPos = length;
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (this.capacity < minimumCapacity) {
            int newCapacity = Math.max(minimumCapacity, 2 * this.capacity + 2);
            byte[] newArray = new byte[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, this.capacity);
            this.array = newArray;
            this.capacity = newCapacity;
        }
    }

    public void setCapacity(int capacity) throws IndexOutOfBoundsException {
        if (capacity < 0) {
            IndexOutOfBoundsException e = new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_CAPACITY_NEGATIVE.get(capacity));
            Debug.debugCodingError(e);
            throw e;
        }
        if (this.capacity == capacity) {
            return;
        }
        if (this.capacity < capacity) {
            byte[] newArray = new byte[capacity];
            System.arraycopy(this.array, 0, newArray, 0, this.capacity);
            this.array = newArray;
            this.capacity = capacity;
        } else {
            byte[] newArray = new byte[capacity];
            System.arraycopy(this.array, 0, newArray, 0, capacity);
            this.array = newArray;
            this.endPos = Math.min(this.endPos, capacity);
            this.capacity = capacity;
        }
    }

    public ByteStringBuffer trimToSize() {
        if (this.endPos != this.capacity) {
            byte[] newArray = new byte[this.endPos];
            System.arraycopy(this.array, 0, newArray, 0, this.endPos);
            this.array = newArray;
            this.capacity = this.endPos;
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] newArray = new byte[this.endPos];
        System.arraycopy(this.array, 0, newArray, 0, this.endPos);
        return newArray;
    }

    public ByteString toByteString() {
        return new ASN1OctetString(this.array, 0, this.endPos);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.array, 0, this.endPos);
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.endPos; ++i) {
            hashCode += this.array[i];
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteStringBuffer)) {
            return false;
        }
        ByteStringBuffer b = (ByteStringBuffer)o;
        if (this.endPos != b.endPos) {
            return false;
        }
        for (int i = 0; i < this.endPos; ++i) {
            if (this.array[i] == b.array[i]) continue;
            return false;
        }
        return true;
    }

    public ByteStringBuffer duplicate() {
        ByteStringBuffer newBuffer = new ByteStringBuffer(this.endPos);
        return newBuffer.append(this);
    }

    public String toString() {
        return StaticUtils.toUTF8String(this.array, 0, this.endPos);
    }
}

