/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FixedRateBarrier
implements Serializable {
    private static final long serialVersionUID = -3490156685189909611L;
    private final long intervalDurationNanos;
    private final int perInterval;
    private volatile boolean shutdownRequested = false;
    private long countInThisInterval = 0L;
    private long intervalStartNanos = 0L;
    private long intervalEndNanos = 0L;

    public FixedRateBarrier(long intervalDurationMs, int perInterval) {
        Validator.ensureTrue(intervalDurationMs > 0L, "FixedRateBarrier.intervalDurationMs must be at least 1.");
        Validator.ensureTrue(perInterval > 0, "FixedRateBarrier.perInterval must be at least 1.");
        this.perInterval = perInterval;
        this.intervalDurationNanos = 1000000L * intervalDurationMs;
    }

    public synchronized boolean await() {
        while (!this.shutdownRequested) {
            long intervalRemaining;
            long now = System.nanoTime();
            if (this.intervalStartNanos == 0L || now < this.intervalStartNanos) {
                this.intervalStartNanos = now;
                this.intervalEndNanos = this.intervalStartNanos + this.intervalDurationNanos;
            } else if (now >= this.intervalEndNanos) {
                this.countInThisInterval = 0L;
                this.intervalStartNanos = now < this.intervalEndNanos + this.intervalDurationNanos ? now : this.intervalEndNanos;
                this.intervalEndNanos = this.intervalStartNanos + this.intervalDurationNanos;
            }
            if ((intervalRemaining = this.intervalEndNanos - now) <= 0L) continue;
            long actualRemaining = (long)this.perInterval - this.countInThisInterval;
            double intervalFractionRemaining = (double)intervalRemaining / (double)this.intervalDurationNanos;
            double expectedRemaining = intervalFractionRemaining * (double)this.perInterval;
            if ((double)actualRemaining >= expectedRemaining) {
                ++this.countInThisInterval;
                break;
            }
            Thread.yield();
        }
        return this.shutdownRequested;
    }

    public void shutdownRequested() {
        this.shutdownRequested = true;
    }

    public boolean isShutdownRequested() {
        return this.shutdownRequested;
    }
}

