/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.UtilityMessages;
import com.unboundid.util.ValuePatternComponent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import java.util.Random;

final class HTTPValuePatternComponent
extends ValuePatternComponent {
    private static final long serialVersionUID = 8879412445617836376L;
    private final String[] lines;
    private final Random seedRandom;
    private final ThreadLocal<Random> random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HTTPValuePatternComponent(String url, long seed) throws IOException {
        this.seedRandom = new Random(seed);
        this.random = new ThreadLocal();
        LinkedList<String> lineList = new LinkedList<String>();
        URL parsedURL = new URL(url);
        HttpURLConnection urlConnection = (HttpURLConnection)parsedURL.openConnection();
        BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lineList.add(line);
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        if (lineList.isEmpty()) {
            throw new IOException(UtilityMessages.ERR_VALUE_PATTERN_COMPONENT_EMPTY_FILE.get());
        }
        this.lines = new String[lineList.size()];
        lineList.toArray(this.lines);
    }

    void append(StringBuilder buffer) {
        Random r = this.random.get();
        if (r == null) {
            r = new Random(this.seedRandom.nextLong());
            this.random.set(r);
        }
        buffer.append(this.lines[r.nextInt(this.lines.length)]);
    }
}

