/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AsyncSearchHelper;
import com.unboundid.ldap.sdk.CommonAsyncHelper;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.util.TimerTask;

final class AsyncTimeoutTimerTask
extends TimerTask {
    private final CommonAsyncHelper helper;

    AsyncTimeoutTimerTask(CommonAsyncHelper helper) {
        this.helper = helper;
    }

    public void run() {
        LDAPResult response;
        long waitTimeNanos = System.nanoTime() - this.helper.getCreateTimeNanos();
        long waitTimeMillis = waitTimeNanos / 1000000L;
        LDAPConnection conn = this.helper.getConnection();
        boolean abandon = conn.getConnectionOptions().abandonOnTimeout();
        String message = abandon ? LDAPMessages.INFO_ASYNC_OPERATION_TIMEOUT_WITH_ABANDON.get(waitTimeMillis) : LDAPMessages.INFO_ASYNC_OPERATION_TIMEOUT_WITHOUT_ABANDON.get(waitTimeMillis);
        switch (this.helper.getOperationType()) {
            case ADD: 
            case DELETE: 
            case MODIFY: 
            case MODIFY_DN: {
                response = new LDAPResult(this.helper.getAsyncRequestID().getMessageID(), ResultCode.TIMEOUT, message, null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS);
                break;
            }
            case COMPARE: {
                response = new CompareResult(this.helper.getAsyncRequestID().getMessageID(), ResultCode.TIMEOUT, message, null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS);
                break;
            }
            case SEARCH: {
                AsyncSearchHelper searchHelper = (AsyncSearchHelper)this.helper;
                response = new SearchResult(this.helper.getAsyncRequestID().getMessageID(), ResultCode.TIMEOUT, message, null, StaticUtils.NO_STRINGS, searchHelper.getNumEntries(), searchHelper.getNumReferences(), StaticUtils.NO_CONTROLS);
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.helper.responseReceived(response);
            if (abandon) {
                conn.abandon(this.helper.getAsyncRequestID());
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
        }
    }
}

