/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLMessages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PromptTrustManager
implements X509TrustManager {
    private final boolean examineValidityDates;
    private final ConcurrentHashMap<String, Boolean> acceptedCerts;
    private final InputStream in;
    private final PrintStream out;
    private final String acceptedCertsFile;

    public PromptTrustManager() {
        this(null, true, null, null);
    }

    public PromptTrustManager(String acceptedCertsFile) {
        this(acceptedCertsFile, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PromptTrustManager(String acceptedCertsFile, boolean examineValidityDates, InputStream in, PrintStream out) {
        this.acceptedCertsFile = acceptedCertsFile;
        this.examineValidityDates = examineValidityDates;
        this.in = in == null ? System.in : in;
        this.out = out == null ? System.out : out;
        this.acceptedCerts = new ConcurrentHashMap();
        if (acceptedCertsFile == null) return;
        BufferedReader r = null;
        File f = new File(acceptedCertsFile);
        if (f.exists()) {
            String line;
            r = new BufferedReader(new FileReader(f));
            while ((line = r.readLine()) != null) {
                this.acceptedCerts.put(line, false);
            }
        }
        Object var9_9 = null;
        if (r == null) return;
        try {
            r.close();
            return;
        }
        catch (Exception e2) {
            Debug.debugException(e2);
        }
        return;
        {
            catch (Exception e) {
                Debug.debugException(e);
                Object var9_10 = null;
                if (r == null) return;
                try {
                    r.close();
                    return;
                }
                catch (Exception e2) {
                    Debug.debugException(e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (r == null) throw throwable;
            try {
                r.close();
                throw throwable;
            }
            catch (Exception e2) {
                Debug.debugException(e2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeCacheFile() throws IOException {
        File cacheFile;
        File tempFile;
        block6: {
            tempFile = new File(this.acceptedCertsFile + ".new");
            BufferedWriter w = null;
            try {
                w = new BufferedWriter(new FileWriter(tempFile));
                for (String certBytes : this.acceptedCerts.keySet()) {
                    w.write(certBytes);
                    w.newLine();
                }
                Object var6_5 = null;
                if (w == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (w != null) {
                    w.close();
                }
                throw throwable;
            }
            w.close();
        }
        if ((cacheFile = new File(this.acceptedCertsFile)).exists()) {
            File oldFile = new File(this.acceptedCertsFile + ".previous");
            if (oldFile.exists()) {
                oldFile.delete();
            }
            cacheFile.renameTo(oldFile);
        }
        tempFile.renameTo(cacheFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void checkCertificateChain(X509Certificate[] chain) throws CertificateException {
        Date currentDate = new Date();
        for (X509Certificate c : chain) {
            String certBytes = StaticUtils.toLowerCase(StaticUtils.toHex(c.getSignature()));
            Boolean acceptedWithValidity = this.acceptedCerts.get(certBytes);
            if (acceptedWithValidity == null) {
                continue;
            }
            if (acceptedWithValidity != false) return;
            if (!this.examineValidityDates) {
                return;
            }
            if (currentDate.before(c.getNotBefore())) break;
            if (!currentDate.after(c.getNotAfter())) return;
            break;
        }
        X509Certificate c = chain[0];
        this.out.println(SSLMessages.INFO_PROMPT_HEADING.get());
        this.out.println(SSLMessages.INFO_PROMPT_SUBJECT.get(String.valueOf(c.getSubjectX500Principal())));
        this.out.println(SSLMessages.INFO_PROMPT_ISSUER.get(String.valueOf(c.getIssuerX500Principal())));
        this.out.println(SSLMessages.INFO_PROMPT_VALIDITY.get(String.valueOf(c.getNotBefore()), String.valueOf(c.getNotAfter())));
        boolean outsideValidityWindow = false;
        if (currentDate.before(c.getNotBefore())) {
            outsideValidityWindow = true;
            this.out.println();
            this.out.println(SSLMessages.WARN_PROMPT_NOT_YET_VALID.get());
            this.out.println();
        } else if (currentDate.after(c.getNotAfter())) {
            outsideValidityWindow = true;
            this.out.println();
            this.out.println(SSLMessages.WARN_PROMPT_EXPIRED.get());
            this.out.println();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
        block6: while (true) {
            try {
                String line;
                do {
                    this.out.println();
                    this.out.println(SSLMessages.INFO_PROMPT_MESSAGE.get());
                    this.out.flush();
                    line = reader.readLine();
                    if (line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes")) break block6;
                    if (line.equalsIgnoreCase("n")) throw new CertificateException(SSLMessages.ERR_CERTIFICATE_REJECTED_BY_USER.get());
                } while (!line.equalsIgnoreCase("no"));
                throw new CertificateException(SSLMessages.ERR_CERTIFICATE_REJECTED_BY_USER.get());
            }
            catch (CertificateException ce) {
                throw ce;
            }
            catch (Exception e) {
                Debug.debugException(e);
                continue;
            }
            break;
        }
        String certBytes = StaticUtils.toLowerCase(StaticUtils.toHex(c.getSignature()));
        this.acceptedCerts.put(certBytes, outsideValidityWindow);
        if (this.acceptedCertsFile == null) return;
        try {
            this.writeCacheFile();
            return;
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    public boolean examineValidityDates() {
        return this.examineValidityDates;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificateChain(chain);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificateChain(chain);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

