/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.examples.AuthRateThread;
import com.unboundid.util.ColumnFormatter;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ValuePattern;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class AuthRate
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = 6918029871717330547L;
    private BooleanArgument csvFormat;
    private BooleanArgument suppressErrorsArgument;
    private IntegerArgument collectionInterval;
    private IntegerArgument numIntervals;
    private IntegerArgument numThreads;
    private IntegerArgument randomSeed;
    private IntegerArgument ratePerSecond;
    private IntegerArgument warmUpIntervals;
    private StringArgument attributes;
    private StringArgument authType;
    private StringArgument baseDN;
    private StringArgument filter;
    private ScopeArgument scopeArg;
    private StringArgument timestampFormat;
    private StringArgument userPassword;

    public static void main(String[] args) {
        ResultCode resultCode = AuthRate.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        AuthRate authRate = new AuthRate(outStream, errStream);
        return authRate.runTool(args);
    }

    public AuthRate(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "authrate";
    }

    @Override
    public String getToolDescription() {
        return "Perform repeated authentications against an LDAP directory server, where each authentication consists of a search to find a user followed by a bind to verify the credentials for that user.";
    }

    @Override
    public String getToolVersion() {
        return "2.3.6";
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        String description = "The base DN to use for the searches.  It may be a simple DN or a value pattern to specify a range of DNs (e.g., \"uid=user.[1-1000],ou=People,dc=example,dc=com\").  This must be provided.";
        this.baseDN = new StringArgument(Character.valueOf('b'), "baseDN", true, 1, "{dn}", description);
        parser.addArgument(this.baseDN);
        description = "The scope to use for the searches.  It should be 'base', 'one', 'sub', or 'subord'.  If this is not provided, a default scope of 'sub' will be used.";
        this.scopeArg = new ScopeArgument(Character.valueOf('s'), "scope", false, "{scope}", description, SearchScope.SUB);
        parser.addArgument(this.scopeArg);
        description = "The filter to use for the searches.  It may be a simple filter or a value pattern to specify a range of filters (e.g., \"(uid=user.[1-1000])\").  This must be provided.";
        this.filter = new StringArgument(Character.valueOf('f'), "filter", true, 1, "{filter}", description);
        parser.addArgument(this.filter);
        description = "The name of an attribute to include in entries returned from the searches.  Multiple attributes may be requested by providing this argument multiple times.  If no return attributes are specified, then entries will be returned with all user attributes.";
        this.attributes = new StringArgument(Character.valueOf('A'), "attribute", false, 0, "{name}", description);
        parser.addArgument(this.attributes);
        description = "The password to use when binding as the users returned from the searches.  This must be provided.";
        this.userPassword = new StringArgument(Character.valueOf('C'), "credentials", true, 1, "{password}", description);
        parser.addArgument(this.userPassword);
        description = "The type of authentication to perform.  Allowed values are:  SIMPLE, CRAM-MD5, DIGEST-MD5, and PLAIN.  If no value is provided, then SIMPLE authentication will be performed.";
        LinkedHashSet<String> allowedAuthTypes = new LinkedHashSet<String>(4);
        allowedAuthTypes.add("simple");
        allowedAuthTypes.add("cram-md5");
        allowedAuthTypes.add("digest-md5");
        allowedAuthTypes.add("plain");
        this.authType = new StringArgument(Character.valueOf('a'), "authType", true, 1, "{authType}", description, allowedAuthTypes, "simple");
        parser.addArgument(this.authType);
        description = "The number of threads to use to perform the authentication processing.  If this is not provided, then a default of one thread will be used.";
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 1);
        parser.addArgument(this.numThreads);
        description = "The length of time in seconds between output lines.  If this is not provided, then a default interval of five seconds will be used.";
        this.collectionInterval = new IntegerArgument(Character.valueOf('i'), "intervalDuration", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 5);
        parser.addArgument(this.collectionInterval);
        description = "The maximum number of intervals for which to run.  If this is not provided, then the tool will run until it is interrupted.";
        this.numIntervals = new IntegerArgument(Character.valueOf('I'), "numIntervals", true, 1, "{num}", description, 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
        parser.addArgument(this.numIntervals);
        description = "The target number of authorizations to perform per second.  It is still necessary to specify a sufficient number of threads for achieving this rate.  If this option is not provided, then the tool will run at the maximum rate for the specified number of threads.";
        this.ratePerSecond = new IntegerArgument(Character.valueOf('r'), "ratePerSecond", false, 1, "{auths-per-second}", description, 1, Integer.MAX_VALUE);
        parser.addArgument(this.ratePerSecond);
        description = "The number of intervals to complete before beginning overall statistics collection.  Specifying a nonzero number of warm-up intervals gives the client and server a chance to warm up without skewing performance results.";
        this.warmUpIntervals = new IntegerArgument(null, "warmUpIntervals", true, 1, "{num}", description, 0, Integer.MAX_VALUE, 0);
        parser.addArgument(this.warmUpIntervals);
        description = "Indicates the format to use for timestamps included in the output.  A value of 'none' indicates that no timestamps should be included.  A value of 'with-date' indicates that both the date and the time should be included.  A value of 'without-date' indicates that only the time should be included.";
        LinkedHashSet<String> allowedFormats = new LinkedHashSet<String>(3);
        allowedFormats.add("none");
        allowedFormats.add("with-date");
        allowedFormats.add("without-date");
        this.timestampFormat = new StringArgument(null, "timestampFormat", true, 1, "{format}", description, allowedFormats, "none");
        parser.addArgument(this.timestampFormat);
        description = "Indicates that information about the result codes for failed operations should not be displayed.";
        this.suppressErrorsArgument = new BooleanArgument(null, "suppressErrorResultCodes", 1, description);
        parser.addArgument(this.suppressErrorsArgument);
        description = "Generate output in CSV format rather than a display-friendly format";
        this.csvFormat = new BooleanArgument(Character.valueOf('c'), "csv", 1, description);
        parser.addArgument(this.csvFormat);
        description = "Specifies the seed to use for the random number generator.";
        this.randomSeed = new IntegerArgument(Character.valueOf('R'), "randomSeed", false, 1, "{value}", description);
        parser.addArgument(this.randomSeed);
    }

    @Override
    protected boolean supportsMultipleServers() {
        return true;
    }

    @Override
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setAutoReconnect(true);
        options.setUseSynchronousMode(true);
        return options;
    }

    @Override
    public ResultCode doToolProcessing() {
        long totalIntervals;
        boolean warmUp;
        String timeFormat;
        boolean includeTimestamp;
        String[] attrs;
        ValuePattern filterPattern;
        ValuePattern dnPattern;
        Long seed = this.randomSeed.isPresent() ? Long.valueOf(this.randomSeed.getValue().intValue()) : null;
        try {
            dnPattern = new ValuePattern(this.baseDN.getValue(), seed);
        }
        catch (ParseException pe) {
            this.err("Unable to parse the base DN value pattern:  ", pe.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        try {
            filterPattern = new ValuePattern(this.filter.getValue(), seed);
        }
        catch (ParseException pe) {
            this.err("Unable to parse the filter pattern:  ", pe.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        if (this.attributes.isPresent()) {
            List<String> attrList = this.attributes.getValues();
            attrs = new String[attrList.size()];
            attrList.toArray(attrs);
        } else {
            attrs = StaticUtils.NO_STRINGS;
        }
        FixedRateBarrier fixedRateBarrier = null;
        if (this.ratePerSecond.isPresent()) {
            int intervalSeconds = this.collectionInterval.getValue();
            int ratePerInterval = this.ratePerSecond.getValue() * intervalSeconds;
            fixedRateBarrier = new FixedRateBarrier(1000L * (long)intervalSeconds, ratePerInterval);
        }
        if (this.timestampFormat.getValue().equalsIgnoreCase("with-date")) {
            includeTimestamp = true;
            timeFormat = "dd/MM/yyyy HH:mm:ss";
        } else if (this.timestampFormat.getValue().equalsIgnoreCase("without-date")) {
            includeTimestamp = true;
            timeFormat = "HH:mm:ss";
        } else {
            includeTimestamp = false;
            timeFormat = null;
        }
        int remainingWarmUpIntervals = this.warmUpIntervals.getValue();
        if (remainingWarmUpIntervals > 0) {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue() + (long)remainingWarmUpIntervals;
        } else {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue();
        }
        OutputFormat outputFormat = this.csvFormat.isPresent() ? OutputFormat.CSV : OutputFormat.COLUMNS;
        ColumnFormatter formatter = new ColumnFormatter(includeTimestamp, timeFormat, outputFormat, " ", new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Auths/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Avg Dur ms"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Errors/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Overall", "Auths/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Overall", "Avg Dur ms"));
        AtomicLong authCounter = new AtomicLong(0L);
        AtomicLong errorCounter = new AtomicLong(0L);
        AtomicLong authDurations = new AtomicLong(0L);
        ResultCodeCounter rcCounter = new ResultCodeCounter();
        long intervalMillis = 1000L * (long)this.collectionInterval.getValue().intValue();
        CyclicBarrier barrier = new CyclicBarrier(this.numThreads.getValue() + 1);
        AuthRateThread[] threads = new AuthRateThread[this.numThreads.getValue().intValue()];
        for (int i = 0; i < threads.length; ++i) {
            LDAPConnection bindConnection;
            LDAPConnection searchConnection;
            try {
                searchConnection = this.getConnection();
                bindConnection = this.getConnection();
            }
            catch (LDAPException le) {
                this.err("Unable to connect to the directory server:  ", StaticUtils.getExceptionMessage(le));
                return le.getResultCode();
            }
            threads[i] = new AuthRateThread(this, i, searchConnection, bindConnection, dnPattern, this.scopeArg.getValue(), filterPattern, attrs, this.userPassword.getValue(), this.authType.getValue(), barrier, authCounter, authDurations, errorCounter, rcCounter, fixedRateBarrier);
            threads[i].start();
        }
        for (String headerLine : formatter.getHeaderLines(true)) {
            this.out(headerLine);
        }
        try {
            barrier.await();
        }
        catch (Exception e) {
            // empty catch block
        }
        long overallStartTime = System.nanoTime();
        long nextIntervalStartTime = System.currentTimeMillis() + intervalMillis;
        boolean setOverallStartTime = false;
        long lastDuration = 0L;
        long lastNumErrors = 0L;
        long lastNumAuths = 0L;
        long lastEndTime = System.nanoTime();
        for (long i = 0L; i < totalIntervals; ++i) {
            long totalDuration;
            long numErrors;
            long numAuths;
            long startTimeMillis = System.currentTimeMillis();
            long sleepTimeMillis = nextIntervalStartTime - startTimeMillis;
            nextIntervalStartTime += intervalMillis;
            try {
                if (sleepTimeMillis > 0L) {
                    Thread.sleep(sleepTimeMillis);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            long endTime = System.nanoTime();
            long intervalDuration = endTime - lastEndTime;
            if (warmUp && remainingWarmUpIntervals > 0) {
                numAuths = authCounter.getAndSet(0L);
                numErrors = errorCounter.getAndSet(0L);
                totalDuration = authDurations.getAndSet(0L);
            } else {
                numAuths = authCounter.get();
                numErrors = errorCounter.get();
                totalDuration = authDurations.get();
            }
            long recentNumAuths = numAuths - lastNumAuths;
            long recentNumErrors = numErrors - lastNumErrors;
            long recentDuration = totalDuration - lastDuration;
            double numSeconds = (double)intervalDuration / 1.0E9;
            double recentAuthRate = (double)recentNumAuths / numSeconds;
            double recentErrorRate = (double)recentNumErrors / numSeconds;
            double recentAvgDuration = recentNumAuths > 0L ? 1.0 * (double)recentDuration / (double)recentNumAuths / 1000000.0 : 0.0;
            if (warmUp && remainingWarmUpIntervals > 0) {
                this.out(formatter.formatRow(recentAuthRate, recentAvgDuration, recentErrorRate, "warming up", "warming up"));
                if (--remainingWarmUpIntervals == 0) {
                    this.out("Warm-up completed.  Beginning overall statistics collection.");
                    setOverallStartTime = true;
                }
            } else {
                if (setOverallStartTime) {
                    overallStartTime = lastEndTime;
                    setOverallStartTime = false;
                }
                double numOverallSeconds = (double)(endTime - overallStartTime) / 1.0E9;
                double overallAuthRate = (double)numAuths / numOverallSeconds;
                double overallAvgDuration = numAuths > 0L ? 1.0 * (double)totalDuration / (double)numAuths / 1000000.0 : 0.0;
                this.out(formatter.formatRow(recentAuthRate, recentAvgDuration, recentErrorRate, overallAuthRate, overallAvgDuration));
                lastNumAuths = numAuths;
                lastNumErrors = numErrors;
                lastDuration = totalDuration;
            }
            List<ObjectPair<ResultCode, Long>> rcCounts = rcCounter.getCounts(true);
            if (!this.suppressErrorsArgument.isPresent() && !rcCounts.isEmpty()) {
                this.err("\tError Results:");
                for (ObjectPair<ResultCode, Long> p : rcCounts) {
                    this.err("\t", p.getFirst().getName(), ":  ", p.getSecond());
                }
            }
            lastEndTime = endTime;
        }
        ResultCode resultCode = ResultCode.SUCCESS;
        for (AuthRateThread t : threads) {
            ResultCode r = t.stopRunning();
            if (resultCode != ResultCode.SUCCESS) continue;
            resultCode = r;
        }
        return resultCode;
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(1);
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "password", "--baseDN", "dc=example,dc=com", "--scope", "sub", "--filter", "(uid=user.[1-1000000])", "--credentials", "password", "--numThreads", "10"};
        String description = "Test authentication performance by searching randomly across a set of one million users located below 'dc=example,dc=com' with ten concurrent threads and performing simple binds with a password of 'password'.  The searches will be performed anonymously.";
        examples.put(args, "Test authentication performance by searching randomly across a set of one million users located below 'dc=example,dc=com' with ten concurrent threads and performing simple binds with a password of 'password'.  The searches will be performed anonymously.");
        return examples;
    }
}

