/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDIFModifyChangeRecord
extends LDIFChangeRecord {
    public static final String PROPERTY_ALWAYS_INCLUDE_TRAILING_DASH = "com.unboundid.ldif.modify.alwaysIncludeTrailingDash";
    private static boolean alwaysIncludeTrailingDash = true;
    private static final long serialVersionUID = -7558098319600288036L;
    private final Modification[] modifications;

    public LDIFModifyChangeRecord(String dn, Modification ... modifications) {
        this(dn, modifications, (List<Control>)null);
    }

    public LDIFModifyChangeRecord(String dn, Modification[] modifications, List<Control> controls) {
        super(dn, controls);
        Validator.ensureNotNull(modifications);
        Validator.ensureTrue(modifications.length > 0, "LDIFModifyChangeRecord.modifications must not be empty.");
        this.modifications = modifications;
    }

    public LDIFModifyChangeRecord(String dn, List<Modification> modifications) {
        this(dn, modifications, null);
    }

    public LDIFModifyChangeRecord(String dn, List<Modification> modifications, List<Control> controls) {
        super(dn, controls);
        Validator.ensureNotNull(modifications);
        Validator.ensureFalse(modifications.isEmpty(), "LDIFModifyChangeRecord.modifications must not be empty.");
        this.modifications = new Modification[modifications.size()];
        modifications.toArray(this.modifications);
    }

    public LDIFModifyChangeRecord(ModifyRequest modifyRequest) {
        super(modifyRequest.getDN(), modifyRequest.getControlList());
        List<Modification> mods = modifyRequest.getModifications();
        this.modifications = new Modification[mods.size()];
        Iterator<Modification> iterator = mods.iterator();
        for (int i = 0; i < this.modifications.length; ++i) {
            this.modifications[i] = iterator.next();
        }
    }

    public static boolean alwaysIncludeTrailingDash() {
        return alwaysIncludeTrailingDash;
    }

    public static void setAlwaysIncludeTrailingDash(boolean alwaysIncludeTrailingDash) {
        LDIFModifyChangeRecord.alwaysIncludeTrailingDash = alwaysIncludeTrailingDash;
    }

    public Modification[] getModifications() {
        return this.modifications;
    }

    public ModifyRequest toModifyRequest() {
        return this.toModifyRequest(true);
    }

    public ModifyRequest toModifyRequest(boolean includeControls) {
        ModifyRequest modifyRequest = new ModifyRequest(this.getDN(), this.modifications);
        if (includeControls) {
            modifyRequest.setControls(this.getControls());
        }
        return modifyRequest;
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.MODIFY;
    }

    @Override
    public LDAPResult processChange(LDAPInterface connection, boolean includeControls) throws LDAPException {
        return connection.modify(this.toModifyRequest(includeControls));
    }

    @Override
    public String[] toLDIF(int wrapColumn) {
        List<String> ldifLines = new ArrayList<String>(this.modifications.length * 4);
        ldifLines.add(LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN())));
        for (Control c : this.getControls()) {
            ldifLines.add(LDIFWriter.encodeNameAndValue("control", LDIFModifyChangeRecord.encodeControlString(c)));
        }
        ldifLines.add("changetype: modify");
        block7: for (int i = 0; i < this.modifications.length; ++i) {
            String attrName = this.modifications[i].getAttributeName();
            switch (this.modifications[i].getModificationType().intValue()) {
                case 0: {
                    ldifLines.add("add: " + attrName);
                    break;
                }
                case 1: {
                    ldifLines.add("delete: " + attrName);
                    break;
                }
                case 2: {
                    ldifLines.add("replace: " + attrName);
                    break;
                }
                case 3: {
                    ldifLines.add("increment: " + attrName);
                    break;
                }
                default: {
                    continue block7;
                }
            }
            for (ASN1OctetString value : this.modifications[i].getRawValues()) {
                ldifLines.add(LDIFWriter.encodeNameAndValue(attrName, value));
            }
            if (!alwaysIncludeTrailingDash && i >= this.modifications.length - 1) continue;
            ldifLines.add("-");
        }
        if (wrapColumn > 2) {
            ldifLines = LDIFWriter.wrapLines(wrapColumn, ldifLines);
        }
        String[] ldifArray = new String[ldifLines.size()];
        ldifLines.toArray(ldifArray);
        return ldifArray;
    }

    @Override
    public void toLDIF(ByteStringBuffer buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        for (Control c : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFModifyChangeRecord.encodeControlString(c), buffer, wrapColumn);
            buffer.append(StaticUtils.EOL_BYTES);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("modify"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        block7: for (int i = 0; i < this.modifications.length; ++i) {
            String attrName = this.modifications[i].getAttributeName();
            switch (this.modifications[i].getModificationType().intValue()) {
                case 0: {
                    LDIFWriter.encodeNameAndValue("add", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                case 1: {
                    LDIFWriter.encodeNameAndValue("delete", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                case 2: {
                    LDIFWriter.encodeNameAndValue("replace", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                case 3: {
                    LDIFWriter.encodeNameAndValue("increment", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                default: {
                    continue block7;
                }
            }
            for (ASN1OctetString value : this.modifications[i].getRawValues()) {
                LDIFWriter.encodeNameAndValue(attrName, value, buffer, wrapColumn);
                buffer.append(StaticUtils.EOL_BYTES);
            }
            if (!alwaysIncludeTrailingDash && i >= this.modifications.length - 1) continue;
            buffer.append('-');
            buffer.append(StaticUtils.EOL_BYTES);
        }
    }

    @Override
    public void toLDIFString(StringBuilder buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        for (Control c : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFModifyChangeRecord.encodeControlString(c), buffer, wrapColumn);
            buffer.append(StaticUtils.EOL);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("modify"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        block7: for (int i = 0; i < this.modifications.length; ++i) {
            String attrName = this.modifications[i].getAttributeName();
            switch (this.modifications[i].getModificationType().intValue()) {
                case 0: {
                    LDIFWriter.encodeNameAndValue("add", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL);
                    break;
                }
                case 1: {
                    LDIFWriter.encodeNameAndValue("delete", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL);
                    break;
                }
                case 2: {
                    LDIFWriter.encodeNameAndValue("replace", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL);
                    break;
                }
                case 3: {
                    LDIFWriter.encodeNameAndValue("increment", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL);
                    break;
                }
                default: {
                    continue block7;
                }
            }
            for (ASN1OctetString value : this.modifications[i].getRawValues()) {
                LDIFWriter.encodeNameAndValue(attrName, value, buffer, wrapColumn);
                buffer.append(StaticUtils.EOL);
            }
            if (!alwaysIncludeTrailingDash && i >= this.modifications.length - 1) continue;
            buffer.append('-');
            buffer.append(StaticUtils.EOL);
        }
    }

    @Override
    public int hashCode() {
        int hashCode;
        try {
            hashCode = this.getParsedDN().hashCode();
        }
        catch (Exception e) {
            Debug.debugException(e);
            hashCode = StaticUtils.toLowerCase(this.getDN()).hashCode();
        }
        for (Modification m : this.modifications) {
            hashCode += m.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        LDIFModifyChangeRecord r;
        block9: {
            HashSet<Control> c2;
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof LDIFModifyChangeRecord)) {
                return false;
            }
            r = (LDIFModifyChangeRecord)o;
            HashSet<Control> c1 = new HashSet<Control>(this.getControls());
            if (!c1.equals(c2 = new HashSet<Control>(r.getControls()))) {
                return false;
            }
            try {
                if (!this.getParsedDN().equals(r.getParsedDN())) {
                    return false;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (StaticUtils.toLowerCase(this.getDN()).equals(StaticUtils.toLowerCase(r.getDN()))) break block9;
                return false;
            }
        }
        if (this.modifications.length != r.modifications.length) {
            return false;
        }
        for (int i = 0; i < this.modifications.length; ++i) {
            if (this.modifications[i].equals(r.modifications[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDIFModifyChangeRecord(dn='");
        buffer.append(this.getDN());
        buffer.append("', mods={");
        for (int i = 0; i < this.modifications.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.modifications[i].toString(buffer);
        }
        buffer.append('}');
        List<Control> controls = this.getControls();
        if (!controls.isEmpty()) {
            buffer.append(", controls={");
            Iterator<Control> iterator = controls.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(buffer);
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    static {
        String propValue = System.getProperty(PROPERTY_ALWAYS_INCLUDE_TRAILING_DASH);
        if (propValue != null && propValue.equalsIgnoreCase("false")) {
            alwaysIncludeTrailingDash = false;
        }
    }
}

