/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SSLUtil {
    public static final String PROPERTY_DEFAULT_SSL_PROTOCOL = "com.unboundid.util.SSLUtil.defaultSSLProtocol";
    public static final String PROPERTY_ENABLED_SSL_PROTOCOLS = "com.unboundid.util.SSLUtil.enabledSSLProtocols";
    private static final AtomicReference<String> DEFAULT_SSL_PROTOCOL = new AtomicReference<String>("TLSv1");
    private static final AtomicReference<Set<String>> ENABLED_SSL_PROTOCOLS = new AtomicReference();
    private static final AtomicReference<Set<String>> LOWER_ENABLED_SSL_PROTOCOLS = new AtomicReference();
    private final KeyManager[] keyManagers;
    private final TrustManager[] trustManagers;

    public SSLUtil() {
        this.keyManagers = null;
        this.trustManagers = null;
    }

    public SSLUtil(TrustManager trustManager) {
        this.keyManagers = null;
        this.trustManagers = trustManager == null ? null : new TrustManager[]{trustManager};
    }

    public SSLUtil(TrustManager[] trustManagers) {
        this.keyManagers = null;
        this.trustManagers = trustManagers == null || trustManagers.length == 0 ? null : trustManagers;
    }

    public SSLUtil(KeyManager keyManager, TrustManager trustManager) {
        this.keyManagers = keyManager == null ? null : new KeyManager[]{keyManager};
        this.trustManagers = trustManager == null ? null : new TrustManager[]{trustManager};
    }

    public SSLUtil(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        this.keyManagers = keyManagers == null || keyManagers.length == 0 ? null : keyManagers;
        this.trustManagers = trustManagers == null || trustManagers.length == 0 ? null : trustManagers;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public SSLContext createSSLContext() throws GeneralSecurityException {
        return this.createSSLContext(DEFAULT_SSL_PROTOCOL.get());
    }

    public SSLContext createSSLContext(String protocol) throws GeneralSecurityException {
        Validator.ensureNotNull(protocol);
        SSLContext sslContext = SSLContext.getInstance(protocol);
        sslContext.init(this.keyManagers, this.trustManagers, null);
        return sslContext;
    }

    public SSLContext createSSLContext(String protocol, String provider) throws GeneralSecurityException {
        Validator.ensureNotNull(protocol, provider);
        SSLContext sslContext = SSLContext.getInstance(protocol, provider);
        sslContext.init(this.keyManagers, this.trustManagers, null);
        return sslContext;
    }

    public SSLSocketFactory createSSLSocketFactory() throws GeneralSecurityException {
        return this.createSSLContext().getSocketFactory();
    }

    public SSLSocketFactory createSSLSocketFactory(String protocol) throws GeneralSecurityException {
        return this.createSSLContext(protocol).getSocketFactory();
    }

    public SSLSocketFactory createSSLSocketFactory(String protocol, String provider) throws GeneralSecurityException {
        return this.createSSLContext(protocol, provider).getSocketFactory();
    }

    public SSLServerSocketFactory createSSLServerSocketFactory() throws GeneralSecurityException {
        return this.createSSLContext().getServerSocketFactory();
    }

    public SSLServerSocketFactory createSSLServerSocketFactory(String protocol) throws GeneralSecurityException {
        return this.createSSLContext(protocol).getServerSocketFactory();
    }

    public SSLServerSocketFactory createSSLServerSocketFactory(String protocol, String provider) throws GeneralSecurityException {
        return this.createSSLContext(protocol, provider).getServerSocketFactory();
    }

    public static String getDefaultSSLProtocol() {
        return DEFAULT_SSL_PROTOCOL.get();
    }

    public static void setDefaultSSLProtocol(String defaultSSLProtocol) {
        Validator.ensureNotNull(defaultSSLProtocol);
        DEFAULT_SSL_PROTOCOL.set(defaultSSLProtocol);
    }

    public static Set<String> getEnabledSSLProtocols() {
        return ENABLED_SSL_PROTOCOLS.get();
    }

    public static void setEnabledSSLProtocols(Collection<String> enabledSSLProtocols) {
        if (enabledSSLProtocols == null) {
            ENABLED_SSL_PROTOCOLS.set(Collections.emptySet());
            LOWER_ENABLED_SSL_PROTOCOLS.set(Collections.emptySet());
        } else {
            HashSet<String> lowerProtocols = new HashSet<String>(enabledSSLProtocols.size());
            for (String s : enabledSSLProtocols) {
                lowerProtocols.add(StaticUtils.toLowerCase(s));
            }
            ENABLED_SSL_PROTOCOLS.set(Collections.unmodifiableSet(new HashSet<String>(enabledSSLProtocols)));
            LOWER_ENABLED_SSL_PROTOCOLS.set(Collections.unmodifiableSet(new HashSet(lowerProtocols)));
        }
    }

    public static void applyEnabledSSLProtocols(Socket socket) throws LDAPException {
        if (socket == null || !(socket instanceof SSLSocket)) {
            return;
        }
        Set<String> lowerEnabledProtocols = LOWER_ENABLED_SSL_PROTOCOLS.get();
        if (lowerEnabledProtocols.isEmpty()) {
            return;
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        String[] supportedProtocols = sslSocket.getSupportedProtocols();
        ArrayList<String> enabledList = new ArrayList<String>(supportedProtocols.length);
        for (String supportedProtocol : supportedProtocols) {
            if (!lowerEnabledProtocols.contains(StaticUtils.toLowerCase(supportedProtocol))) continue;
            enabledList.add(supportedProtocol);
        }
        if (enabledList.isEmpty()) {
            StringBuilder enabledBuffer = new StringBuilder();
            Iterator<String> enabledIterator = ENABLED_SSL_PROTOCOLS.get().iterator();
            while (enabledIterator.hasNext()) {
                enabledBuffer.append('\'');
                enabledBuffer.append(enabledIterator.next());
                enabledBuffer.append('\'');
                if (!enabledIterator.hasNext()) continue;
                enabledBuffer.append(", ");
            }
            StringBuilder supportedBuffer = new StringBuilder();
            for (int i = 0; i < supportedProtocols.length; ++i) {
                if (i > 0) {
                    supportedBuffer.append(", ");
                }
                supportedBuffer.append('\'');
                supportedBuffer.append(supportedProtocols[i]);
                supportedBuffer.append('\'');
            }
            throw new LDAPException(ResultCode.CONNECT_ERROR, SSLMessages.ERR_NO_ENABLED_SSL_PROTOCOLS_AVAILABLE_FOR_SOCKET.get(enabledBuffer.toString(), supportedBuffer.toString(), PROPERTY_ENABLED_SSL_PROTOCOLS, SSLUtil.class.getName() + ".setEnabledSSLProtocols"));
        }
        String[] enabledArray = new String[enabledList.size()];
        sslSocket.setEnabledProtocols(enabledList.toArray(enabledArray));
    }

    static void configureSSLDefaults() {
        String defaultPropValue = System.getProperty(PROPERTY_DEFAULT_SSL_PROTOCOL);
        if (defaultPropValue != null && defaultPropValue.length() > 0) {
            DEFAULT_SSL_PROTOCOL.set(defaultPropValue);
        } else {
            try {
                Method getDefaultMethod = SSLContext.class.getMethod("getDefault", new Class[0]);
                SSLContext defaultContext = (SSLContext)getDefaultMethod.invoke(null, new Object[0]);
                Method getSupportedParamsMethod = SSLContext.class.getMethod("getSupportedSSLParameters", new Class[0]);
                Object paramsObj = getSupportedParamsMethod.invoke((Object)defaultContext, new Object[0]);
                Class<?> sslParamsClass = Class.forName("javax.net.ssl.SSLParameters");
                Method getProtocolsMethod = sslParamsClass.getMethod("getProtocols", new Class[0]);
                String[] supportedProtocols = (String[])getProtocolsMethod.invoke(paramsObj, new Object[0]);
                HashSet<String> protocolMap = new HashSet<String>(Arrays.asList(supportedProtocols));
                if (protocolMap.contains("TLSv1.2")) {
                    DEFAULT_SSL_PROTOCOL.set("TLSv1.2");
                } else if (protocolMap.contains("TLSv1.1")) {
                    DEFAULT_SSL_PROTOCOL.set("TLSv1.1");
                } else if (protocolMap.contains("TLSv1")) {
                    DEFAULT_SSL_PROTOCOL.set("TLSv1");
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        HashSet<String> enabledProtocols = new HashSet<String>(10);
        enabledProtocols.add("TLSv1");
        if (DEFAULT_SSL_PROTOCOL.get().equals("TLSv1.2")) {
            enabledProtocols.add("TLSv1.1");
            enabledProtocols.add("TLSv1.2");
        } else if (DEFAULT_SSL_PROTOCOL.get().equals("TLSv1.1")) {
            enabledProtocols.add("TLSv1.1");
        }
        String enabledPropValue = System.getProperty(PROPERTY_ENABLED_SSL_PROTOCOLS);
        if (enabledPropValue != null && enabledPropValue.length() > 0) {
            enabledProtocols.clear();
            StringTokenizer tokenizer = new StringTokenizer(enabledPropValue, ", ", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.length() <= 0) continue;
                enabledProtocols.add(token);
            }
        }
        HashSet<String> lowerEnabledProtocols = new HashSet<String>(enabledProtocols.size());
        for (String s : enabledProtocols) {
            lowerEnabledProtocols.add(StaticUtils.toLowerCase(s));
        }
        ENABLED_SSL_PROTOCOLS.set(Collections.unmodifiableSet(enabledProtocols));
        LOWER_ENABLED_SSL_PROTOCOLS.set(Collections.unmodifiableSet(lowerEnabledProtocols));
    }

    static {
        SSLUtil.configureSSLDefaults();
    }
}

