/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ControlArgument
extends Argument {
    private static final long serialVersionUID = -1889200072476038957L;
    private final List<ArgumentValueValidator> validators;
    private final List<Control> defaultValues;
    private final List<Control> values;

    public ControlArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, (List<Control>)null);
    }

    public ControlArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, Control defaultValue) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, defaultValue == null ? null : Collections.singletonList(defaultValue));
    }

    public ControlArgument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description, List<Control> defaultValues) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder == null ? "{oid}[:{criticality}[:{stringValue}|::{base64Value}]]" : valuePlaceholder, description);
        this.defaultValues = defaultValues == null || defaultValues.isEmpty() ? null : Collections.unmodifiableList(defaultValues);
        this.values = new ArrayList<Control>(5);
        this.validators = new ArrayList<ArgumentValueValidator>(5);
    }

    private ControlArgument(ControlArgument source) {
        super(source);
        this.defaultValues = source.defaultValues;
        this.validators = new ArrayList<ArgumentValueValidator>(source.validators);
        this.values = new ArrayList<Control>(5);
    }

    public List<Control> getDefaultValues() {
        return this.defaultValues;
    }

    public void addValueValidator(ArgumentValueValidator validator) {
        this.validators.add(validator);
    }

    @Override
    protected void addValue(String valueString) throws ArgumentException {
        String oid;
        boolean isCritical = false;
        ASN1OctetString value = null;
        int firstColonPos = valueString.indexOf(58);
        if (firstColonPos < 0) {
            oid = valueString;
        } else {
            String criticalityStr;
            oid = valueString.substring(0, firstColonPos);
            int secondColonPos = valueString.indexOf(58, firstColonPos + 1);
            if (secondColonPos < 0) {
                criticalityStr = valueString.substring(firstColonPos + 1);
            } else {
                criticalityStr = valueString.substring(firstColonPos + 1, secondColonPos);
                int doubleColonPos = valueString.indexOf("::");
                if (doubleColonPos == secondColonPos) {
                    try {
                        value = new ASN1OctetString(Base64.decode(valueString.substring(doubleColonPos + 2)));
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new ArgumentException(ArgsMessages.ERR_CONTROL_ARG_INVALID_BASE64_VALUE.get(valueString, this.getIdentifierString(), valueString.substring(doubleColonPos + 2)), e);
                    }
                } else {
                    value = new ASN1OctetString(valueString.substring(secondColonPos + 1));
                }
            }
            String lowerCriticalityStr = StaticUtils.toLowerCase(criticalityStr);
            if (lowerCriticalityStr.equals("true") || lowerCriticalityStr.equals("t") || lowerCriticalityStr.equals("yes") || lowerCriticalityStr.equals("y") || lowerCriticalityStr.equals("on") || lowerCriticalityStr.equals("1")) {
                isCritical = true;
            } else if (lowerCriticalityStr.equals("false") || lowerCriticalityStr.equals("f") || lowerCriticalityStr.equals("no") || lowerCriticalityStr.equals("n") || lowerCriticalityStr.equals("off") || lowerCriticalityStr.equals("0")) {
                isCritical = false;
            } else {
                throw new ArgumentException(ArgsMessages.ERR_CONTROL_ARG_INVALID_CRITICALITY.get(valueString, this.getIdentifierString(), criticalityStr));
            }
        }
        if (!StaticUtils.isNumericOID(oid)) {
            throw new ArgumentException(ArgsMessages.ERR_CONTROL_ARG_INVALID_OID.get(valueString, this.getIdentifierString(), oid));
        }
        if (this.values.size() >= this.getMaxOccurrences()) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        for (ArgumentValueValidator v : this.validators) {
            v.validateArgumentValue(this, valueString);
        }
        this.values.add(new Control(oid, isCritical, value));
    }

    public Control getValue() {
        if (this.values.isEmpty()) {
            if (this.defaultValues == null || this.defaultValues.isEmpty()) {
                return null;
            }
            return this.defaultValues.get(0);
        }
        return this.values.get(0);
    }

    public List<Control> getValues() {
        if (this.values.isEmpty() && this.defaultValues != null) {
            return this.defaultValues;
        }
        return Collections.unmodifiableList(this.values);
    }

    @Override
    protected boolean hasDefaultValue() {
        return this.defaultValues != null && !this.defaultValues.isEmpty();
    }

    @Override
    public String getDataTypeName() {
        return ArgsMessages.INFO_CONTROL_TYPE_NAME.get();
    }

    @Override
    public String getValueConstraints() {
        return ArgsMessages.INFO_CONTROL_CONSTRAINTS.get();
    }

    @Override
    public ControlArgument getCleanCopy() {
        return new ControlArgument(this);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ControlArgument(");
        this.appendBasicToStringInfo(buffer);
        if (this.defaultValues != null && !this.defaultValues.isEmpty()) {
            if (this.defaultValues.size() == 1) {
                buffer.append(", defaultValue='");
                buffer.append(this.defaultValues.get(0).toString());
            } else {
                buffer.append(", defaultValues={");
                Iterator<Control> iterator = this.defaultValues.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(iterator.next().toString());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
            }
        }
        buffer.append(')');
    }
}

