/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.CRAMMD5BindRequest;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequest;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.examples.AuthRate;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.ValuePattern;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class AuthRateThread
extends Thread {
    private static final int AUTH_TYPE_SIMPLE = 0;
    private static final int AUTH_TYPE_CRAM_MD5 = 1;
    private static final int AUTH_TYPE_DIGEST_MD5 = 2;
    private static final int AUTH_TYPE_PLAIN = 3;
    private final AtomicBoolean stopRequested;
    private final AtomicLong authCounter;
    private final AtomicLong authDurations;
    private final AtomicLong errorCounter;
    private final AtomicReference<ResultCode> resultCode;
    private final AtomicReference<Thread> authThread;
    private final AuthRate authRate;
    private final CyclicBarrier startBarrier;
    private final int authType;
    private LDAPConnection bindConnection;
    private LDAPConnection searchConnection;
    private final ResultCodeCounter rcCounter;
    private final SearchRequest searchRequest;
    private final String userPassword;
    private final ValuePattern baseDN;
    private final ValuePattern filter;
    private final FixedRateBarrier fixedRateBarrier;

    AuthRateThread(AuthRate authRate, int threadNumber, LDAPConnection searchConnection, LDAPConnection bindConnection, ValuePattern baseDN, SearchScope scope, ValuePattern filter, String[] attributes, String userPassword, String authType, CyclicBarrier startBarrier, AtomicLong authCounter, AtomicLong authDurations, AtomicLong errorCounter, ResultCodeCounter rcCounter, FixedRateBarrier rateBarrier) {
        this.setName("AuthRate Thread " + threadNumber);
        this.setDaemon(true);
        this.authRate = authRate;
        this.searchConnection = searchConnection;
        this.bindConnection = bindConnection;
        this.baseDN = baseDN;
        this.filter = filter;
        this.userPassword = userPassword;
        this.authCounter = authCounter;
        this.authDurations = authDurations;
        this.errorCounter = errorCounter;
        this.rcCounter = rcCounter;
        this.startBarrier = startBarrier;
        this.fixedRateBarrier = rateBarrier;
        searchConnection.setConnectionName("search-" + threadNumber);
        bindConnection.setConnectionName("bind-" + threadNumber);
        this.authType = authType.equalsIgnoreCase("cram-md5") ? 1 : (authType.equalsIgnoreCase("digest-md5") ? 2 : (authType.equalsIgnoreCase("plain") ? 3 : 0));
        this.resultCode = new AtomicReference<Object>(null);
        this.authThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
        this.searchRequest = new SearchRequest("", scope, Filter.createPresenceFilter("objectClass"), attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.authThread.set(AuthRateThread.currentThread());
        try {
            this.startBarrier.await();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        while (!this.stopRequested.get()) {
            Object var7_11;
            long startTime;
            block31: {
                block30: {
                    block29: {
                        ResultCode rc;
                        if (this.searchConnection == null) {
                            try {
                                this.searchConnection = this.authRate.getConnection();
                            }
                            catch (LDAPException le) {
                                Debug.debugException(le);
                                this.errorCounter.incrementAndGet();
                                rc = le.getResultCode();
                                this.rcCounter.increment(rc);
                                this.resultCode.compareAndSet(null, rc);
                                if (this.fixedRateBarrier == null) continue;
                                this.fixedRateBarrier.await();
                                continue;
                            }
                        }
                        if (this.bindConnection == null) {
                            try {
                                this.bindConnection = this.authRate.getConnection();
                            }
                            catch (LDAPException le) {
                                Debug.debugException(le);
                                this.errorCounter.incrementAndGet();
                                rc = le.getResultCode();
                                this.rcCounter.increment(rc);
                                this.resultCode.compareAndSet(null, rc);
                                if (this.fixedRateBarrier == null) continue;
                                this.fixedRateBarrier.await();
                                continue;
                            }
                        }
                        try {
                            this.searchRequest.setBaseDN(this.baseDN.nextValue());
                            this.searchRequest.setFilter(this.filter.nextValue());
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            this.errorCounter.incrementAndGet();
                            rc = le.getResultCode();
                            this.rcCounter.increment(rc);
                            this.resultCode.compareAndSet(null, rc);
                            continue;
                        }
                        if (this.fixedRateBarrier != null) {
                            this.fixedRateBarrier.await();
                        }
                        startTime = System.nanoTime();
                        try {
                            try {
                                SearchResult r = this.searchConnection.search(this.searchRequest);
                                switch (r.getEntryCount()) {
                                    case 0: {
                                        this.errorCounter.incrementAndGet();
                                        this.rcCounter.increment(ResultCode.NO_RESULTS_RETURNED);
                                        this.resultCode.compareAndSet(null, ResultCode.NO_RESULTS_RETURNED);
                                        var7_11 = null;
                                        this.authCounter.incrementAndGet();
                                        break block29;
                                    }
                                    case 1: {
                                        break;
                                    }
                                    default: {
                                        this.errorCounter.incrementAndGet();
                                        this.rcCounter.increment(ResultCode.MORE_RESULTS_TO_RETURN);
                                        this.resultCode.compareAndSet(null, ResultCode.MORE_RESULTS_TO_RETURN);
                                        break block30;
                                    }
                                }
                                BindRequest bindRequest = null;
                                String dn = r.getSearchEntries().get(0).getDN();
                                switch (this.authType) {
                                    case 0: {
                                        bindRequest = new SimpleBindRequest(dn, this.userPassword);
                                        break;
                                    }
                                    case 1: {
                                        bindRequest = new CRAMMD5BindRequest("dn:" + dn, this.userPassword);
                                        break;
                                    }
                                    case 2: {
                                        bindRequest = new DIGESTMD5BindRequest("dn:" + dn, this.userPassword);
                                        break;
                                    }
                                    case 3: {
                                        bindRequest = new PLAINBindRequest("dn:" + dn, this.userPassword);
                                        break;
                                    }
                                }
                                this.bindConnection.bind(bindRequest);
                                break block31;
                            }
                            catch (LDAPException le) {
                                Debug.debugException(le);
                                this.errorCounter.incrementAndGet();
                                ResultCode rc2 = le.getResultCode();
                                this.rcCounter.increment(rc2);
                                this.resultCode.compareAndSet(null, rc2);
                                if (!le.getResultCode().isConnectionUsable()) {
                                    this.searchConnection.close();
                                    this.searchConnection = null;
                                    this.bindConnection.close();
                                    this.bindConnection = null;
                                }
                                var7_11 = null;
                                this.authCounter.incrementAndGet();
                                this.authDurations.addAndGet(System.nanoTime() - startTime);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            var7_11 = null;
                            this.authCounter.incrementAndGet();
                            this.authDurations.addAndGet(System.nanoTime() - startTime);
                            throw throwable;
                        }
                    }
                    this.authDurations.addAndGet(System.nanoTime() - startTime);
                    continue;
                }
                var7_11 = null;
                this.authCounter.incrementAndGet();
                this.authDurations.addAndGet(System.nanoTime() - startTime);
                continue;
            }
            var7_11 = null;
            this.authCounter.incrementAndGet();
            this.authDurations.addAndGet(System.nanoTime() - startTime);
        }
        if (this.searchConnection != null) {
            this.searchConnection.close();
        }
        if (this.bindConnection != null) {
            this.bindConnection.close();
        }
        this.authThread.set(null);
    }

    public ResultCode stopRunning() {
        Thread t;
        this.stopRequested.set(true);
        if (this.fixedRateBarrier != null) {
            this.fixedRateBarrier.shutdownRequested();
        }
        if ((t = this.authThread.get()) != null) {
            try {
                t.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }
}

