/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class StreamDirectoryValuesExtendedRequest
extends ExtendedRequest {
    public static final String STREAM_DIRECTORY_VALUES_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.6";
    private static final byte TYPE_BASE_DN = -128;
    private static final byte TYPE_INCLUDE_DNS = -95;
    private static final byte TYPE_ATTRIBUTES = -94;
    private static final byte TYPE_VALUES_PER_RESPONSE = -125;
    private static final byte TYPE_SCOPE = -128;
    private static final byte TYPE_RELATIVE = -127;
    private static final long serialVersionUID = -6365315263363449596L;
    private final boolean returnRelativeDNs;
    private final int valuesPerResponse;
    private final List<String> attributes;
    private final SearchScope dnScope;
    private final String baseDN;

    public StreamDirectoryValuesExtendedRequest(String baseDN, SearchScope dnScope, boolean returnRelativeDNs, List<String> attributes, int valuesPerResponse, Control ... controls) {
        super(STREAM_DIRECTORY_VALUES_REQUEST_OID, StreamDirectoryValuesExtendedRequest.encodeValue(baseDN, dnScope, returnRelativeDNs, attributes, valuesPerResponse), controls);
        this.baseDN = baseDN;
        this.dnScope = dnScope;
        this.returnRelativeDNs = returnRelativeDNs;
        this.attributes = attributes == null ? Collections.emptyList() : Collections.unmodifiableList(attributes);
        this.valuesPerResponse = valuesPerResponse < 0 ? 0 : valuesPerResponse;
    }

    public StreamDirectoryValuesExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STREAM_DIRECTORY_VALUES_REQUEST_NO_VALUE.get());
        }
        boolean tmpRelative = true;
        int tmpNumValues = 0;
        ArrayList<String> tmpAttrs = new ArrayList<String>(10);
        SearchScope tmpScope = null;
        String tmpBaseDN = null;
        try {
            ASN1Element[] svElements;
            block13: for (ASN1Element svElement : svElements = ASN1Element.decode(value.getValue()).decodeAsSequence().elements()) {
                switch (svElement.getType()) {
                    case -128: {
                        tmpBaseDN = svElement.decodeAsOctetString().stringValue();
                        continue block13;
                    }
                    case -95: {
                        ASN1Element[] idElements;
                        block14: for (ASN1Element idElement : idElements = svElement.decodeAsSequence().elements()) {
                            switch (idElement.getType()) {
                                case -128: {
                                    int scopeValue = idElement.decodeAsEnumerated().intValue();
                                    tmpScope = SearchScope.definedValueOf(scopeValue);
                                    if (tmpScope != null) continue block14;
                                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STREAM_DIRECTORY_VALUES_REQUEST_INVALID_SCOPE.get(scopeValue));
                                }
                                case -127: {
                                    tmpRelative = idElement.decodeAsBoolean().booleanValue();
                                    continue block14;
                                }
                                default: {
                                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STREAM_DIRECTORY_VALUES_REQUEST_INVALID_INCLUDE_DNS_TYPE.get(StaticUtils.toHex(idElement.getType())));
                                }
                            }
                        }
                        continue block13;
                    }
                    case -94: {
                        ASN1Element[] attrElements;
                        for (ASN1Element attrElement : attrElements = svElement.decodeAsSequence().elements()) {
                            tmpAttrs.add(attrElement.decodeAsOctetString().stringValue());
                        }
                        continue block13;
                    }
                    case -125: {
                        tmpNumValues = svElement.decodeAsInteger().intValue();
                        if (tmpNumValues >= 0) continue block13;
                        tmpNumValues = 0;
                        continue block13;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STREAM_DIRECTORY_VALUES_REQUEST_INVALID_SEQUENCE_TYPE.get(StaticUtils.toHex(svElement.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STREAM_DIRECTORY_VALUES_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (tmpBaseDN == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STREAM_DIRECTORY_VALUES_REQUEST_NO_BASE_DN.get());
        }
        this.baseDN = tmpBaseDN;
        this.dnScope = tmpScope;
        this.returnRelativeDNs = tmpRelative;
        this.attributes = Collections.unmodifiableList(tmpAttrs);
        this.valuesPerResponse = tmpNumValues;
    }

    private static ASN1OctetString encodeValue(String baseDN, SearchScope scope, boolean relativeDNs, List<String> attributes, int valuesPerResponse) {
        Validator.ensureNotNull(baseDN);
        ArrayList<ASN1Element> svElements = new ArrayList<ASN1Element>(4);
        svElements.add(new ASN1OctetString(-128, baseDN));
        if (scope != null) {
            ArrayList<ASN1Element> idElements = new ArrayList<ASN1Element>(2);
            idElements.add(new ASN1Enumerated(-128, scope.intValue()));
            if (!relativeDNs) {
                idElements.add(new ASN1Boolean(-127, relativeDNs));
            }
            svElements.add(new ASN1Sequence(-95, idElements));
        }
        if (attributes != null && !attributes.isEmpty()) {
            ArrayList<ASN1OctetString> attrElements = new ArrayList<ASN1OctetString>(attributes.size());
            for (String s : attributes) {
                attrElements.add(new ASN1OctetString(s));
            }
            svElements.add(new ASN1Sequence(-94, attrElements));
        }
        if (valuesPerResponse > 0) {
            svElements.add(new ASN1Integer(-125, valuesPerResponse));
        }
        return new ASN1OctetString(new ASN1Sequence(svElements).encode());
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public SearchScope getDNScope() {
        return this.dnScope;
    }

    public boolean returnRelativeDNs() {
        return this.returnRelativeDNs;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public int getValuesPerResponse() {
        return this.valuesPerResponse;
    }

    @Override
    public StreamDirectoryValuesExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public StreamDirectoryValuesExtendedRequest duplicate(Control[] controls) {
        StreamDirectoryValuesExtendedRequest r = new StreamDirectoryValuesExtendedRequest(this.baseDN, this.dnScope, this.returnRelativeDNs, this.attributes, this.valuesPerResponse, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_STREAM_DIRECTORY_VALUES.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] controls;
        buffer.append("StreamDirectoryValuesExtendedRequest(baseDN='");
        buffer.append(this.baseDN);
        buffer.append('\'');
        if (this.dnScope != null) {
            buffer.append(", scope='");
            buffer.append(this.dnScope.getName());
            buffer.append("', returnRelativeDNs=");
            buffer.append(this.returnRelativeDNs);
        }
        buffer.append(", attributes={");
        if (!this.attributes.isEmpty()) {
            Iterator<String> iterator = this.attributes.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
        }
        buffer.append('}');
        if (this.valuesPerResponse > 0) {
            buffer.append(", valuesPerResponse=");
            buffer.append(this.valuesPerResponse);
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

