/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.LDAPSDKException;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class LDAPException
extends LDAPSDKException {
    private static final long serialVersionUID = -4257171063946350327L;
    protected static final Control[] NO_CONTROLS = StaticUtils.NO_CONTROLS;
    protected static final String[] NO_REFERRALS = StaticUtils.NO_STRINGS;
    private final Control[] responseControls;
    private final ResultCode resultCode;
    private final String[] referralURLs;
    private final String diagnosticMessage;
    private final String matchedDN;

    public LDAPException(ResultCode resultCode) {
        super(resultCode.getName());
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, Throwable cause) {
        super(resultCode.getName(), cause);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, String errorMessage) {
        super(errorMessage);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, String errorMessage, String matchedDN, String[] referralURLs) {
        super(errorMessage);
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs == null ? NO_REFERRALS : referralURLs;
        this.diagnosticMessage = null;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, String errorMessage, String matchedDN, String[] referralURLs, Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs == null ? NO_REFERRALS : referralURLs;
        this.diagnosticMessage = null;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, String errorMessage, String matchedDN, String[] referralURLs, Control[] controls) {
        super(errorMessage);
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.diagnosticMessage = null;
        this.referralURLs = referralURLs == null ? NO_REFERRALS : referralURLs;
        this.responseControls = controls == null ? NO_CONTROLS : controls;
    }

    public LDAPException(ResultCode resultCode, String errorMessage, String matchedDN, String[] referralURLs, Control[] controls, Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.diagnosticMessage = null;
        this.referralURLs = referralURLs == null ? NO_REFERRALS : referralURLs;
        this.responseControls = controls == null ? NO_CONTROLS : controls;
    }

    public LDAPException(LDAPResult ldapResult) {
        super(ldapResult.getDiagnosticMessage() == null ? ldapResult.getResultCode().getName() : ldapResult.getDiagnosticMessage());
        this.resultCode = ldapResult.getResultCode();
        this.matchedDN = ldapResult.getMatchedDN();
        this.diagnosticMessage = ldapResult.getDiagnosticMessage();
        this.referralURLs = ldapResult.getReferralURLs();
        this.responseControls = ldapResult.getResponseControls();
    }

    public LDAPException(LDAPResult ldapResult, Throwable cause) {
        super(ldapResult.getDiagnosticMessage() == null ? ldapResult.getResultCode().getName() : ldapResult.getDiagnosticMessage(), cause);
        this.resultCode = ldapResult.getResultCode();
        this.matchedDN = ldapResult.getMatchedDN();
        this.diagnosticMessage = ldapResult.getDiagnosticMessage();
        this.referralURLs = ldapResult.getReferralURLs();
        this.responseControls = ldapResult.getResponseControls();
    }

    public LDAPException(LDAPException e) {
        super(e.getMessage(), e.getCause());
        this.resultCode = e.getResultCode();
        this.matchedDN = e.getMatchedDN();
        this.diagnosticMessage = e.getDiagnosticMessage();
        this.referralURLs = e.getReferralURLs();
        this.responseControls = e.getResponseControls();
    }

    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    public final String getMatchedDN() {
        return this.matchedDN;
    }

    public final String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    public final String[] getReferralURLs() {
        return this.referralURLs;
    }

    public final boolean hasResponseControl() {
        return this.responseControls.length > 0;
    }

    public final boolean hasResponseControl(String oid) {
        for (Control c : this.responseControls) {
            if (!c.getOID().equals(oid)) continue;
            return true;
        }
        return false;
    }

    public final Control[] getResponseControls() {
        return this.responseControls;
    }

    public final Control getResponseControl(String oid) {
        for (Control c : this.responseControls) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        return null;
    }

    public LDAPResult toLDAPResult() {
        if (this.diagnosticMessage == null && this.getMessage() != null) {
            return new LDAPResult(-1, this.resultCode, this.getMessage(), this.matchedDN, this.referralURLs, this.responseControls);
        }
        return new LDAPResult(-1, this.resultCode, this.diagnosticMessage, this.matchedDN, this.referralURLs, this.responseControls);
    }

    public String getResultString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("result code='");
        buffer.append(this.resultCode);
        buffer.append('\'');
        if (this.diagnosticMessage != null && this.diagnosticMessage.length() > 0) {
            buffer.append(" diagnostic message='");
            buffer.append(this.diagnosticMessage);
            buffer.append('\'');
        }
        if (this.matchedDN != null && this.matchedDN.length() > 0) {
            buffer.append("  matched DN='");
            buffer.append(this.matchedDN);
            buffer.append('\'');
        }
        if (this.referralURLs != null && this.referralURLs.length > 0) {
            buffer.append("  referral URLs={");
            for (int i = 0; i < this.referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(this.referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        int i;
        buffer.append("LDAPException(resultCode=");
        buffer.append(this.resultCode);
        String errorMessage = this.getMessage();
        if (errorMessage != null) {
            buffer.append(", errorMessage='");
            buffer.append(errorMessage);
            buffer.append('\'');
        }
        if (this.matchedDN != null) {
            buffer.append(", matchedDN='");
            buffer.append(this.matchedDN);
            buffer.append('\'');
        }
        if (this.diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(this.diagnosticMessage);
            buffer.append('\'');
        }
        if (this.referralURLs.length > 0) {
            buffer.append(", referralURLs={");
            for (i = 0; i < this.referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(this.referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if (this.responseControls.length > 0) {
            buffer.append(", responseControls={");
            for (i = 0; i < this.responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(", ldapSDKVersion=");
        buffer.append("4.0.2");
        buffer.append(", revision='");
        buffer.append("26792");
        buffer.append("')");
    }

    @Override
    public final String getExceptionMessage() {
        return this.toString();
    }
}

