/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum X509CertificateVersion {
    V1(0, "v1"),
    V2(1, "v2"),
    V3(2, "v3");

    private final int intValue;
    private final String name;

    private X509CertificateVersion(int intValue, String name) {
        this.intValue = intValue;
        this.name = name;
    }

    int getIntValue() {
        return this.intValue;
    }

    public String getName() {
        return this.name;
    }

    static X509CertificateVersion valueOf(int intValue) {
        for (X509CertificateVersion v : X509CertificateVersion.values()) {
            if (v.intValue != intValue) continue;
            return v;
        }
        return null;
    }
}

