/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.ldap.sdk.controls.AssertionRequestControl;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityRequestControl;
import com.unboundid.ldap.sdk.controls.ManageDsaITRequestControl;
import com.unboundid.ldap.sdk.controls.MatchedValuesFilter;
import com.unboundid.ldap.sdk.controls.MatchedValuesRequestControl;
import com.unboundid.ldap.sdk.controls.PersistentSearchChangeType;
import com.unboundid.ldap.sdk.controls.PersistentSearchRequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV1RequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.controls.ServerSideSortRequestControl;
import com.unboundid.ldap.sdk.controls.SortKey;
import com.unboundid.ldap.sdk.controls.SubentriesRequestControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewRequestControl;
import com.unboundid.ldap.sdk.persist.PersistUtils;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.ldap.sdk.transformations.ExcludeAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.MoveSubtreeTransformation;
import com.unboundid.ldap.sdk.transformations.RedactAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.RenameAttributeTransformation;
import com.unboundid.ldap.sdk.transformations.ScrambleAttributeTransformation;
import com.unboundid.ldap.sdk.unboundidds.controls.AccountUsableRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.ExcludeBranchRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetAuthorizationEntryRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetBackendSetIDRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetEffectiveRightsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetServerIDRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetUserResourceLimitsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinBaseDN;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinRequestValue;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinRule;
import com.unboundid.ldap.sdk.unboundidds.controls.MatchingEntryCountRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.OperationPurposeRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.OverrideSearchLimitsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PermitUnindexedSearchRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RealAttributesOnlyRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RejectUnindexedSearchRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.ReturnConflictEntriesRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RouteToBackendSetRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RouteToServerRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SoftDeletedEntryAccessRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressOperationalAttributeUpdateRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressType;
import com.unboundid.ldap.sdk.unboundidds.controls.VirtualAttributesOnlyRequestControl;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartAdministrativeSessionExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartAdministrativeSessionPostConnectProcessor;
import com.unboundid.ldap.sdk.unboundidds.tools.ColumnFormatterLDAPSearchOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.JSONLDAPSearchOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearchListener;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearchOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.LDIFLDAPSearchOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.ReportBindResultLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolUtils;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.Debug;
import com.unboundid.util.FilterFileReader;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.PassphraseEncryptedOutputStream;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.TeeOutputStream;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPSearch
extends LDAPCommandLineTool
implements UnsolicitedNotificationHandler {
    private static int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    private BooleanArgument accountUsable = null;
    private BooleanArgument authorizationIdentity = null;
    private BooleanArgument compressOutput = null;
    private BooleanArgument continueOnError = null;
    private BooleanArgument countEntries = null;
    private BooleanArgument dontWrap = null;
    private BooleanArgument dryRun = null;
    private BooleanArgument encryptOutput = null;
    private BooleanArgument followReferrals = null;
    private BooleanArgument hideRedactedValueCount = null;
    private BooleanArgument getBackendSetID = null;
    private BooleanArgument getServerID = null;
    private BooleanArgument getUserResourceLimits = null;
    private BooleanArgument includeReplicationConflictEntries = null;
    private BooleanArgument includeSubentries = null;
    private BooleanArgument joinRequireMatch = null;
    private BooleanArgument manageDsaIT = null;
    private BooleanArgument permitUnindexedSearch = null;
    private BooleanArgument realAttributesOnly = null;
    private BooleanArgument rejectUnindexedSearch = null;
    private BooleanArgument retryFailedOperations = null;
    private BooleanArgument separateOutputFilePerSearch = null;
    private BooleanArgument suppressBase64EncodedValueComments = null;
    private BooleanArgument teeResultsToStandardOut = null;
    private BooleanArgument useAdministrativeSession = null;
    private BooleanArgument usePasswordPolicyControl = null;
    private BooleanArgument terse = null;
    private BooleanArgument typesOnly = null;
    private BooleanArgument verbose = null;
    private BooleanArgument virtualAttributesOnly = null;
    private ControlArgument bindControl = null;
    private ControlArgument searchControl = null;
    private DNArgument baseDN = null;
    private DNArgument excludeBranch = null;
    private DNArgument moveSubtreeFrom = null;
    private DNArgument moveSubtreeTo = null;
    private DNArgument proxyV1As = null;
    private FileArgument encryptionPassphraseFile = null;
    private FileArgument filterFile = null;
    private FileArgument ldapURLFile = null;
    private FileArgument outputFile = null;
    private FilterArgument assertionFilter = null;
    private FilterArgument filter = null;
    private FilterArgument joinFilter = null;
    private FilterArgument matchedValuesFilter = null;
    private IntegerArgument joinSizeLimit = null;
    private IntegerArgument ratePerSecond = null;
    private IntegerArgument scrambleRandomSeed = null;
    private IntegerArgument simplePageSize = null;
    private IntegerArgument sizeLimit = null;
    private IntegerArgument timeLimitSeconds = null;
    private IntegerArgument wrapColumn = null;
    private ScopeArgument joinScope = null;
    private ScopeArgument scope = null;
    private StringArgument dereferencePolicy = null;
    private StringArgument excludeAttribute = null;
    private StringArgument getAuthorizationEntryAttribute = null;
    private StringArgument getEffectiveRightsAttribute = null;
    private StringArgument getEffectiveRightsAuthzID = null;
    private StringArgument includeSoftDeletedEntries = null;
    private StringArgument joinBaseDN = null;
    private StringArgument joinRequestedAttribute = null;
    private StringArgument joinRule = null;
    private StringArgument matchingEntryCountControl = null;
    private StringArgument operationPurpose = null;
    private StringArgument outputFormat = null;
    private StringArgument overrideSearchLimit = null;
    private StringArgument persistentSearch = null;
    private StringArgument proxyAs = null;
    private StringArgument redactAttribute = null;
    private StringArgument renameAttributeFrom = null;
    private StringArgument renameAttributeTo = null;
    private StringArgument requestedAttribute = null;
    private StringArgument routeToBackendSet = null;
    private StringArgument routeToServer = null;
    private StringArgument scrambleAttribute = null;
    private StringArgument scrambleJSONField = null;
    private StringArgument sortOrder = null;
    private StringArgument suppressOperationalAttributeUpdates = null;
    private StringArgument virtualListView = null;
    private volatile ArgumentParser parser = null;
    private volatile JoinRequestControl joinRequestControl = null;
    private final List<RouteToBackendSetRequestControl> routeToBackendSetRequestControls = new ArrayList<RouteToBackendSetRequestControl>(10);
    private volatile MatchedValuesRequestControl matchedValuesRequestControl = null;
    private volatile MatchingEntryCountRequestControl matchingEntryCountRequestControl = null;
    private volatile OverrideSearchLimitsRequestControl overrideSearchLimitsRequestControl = null;
    private volatile PersistentSearchRequestControl persistentSearchRequestControl = null;
    private volatile ServerSideSortRequestControl sortRequestControl = null;
    private volatile VirtualListViewRequestControl vlvRequestControl = null;
    private volatile DereferencePolicy derefPolicy = null;
    private final AtomicLong outputFileCounter = new AtomicLong(1L);
    private volatile PrintStream errStream = null;
    private volatile PrintStream outStream = null;
    private volatile LDAPSearchOutputHandler outputHandler = new LDIFLDAPSearchOutputHandler(this, WRAP_COLUMN);
    private volatile List<EntryTransformation> entryTransformations = null;
    private String encryptionPassphrase = null;

    public static void main(String ... args) {
        ResultCode resultCode = LDAPSearch.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(Math.min(resultCode.intValue(), 255));
        }
    }

    public static ResultCode main(OutputStream out, OutputStream err, String ... args) {
        LDAPSearch tool = new LDAPSearch(out, err);
        return tool.runTool(args);
    }

    public LDAPSearch(OutputStream out, OutputStream err) {
        super(out, err);
    }

    @Override
    public String getToolName() {
        return "ldapsearch";
    }

    @Override
    public String getToolDescription() {
        return ToolMessages.INFO_LDAPSEARCH_TOOL_DESCRIPTION.get();
    }

    @Override
    public List<String> getAdditionalDescriptionParagraphs() {
        return Arrays.asList(ToolMessages.INFO_LDAPSEARCH_ADDITIONAL_DESCRIPTION_PARAGRAPH_1.get(), ToolMessages.INFO_LDAPSEARCH_ADDITIONAL_DESCRIPTION_PARAGRAPH_2.get());
    }

    @Override
    public String getToolVersion() {
        return "5.0.0";
    }

    @Override
    public int getMinTrailingArguments() {
        return 0;
    }

    @Override
    public int getMaxTrailingArguments() {
        return -1;
    }

    @Override
    public String getTrailingArgumentsPlaceholder() {
        return ToolMessages.INFO_LDAPSEARCH_TRAILING_ARGS_PLACEHOLDER.get();
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    protected Set<Character> getSuppressedShortIdentifiers() {
        return Collections.singleton(Character.valueOf('T'));
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        this.baseDN = new DNArgument(Character.valueOf('b'), "baseDN", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_BASE_DN.get());
        this.baseDN.addLongIdentifier("base-dn", true);
        this.baseDN.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.baseDN);
        this.scope = new ScopeArgument(Character.valueOf('s'), "scope", false, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_SCOPE.get(), SearchScope.SUB);
        this.scope.addLongIdentifier("searchScope", true);
        this.scope.addLongIdentifier("search-scope", true);
        this.scope.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.scope);
        this.sizeLimit = new IntegerArgument(Character.valueOf('z'), "sizeLimit", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_SIZE_LIMIT.get(), 0, Integer.MAX_VALUE, 0);
        this.sizeLimit.addLongIdentifier("size-limit", true);
        this.sizeLimit.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.sizeLimit);
        this.timeLimitSeconds = new IntegerArgument(Character.valueOf('l'), "timeLimitSeconds", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_TIME_LIMIT.get(), 0, Integer.MAX_VALUE, 0);
        this.timeLimitSeconds.addLongIdentifier("timeLimit", true);
        this.timeLimitSeconds.addLongIdentifier("time-limit-seconds", true);
        this.timeLimitSeconds.addLongIdentifier("time-limit", true);
        this.timeLimitSeconds.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.timeLimitSeconds);
        Set<String> derefAllowedValues = StaticUtils.setOf("never", "always", "search", "find");
        this.dereferencePolicy = new StringArgument(Character.valueOf('a'), "dereferencePolicy", false, 1, "{never|always|search|find}", ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_DEREFERENCE_POLICY.get(), derefAllowedValues, "never");
        this.dereferencePolicy.addLongIdentifier("dereference-policy", true);
        this.dereferencePolicy.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.dereferencePolicy);
        this.typesOnly = new BooleanArgument(Character.valueOf('A'), "typesOnly", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_TYPES_ONLY.get());
        this.typesOnly.addLongIdentifier("types-only", true);
        this.typesOnly.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.typesOnly);
        this.requestedAttribute = new StringArgument(null, "requestedAttribute", false, 0, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_REQUESTED_ATTR.get());
        this.requestedAttribute.addLongIdentifier("requested-attribute", true);
        this.requestedAttribute.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.requestedAttribute);
        this.filter = new FilterArgument(null, "filter", false, 0, ToolMessages.INFO_PLACEHOLDER_FILTER.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_FILTER.get());
        this.filter.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.filter);
        this.filterFile = new FileArgument(Character.valueOf('f'), "filterFile", false, 0, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_FILTER_FILE.get(), true, true, true, false);
        this.filterFile.addLongIdentifier("filename", true);
        this.filterFile.addLongIdentifier("filter-file", true);
        this.filterFile.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.filterFile);
        this.ldapURLFile = new FileArgument(null, "ldapURLFile", false, 0, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_LDAP_URL_FILE.get(), true, true, true, false);
        this.ldapURLFile.addLongIdentifier("ldap-url-file", true);
        this.ldapURLFile.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.ldapURLFile);
        this.followReferrals = new BooleanArgument(null, "followReferrals", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_FOLLOW_REFERRALS.get());
        this.followReferrals.addLongIdentifier("follow-referrals", true);
        this.followReferrals.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.followReferrals);
        this.retryFailedOperations = new BooleanArgument(null, "retryFailedOperations", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_RETRY_FAILED_OPERATIONS.get());
        this.retryFailedOperations.addLongIdentifier("retry-failed-operations", true);
        this.retryFailedOperations.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.retryFailedOperations);
        this.continueOnError = new BooleanArgument(Character.valueOf('c'), "continueOnError", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_CONTINUE_ON_ERROR.get());
        this.continueOnError.addLongIdentifier("continue-on-error", true);
        this.continueOnError.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.continueOnError);
        this.ratePerSecond = new IntegerArgument(Character.valueOf('r'), "ratePerSecond", false, 1, ToolMessages.INFO_PLACEHOLDER_NUM.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_RATE_PER_SECOND.get(), 1, Integer.MAX_VALUE);
        this.ratePerSecond.addLongIdentifier("rate-per-second", true);
        this.ratePerSecond.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.ratePerSecond);
        this.useAdministrativeSession = new BooleanArgument(null, "useAdministrativeSession", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_USE_ADMIN_SESSION.get());
        this.useAdministrativeSession.addLongIdentifier("use-administrative-session", true);
        this.useAdministrativeSession.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.useAdministrativeSession);
        this.dryRun = new BooleanArgument(Character.valueOf('n'), "dryRun", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_DRY_RUN.get());
        this.dryRun.addLongIdentifier("dry-run", true);
        this.dryRun.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        parser.addArgument(this.dryRun);
        this.wrapColumn = new IntegerArgument(null, "wrapColumn", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_WRAP_COLUMN.get(), 0, Integer.MAX_VALUE);
        this.wrapColumn.addLongIdentifier("wrap-column", true);
        this.wrapColumn.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.wrapColumn);
        this.dontWrap = new BooleanArgument(Character.valueOf('T'), "dontWrap", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_DONT_WRAP.get());
        this.dontWrap.addLongIdentifier("doNotWrap", true);
        this.dontWrap.addLongIdentifier("dont-wrap", true);
        this.dontWrap.addLongIdentifier("do-not-wrap", true);
        this.dontWrap.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.dontWrap);
        this.suppressBase64EncodedValueComments = new BooleanArgument(null, "suppressBase64EncodedValueComments", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_SUPPRESS_BASE64_COMMENTS.get());
        this.suppressBase64EncodedValueComments.addLongIdentifier("suppress-base64-encoded-value-comments", true);
        this.suppressBase64EncodedValueComments.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.suppressBase64EncodedValueComments);
        this.countEntries = new BooleanArgument(null, "countEntries", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_COUNT_ENTRIES.get());
        this.countEntries.addLongIdentifier("count-entries", true);
        this.countEntries.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_OPS.get());
        this.countEntries.setHidden(true);
        parser.addArgument(this.countEntries);
        this.outputFile = new FileArgument(null, "outputFile", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_OUTPUT_FILE.get(), false, true, true, false);
        this.outputFile.addLongIdentifier("output-file", true);
        this.outputFile.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.outputFile);
        this.compressOutput = new BooleanArgument(null, "compressOutput", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_COMPRESS_OUTPUT.get());
        this.compressOutput.addLongIdentifier("compress-output", true);
        this.compressOutput.addLongIdentifier("compress", true);
        this.compressOutput.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.compressOutput);
        this.encryptOutput = new BooleanArgument(null, "encryptOutput", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_ENCRYPT_OUTPUT.get());
        this.encryptOutput.addLongIdentifier("encrypt-output", true);
        this.encryptOutput.addLongIdentifier("encrypt", true);
        this.encryptOutput.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.encryptOutput);
        this.encryptionPassphraseFile = new FileArgument(null, "encryptionPassphraseFile", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_ENCRYPTION_PW_FILE.get(), true, true, true, false);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-passphrase-file", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryptionPasswordFile", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-password-file", true);
        this.encryptionPassphraseFile.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.encryptionPassphraseFile);
        this.separateOutputFilePerSearch = new BooleanArgument(null, "separateOutputFilePerSearch", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_SEPARATE_OUTPUT_FILES.get());
        this.separateOutputFilePerSearch.addLongIdentifier("separate-output-file-per-search", true);
        this.separateOutputFilePerSearch.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.separateOutputFilePerSearch);
        this.teeResultsToStandardOut = new BooleanArgument(null, "teeResultsToStandardOut", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_TEE.get("outputFile"));
        this.teeResultsToStandardOut.addLongIdentifier("tee-results-to-standard-out", true);
        this.teeResultsToStandardOut.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.teeResultsToStandardOut);
        Set<String> outputFormatAllowedValues = StaticUtils.setOf("ldif", "json", "csv", "tab-delimited");
        this.outputFormat = new StringArgument(null, "outputFormat", false, 1, "{ldif|json|csv|tab-delimited}", ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_OUTPUT_FORMAT.get(this.requestedAttribute.getIdentifierString(), this.ldapURLFile.getIdentifierString()), outputFormatAllowedValues, "ldif");
        this.outputFormat.addLongIdentifier("output-format", true);
        this.outputFormat.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.outputFormat);
        this.terse = new BooleanArgument(null, "terse", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_TERSE.get());
        this.terse.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.terse);
        this.verbose = new BooleanArgument(Character.valueOf('v'), "verbose", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_VERBOSE.get());
        this.verbose.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_DATA.get());
        parser.addArgument(this.verbose);
        this.bindControl = new ControlArgument(null, "bindControl", false, 0, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_BIND_CONTROL.get());
        this.bindControl.addLongIdentifier("bind-control", true);
        this.bindControl.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.bindControl);
        this.searchControl = new ControlArgument(Character.valueOf('J'), "control", false, 0, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_SEARCH_CONTROL.get());
        this.searchControl.addLongIdentifier("searchControl", true);
        this.searchControl.addLongIdentifier("search-control", true);
        this.searchControl.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.searchControl);
        this.authorizationIdentity = new BooleanArgument(Character.valueOf('E'), "authorizationIdentity", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_AUTHZ_IDENTITY.get());
        this.authorizationIdentity.addLongIdentifier("reportAuthzID", true);
        this.authorizationIdentity.addLongIdentifier("authorization-identity", true);
        this.authorizationIdentity.addLongIdentifier("report-authzid", true);
        this.authorizationIdentity.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.authorizationIdentity);
        this.assertionFilter = new FilterArgument(null, "assertionFilter", false, 1, ToolMessages.INFO_PLACEHOLDER_FILTER.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_ASSERTION_FILTER.get());
        this.assertionFilter.addLongIdentifier("assertion-filter", true);
        this.assertionFilter.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.assertionFilter);
        this.accountUsable = new BooleanArgument(null, "accountUsable", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_ACCOUNT_USABLE.get());
        this.accountUsable.addLongIdentifier("account-usable", true);
        this.accountUsable.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.accountUsable);
        this.excludeBranch = new DNArgument(null, "excludeBranch", false, 0, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_EXCLUDE_BRANCH.get());
        this.excludeBranch.addLongIdentifier("exclude-branch", true);
        this.excludeBranch.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.excludeBranch);
        this.getAuthorizationEntryAttribute = new StringArgument(null, "getAuthorizationEntryAttribute", false, 0, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_GET_AUTHZ_ENTRY_ATTR.get());
        this.getAuthorizationEntryAttribute.addLongIdentifier("get-authorization-entry-attribute", true);
        this.getAuthorizationEntryAttribute.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.getAuthorizationEntryAttribute);
        this.getBackendSetID = new BooleanArgument(null, "getBackendSetID", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_GET_BACKEND_SET_ID.get());
        this.getBackendSetID.addLongIdentifier("get-backend-set-id", true);
        this.getBackendSetID.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.getBackendSetID);
        this.getEffectiveRightsAuthzID = new StringArgument(Character.valueOf('g'), "getEffectiveRightsAuthzID", false, 1, ToolMessages.INFO_PLACEHOLDER_AUTHZID.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_GET_EFFECTIVE_RIGHTS_AUTHZID.get("getEffectiveRightsAttribute"));
        this.getEffectiveRightsAuthzID.addLongIdentifier("get-effective-rights-authzid", true);
        this.getEffectiveRightsAuthzID.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.getEffectiveRightsAuthzID);
        this.getEffectiveRightsAttribute = new StringArgument(Character.valueOf('e'), "getEffectiveRightsAttribute", false, 0, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_GET_EFFECTIVE_RIGHTS_ATTR.get());
        this.getEffectiveRightsAttribute.addLongIdentifier("get-effective-rights-attribute", true);
        this.getEffectiveRightsAttribute.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.getEffectiveRightsAttribute);
        this.getServerID = new BooleanArgument(null, "getServerID", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_GET_SERVER_ID.get());
        this.getServerID.addLongIdentifier("get-server-id", true);
        this.getServerID.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.getServerID);
        this.getUserResourceLimits = new BooleanArgument(null, "getUserResourceLimits", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_GET_USER_RESOURCE_LIMITS.get());
        this.getUserResourceLimits.addLongIdentifier("get-user-resource-limits", true);
        this.getUserResourceLimits.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.getUserResourceLimits);
        this.includeReplicationConflictEntries = new BooleanArgument(null, "includeReplicationConflictEntries", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_INCLUDE_REPL_CONFLICTS.get());
        this.includeReplicationConflictEntries.addLongIdentifier("include-replication-conflict-entries", true);
        this.includeReplicationConflictEntries.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.includeReplicationConflictEntries);
        Set<String> softDeleteAllowedValues = StaticUtils.setOf("with-non-deleted-entries", "without-non-deleted-entries", "deleted-entries-in-undeleted-form");
        this.includeSoftDeletedEntries = new StringArgument(null, "includeSoftDeletedEntries", false, 1, "{with-non-deleted-entries|without-non-deleted-entries|deleted-entries-in-undeleted-form}", ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_INCLUDE_SOFT_DELETED.get(), softDeleteAllowedValues);
        this.includeSoftDeletedEntries.addLongIdentifier("include-soft-deleted-entries", true);
        this.includeSoftDeletedEntries.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.includeSoftDeletedEntries);
        this.includeSubentries = new BooleanArgument(null, "includeSubentries", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_INCLUDE_SUBENTRIES.get());
        this.includeSubentries.addLongIdentifier("includeLDAPSubentries", true);
        this.includeSubentries.addLongIdentifier("include-subentries", true);
        this.includeSubentries.addLongIdentifier("include-ldap-subentries", true);
        this.includeSubentries.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.includeSubentries);
        this.joinRule = new StringArgument(null, "joinRule", false, 1, "{dn:sourceAttr|reverse-dn:targetAttr|equals:sourceAttr:targetAttr|contains:sourceAttr:targetAttr }", ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_JOIN_RULE.get());
        this.joinRule.addLongIdentifier("join-rule", true);
        this.joinRule.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.joinRule);
        this.joinBaseDN = new StringArgument(null, "joinBaseDN", false, 1, "{search-base|source-entry-dn|{dn}}", ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_JOIN_BASE_DN.get());
        this.joinBaseDN.addLongIdentifier("join-base-dn", true);
        this.joinBaseDN.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.joinBaseDN);
        this.joinScope = new ScopeArgument(null, "joinScope", false, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_JOIN_SCOPE.get());
        this.joinScope.addLongIdentifier("join-scope", true);
        this.joinScope.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.joinScope);
        this.joinSizeLimit = new IntegerArgument(null, "joinSizeLimit", false, 1, ToolMessages.INFO_PLACEHOLDER_NUM.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_JOIN_SIZE_LIMIT.get(), 0, Integer.MAX_VALUE);
        this.joinSizeLimit.addLongIdentifier("join-size-limit", true);
        this.joinSizeLimit.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.joinSizeLimit);
        this.joinFilter = new FilterArgument(null, "joinFilter", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_JOIN_FILTER.get());
        this.joinFilter.addLongIdentifier("join-filter", true);
        this.joinFilter.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.joinFilter);
        this.joinRequestedAttribute = new StringArgument(null, "joinRequestedAttribute", false, 0, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_JOIN_ATTR.get());
        this.joinRequestedAttribute.addLongIdentifier("join-requested-attribute", true);
        this.joinRequestedAttribute.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.joinRequestedAttribute);
        this.joinRequireMatch = new BooleanArgument(null, "joinRequireMatch", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_JOIN_REQUIRE_MATCH.get());
        this.joinRequireMatch.addLongIdentifier("join-require-match", true);
        this.joinRequireMatch.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.joinRequireMatch);
        this.manageDsaIT = new BooleanArgument(null, "manageDsaIT", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_MANAGE_DSA_IT.get());
        this.manageDsaIT.addLongIdentifier("manage-dsa-it", true);
        this.manageDsaIT.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.manageDsaIT);
        this.matchedValuesFilter = new FilterArgument(null, "matchedValuesFilter", false, 0, ToolMessages.INFO_PLACEHOLDER_FILTER.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_MATCHED_VALUES_FILTER.get());
        this.matchedValuesFilter.addLongIdentifier("matched-values-filter", true);
        this.matchedValuesFilter.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.matchedValuesFilter);
        this.matchingEntryCountControl = new StringArgument(null, "matchingEntryCountControl", false, 1, "{examineCount=NNN[:alwaysExamine][:allowUnindexed][:skipResolvingExplodedIndexes][:fastShortCircuitThreshold=NNN][:slowShortCircuitThreshold=NNN][:debug]}", ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_MATCHING_ENTRY_COUNT_CONTROL.get());
        this.matchingEntryCountControl.addLongIdentifier("matchingEntryCount", true);
        this.matchingEntryCountControl.addLongIdentifier("matching-entry-count-control", true);
        this.matchingEntryCountControl.addLongIdentifier("matching-entry-count", true);
        this.matchingEntryCountControl.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.matchingEntryCountControl);
        this.operationPurpose = new StringArgument(null, "operationPurpose", false, 1, ToolMessages.INFO_PLACEHOLDER_PURPOSE.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_OPERATION_PURPOSE.get());
        this.operationPurpose.addLongIdentifier("operation-purpose", true);
        this.operationPurpose.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.operationPurpose);
        this.overrideSearchLimit = new StringArgument(null, "overrideSearchLimit", false, 0, ToolMessages.INFO_LDAPSEARCH_NAME_VALUE_PLACEHOLDER.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_OVERRIDE_SEARCH_LIMIT.get());
        this.overrideSearchLimit.addLongIdentifier("overrideSearchLimits", true);
        this.overrideSearchLimit.addLongIdentifier("override-search-limit", true);
        this.overrideSearchLimit.addLongIdentifier("override-search-limits", true);
        this.overrideSearchLimit.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.overrideSearchLimit);
        this.persistentSearch = new StringArgument(Character.valueOf('C'), "persistentSearch", false, 1, "ps[:changetype[:changesonly[:entrychgcontrols]]]", ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_PERSISTENT_SEARCH.get());
        this.persistentSearch.addLongIdentifier("persistent-search", true);
        this.persistentSearch.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.persistentSearch);
        this.permitUnindexedSearch = new BooleanArgument(null, "permitUnindexedSearch", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_PERMIT_UNINDEXED_SEARCH.get());
        this.permitUnindexedSearch.addLongIdentifier("permitUnindexedSearches", true);
        this.permitUnindexedSearch.addLongIdentifier("permitUnindexed", true);
        this.permitUnindexedSearch.addLongIdentifier("permitIfUnindexed", true);
        this.permitUnindexedSearch.addLongIdentifier("permit-unindexed-search", true);
        this.permitUnindexedSearch.addLongIdentifier("permit-unindexed-searches", true);
        this.permitUnindexedSearch.addLongIdentifier("permit-unindexed", true);
        this.permitUnindexedSearch.addLongIdentifier("permit-if-unindexed", true);
        this.permitUnindexedSearch.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.permitUnindexedSearch);
        this.proxyAs = new StringArgument(Character.valueOf('Y'), "proxyAs", false, 1, ToolMessages.INFO_PLACEHOLDER_AUTHZID.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_PROXY_AS.get());
        this.proxyAs.addLongIdentifier("proxy-as", true);
        this.proxyAs.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.proxyAs);
        this.proxyV1As = new DNArgument(null, "proxyV1As", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_PROXY_V1_AS.get());
        this.proxyV1As.addLongIdentifier("proxy-v1-as", true);
        this.proxyV1As.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.proxyV1As);
        this.rejectUnindexedSearch = new BooleanArgument(null, "rejectUnindexedSearch", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_REJECT_UNINDEXED_SEARCH.get());
        this.rejectUnindexedSearch.addLongIdentifier("rejectUnindexedSearches", true);
        this.rejectUnindexedSearch.addLongIdentifier("rejectUnindexed", true);
        this.rejectUnindexedSearch.addLongIdentifier("rejectIfUnindexed", true);
        this.rejectUnindexedSearch.addLongIdentifier("reject-unindexed-search", true);
        this.rejectUnindexedSearch.addLongIdentifier("reject-unindexed-searches", true);
        this.rejectUnindexedSearch.addLongIdentifier("reject-unindexed", true);
        this.rejectUnindexedSearch.addLongIdentifier("reject-if-unindexed", true);
        this.rejectUnindexedSearch.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.rejectUnindexedSearch);
        this.routeToBackendSet = new StringArgument(null, "routeToBackendSet", false, 0, ToolMessages.INFO_LDAPSEARCH_ARG_PLACEHOLDER_ROUTE_TO_BACKEND_SET.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_ROUTE_TO_BACKEND_SET.get());
        this.routeToBackendSet.addLongIdentifier("route-to-backend-set", true);
        this.routeToBackendSet.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.routeToBackendSet);
        this.routeToServer = new StringArgument(null, "routeToServer", false, 1, ToolMessages.INFO_LDAPSEARCH_ARG_PLACEHOLDER_ROUTE_TO_SERVER.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_ROUTE_TO_SERVER.get());
        this.routeToServer.addLongIdentifier("route-to-server", true);
        this.routeToServer.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.routeToServer);
        Set<String> suppressOperationalAttributeUpdatesAllowedValues = StaticUtils.setOf("last-access-time", "last-login-time", "last-login-ip", "lastmod");
        this.suppressOperationalAttributeUpdates = new StringArgument(null, "suppressOperationalAttributeUpdates", false, -1, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_SUPPRESS_OP_ATTR_UPDATES.get(), suppressOperationalAttributeUpdatesAllowedValues);
        this.suppressOperationalAttributeUpdates.addLongIdentifier("suppress-operational-attribute-updates", true);
        this.suppressOperationalAttributeUpdates.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.suppressOperationalAttributeUpdates);
        this.usePasswordPolicyControl = new BooleanArgument(null, "usePasswordPolicyControl", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_PASSWORD_POLICY.get());
        this.usePasswordPolicyControl.addLongIdentifier("use-password-policy-control", true);
        this.usePasswordPolicyControl.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.usePasswordPolicyControl);
        this.realAttributesOnly = new BooleanArgument(null, "realAttributesOnly", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_REAL_ATTRS_ONLY.get());
        this.realAttributesOnly.addLongIdentifier("real-attributes-only", true);
        this.realAttributesOnly.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.realAttributesOnly);
        this.sortOrder = new StringArgument(Character.valueOf('S'), "sortOrder", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_SORT_ORDER.get());
        this.sortOrder.addLongIdentifier("sort-order", true);
        this.sortOrder.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.sortOrder);
        this.simplePageSize = new IntegerArgument(null, "simplePageSize", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_PAGE_SIZE.get(), 1, Integer.MAX_VALUE);
        this.simplePageSize.addLongIdentifier("simple-page-size", true);
        this.simplePageSize.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.simplePageSize);
        this.virtualAttributesOnly = new BooleanArgument(null, "virtualAttributesOnly", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_VIRTUAL_ATTRS_ONLY.get());
        this.virtualAttributesOnly.addLongIdentifier("virtual-attributes-only", true);
        this.virtualAttributesOnly.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.virtualAttributesOnly);
        this.virtualListView = new StringArgument(Character.valueOf('G'), "virtualListView", false, 1, "{before:after:index:count | before:after:value}", ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_VLV.get("sortOrder"));
        this.virtualListView.addLongIdentifier("vlv", true);
        this.virtualListView.addLongIdentifier("virtual-list-view", true);
        this.virtualListView.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.virtualListView);
        this.excludeAttribute = new StringArgument(null, "excludeAttribute", false, 0, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_EXCLUDE_ATTRIBUTE.get());
        this.excludeAttribute.addLongIdentifier("exclude-attribute", true);
        this.excludeAttribute.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_TRANSFORMATIONS.get());
        parser.addArgument(this.excludeAttribute);
        this.redactAttribute = new StringArgument(null, "redactAttribute", false, 0, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_REDACT_ATTRIBUTE.get());
        this.redactAttribute.addLongIdentifier("redact-attribute", true);
        this.redactAttribute.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_TRANSFORMATIONS.get());
        parser.addArgument(this.redactAttribute);
        this.hideRedactedValueCount = new BooleanArgument(null, "hideRedactedValueCount", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_HIDE_REDACTED_VALUE_COUNT.get());
        this.hideRedactedValueCount.addLongIdentifier("hide-redacted-value-count", true);
        this.hideRedactedValueCount.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_TRANSFORMATIONS.get());
        parser.addArgument(this.hideRedactedValueCount);
        this.scrambleAttribute = new StringArgument(null, "scrambleAttribute", false, 0, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_SCRAMBLE_ATTRIBUTE.get());
        this.scrambleAttribute.addLongIdentifier("scramble-attribute", true);
        this.scrambleAttribute.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_TRANSFORMATIONS.get());
        parser.addArgument(this.scrambleAttribute);
        this.scrambleJSONField = new StringArgument(null, "scrambleJSONField", false, 0, ToolMessages.INFO_PLACEHOLDER_FIELD_NAME.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_SCRAMBLE_JSON_FIELD.get());
        this.scrambleJSONField.addLongIdentifier("scramble-json-field", true);
        this.scrambleJSONField.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_TRANSFORMATIONS.get());
        parser.addArgument(this.scrambleJSONField);
        this.scrambleRandomSeed = new IntegerArgument(null, "scrambleRandomSeed", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_SCRAMBLE_RANDOM_SEED.get());
        this.scrambleRandomSeed.addLongIdentifier("scramble-random-seed", true);
        this.scrambleRandomSeed.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_TRANSFORMATIONS.get());
        parser.addArgument(this.scrambleRandomSeed);
        this.renameAttributeFrom = new StringArgument(null, "renameAttributeFrom", false, 0, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_RENAME_ATTRIBUTE_FROM.get());
        this.renameAttributeFrom.addLongIdentifier("rename-attribute-from", true);
        this.renameAttributeFrom.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_TRANSFORMATIONS.get());
        parser.addArgument(this.renameAttributeFrom);
        this.renameAttributeTo = new StringArgument(null, "renameAttributeTo", false, 0, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_RENAME_ATTRIBUTE_TO.get());
        this.renameAttributeTo.addLongIdentifier("rename-attribute-to", true);
        this.renameAttributeTo.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_TRANSFORMATIONS.get());
        parser.addArgument(this.renameAttributeTo);
        this.moveSubtreeFrom = new DNArgument(null, "moveSubtreeFrom", false, 0, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_MOVE_SUBTREE_FROM.get());
        this.moveSubtreeFrom.addLongIdentifier("move-subtree-from", true);
        this.moveSubtreeFrom.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_TRANSFORMATIONS.get());
        parser.addArgument(this.moveSubtreeFrom);
        this.moveSubtreeTo = new DNArgument(null, "moveSubtreeTo", false, 0, ToolMessages.INFO_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_MOVE_SUBTREE_TO.get());
        this.moveSubtreeTo.addLongIdentifier("move-subtree-to", true);
        this.moveSubtreeTo.setArgumentGroupName(ToolMessages.INFO_LDAPSEARCH_ARG_GROUP_TRANSFORMATIONS.get());
        parser.addArgument(this.moveSubtreeTo);
        BooleanArgument scriptFriendly = new BooleanArgument(null, "scriptFriendly", 1, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_SCRIPT_FRIENDLY.get());
        scriptFriendly.addLongIdentifier("script-friendly", true);
        scriptFriendly.setHidden(true);
        parser.addArgument(scriptFriendly);
        IntegerArgument ldapVersion = new IntegerArgument(Character.valueOf('V'), "ldapVersion", false, 1, null, ToolMessages.INFO_LDAPSEARCH_ARG_DESCRIPTION_LDAP_VERSION.get());
        ldapVersion.addLongIdentifier("ldap-version", true);
        ldapVersion.setHidden(true);
        parser.addArgument(ldapVersion);
        parser.addExclusiveArgumentSet(this.baseDN, this.ldapURLFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.scope, this.ldapURLFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.requestedAttribute, this.ldapURLFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.filter, this.ldapURLFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.filterFile, this.ldapURLFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.followReferrals, this.manageDsaIT, new Argument[0]);
        parser.addExclusiveArgumentSet(this.persistentSearch, this.filterFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.persistentSearch, this.ldapURLFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.realAttributesOnly, this.virtualAttributesOnly, new Argument[0]);
        parser.addExclusiveArgumentSet(this.simplePageSize, this.virtualListView, new Argument[0]);
        parser.addExclusiveArgumentSet(this.terse, this.verbose, new Argument[0]);
        parser.addDependentArgumentSet(this.getEffectiveRightsAttribute, this.getEffectiveRightsAuthzID, new Argument[0]);
        parser.addDependentArgumentSet(this.virtualListView, this.sortOrder, new Argument[0]);
        parser.addExclusiveArgumentSet(this.rejectUnindexedSearch, this.permitUnindexedSearch, new Argument[0]);
        parser.addDependentArgumentSet(this.separateOutputFilePerSearch, this.outputFile, new Argument[0]);
        parser.addDependentArgumentSet(this.separateOutputFilePerSearch, this.filter, this.filterFile, this.ldapURLFile);
        parser.addDependentArgumentSet(this.teeResultsToStandardOut, this.outputFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.wrapColumn, this.dontWrap, new Argument[0]);
        parser.addDependentArgumentSet(this.joinBaseDN, this.joinRule, new Argument[0]);
        parser.addDependentArgumentSet(this.joinScope, this.joinRule, new Argument[0]);
        parser.addDependentArgumentSet(this.joinSizeLimit, this.joinRule, new Argument[0]);
        parser.addDependentArgumentSet(this.joinFilter, this.joinRule, new Argument[0]);
        parser.addDependentArgumentSet(this.joinRequestedAttribute, this.joinRule, new Argument[0]);
        parser.addDependentArgumentSet(this.joinRequireMatch, this.joinRule, new Argument[0]);
        parser.addExclusiveArgumentSet(this.countEntries, this.filter, new Argument[0]);
        parser.addExclusiveArgumentSet(this.countEntries, this.filterFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.countEntries, this.ldapURLFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.countEntries, this.persistentSearch, new Argument[0]);
        parser.addDependentArgumentSet(this.hideRedactedValueCount, this.redactAttribute, new Argument[0]);
        parser.addDependentArgumentSet(this.scrambleJSONField, this.scrambleAttribute, new Argument[0]);
        parser.addDependentArgumentSet(this.scrambleRandomSeed, this.scrambleAttribute, new Argument[0]);
        parser.addDependentArgumentSet(this.renameAttributeFrom, this.renameAttributeTo, new Argument[0]);
        parser.addDependentArgumentSet(this.renameAttributeTo, this.renameAttributeFrom, new Argument[0]);
        parser.addDependentArgumentSet(this.moveSubtreeFrom, this.moveSubtreeTo, new Argument[0]);
        parser.addDependentArgumentSet(this.moveSubtreeTo, this.moveSubtreeFrom, new Argument[0]);
        parser.addDependentArgumentSet(this.compressOutput, this.outputFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.compressOutput, this.teeResultsToStandardOut, new Argument[0]);
        parser.addDependentArgumentSet(this.encryptOutput, this.outputFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.encryptOutput, this.teeResultsToStandardOut, new Argument[0]);
        parser.addDependentArgumentSet(this.encryptionPassphraseFile, this.encryptOutput, new Argument[0]);
    }

    @Override
    protected List<Control> getBindControls() {
        ArrayList<Control> bindControls = new ArrayList<Control>(10);
        if (this.bindControl.isPresent()) {
            bindControls.addAll(this.bindControl.getValues());
        }
        if (this.authorizationIdentity.isPresent()) {
            bindControls.add(new AuthorizationIdentityRequestControl(false));
        }
        if (this.getAuthorizationEntryAttribute.isPresent()) {
            bindControls.add(new GetAuthorizationEntryRequestControl(true, true, this.getAuthorizationEntryAttribute.getValues()));
        }
        if (this.getUserResourceLimits.isPresent()) {
            bindControls.add(new GetUserResourceLimitsRequestControl());
        }
        if (this.usePasswordPolicyControl.isPresent()) {
            bindControls.add(new PasswordPolicyRequestControl());
        }
        if (this.suppressOperationalAttributeUpdates.isPresent()) {
            EnumSet<SuppressType> suppressTypes = EnumSet.noneOf(SuppressType.class);
            for (String s : this.suppressOperationalAttributeUpdates.getValues()) {
                if (s.equalsIgnoreCase("last-access-time")) {
                    suppressTypes.add(SuppressType.LAST_ACCESS_TIME);
                    continue;
                }
                if (s.equalsIgnoreCase("last-login-time")) {
                    suppressTypes.add(SuppressType.LAST_LOGIN_TIME);
                    continue;
                }
                if (!s.equalsIgnoreCase("last-login-ip")) continue;
                suppressTypes.add(SuppressType.LAST_LOGIN_IP);
            }
            bindControls.add(new SuppressOperationalAttributeUpdateRequestControl(suppressTypes));
        }
        return bindControls;
    }

    @Override
    protected boolean supportsMultipleServers() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
        String outputFormatStr;
        String derefStr;
        List<String> trailingArgs;
        block116: {
            if (this.wrapColumn.isPresent()) {
                int wc = this.wrapColumn.getValue();
                WRAP_COLUMN = wc <= 0 ? Integer.MAX_VALUE : wc;
            } else if (this.dontWrap.isPresent()) {
                WRAP_COLUMN = Integer.MAX_VALUE;
            }
            trailingArgs = this.parser.getTrailingArguments();
            if (this.ldapURLFile.isPresent() && !trailingArgs.isEmpty()) {
                throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_TRAILING_ARGS_WITH_URL_FILE.get(this.ldapURLFile.getIdentifierString()));
            }
            if ((this.filter.isPresent() || this.filterFile.isPresent()) && !trailingArgs.isEmpty()) {
                try {
                    Filter.create(trailingArgs.get(0));
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_TRAILING_FILTER_WITH_FILTER_FILE.get(this.filterFile.getIdentifierString()));
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
            }
            if (!(this.ldapURLFile.isPresent() || this.filter.isPresent() || this.filterFile.isPresent())) {
                if (trailingArgs.isEmpty()) {
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_NO_TRAILING_ARGS.get(this.filterFile.getIdentifierString(), this.ldapURLFile.getIdentifierString()));
                }
                try {
                    Filter.create(trailingArgs.get(0));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_FIRST_TRAILING_ARG_NOT_FILTER.get(trailingArgs.get(0)), e);
                }
            }
            for (String s : trailingArgs) {
                if (!s.startsWith("-")) continue;
                this.commentToErr(ToolMessages.WARN_LDAPSEARCH_TRAILING_ARG_STARTS_WITH_DASH.get(s));
                break;
            }
            if (this.matchedValuesFilter.isPresent()) {
                List<Filter> filterList = this.matchedValuesFilter.getValues();
                MatchedValuesFilter[] matchedValuesFilters = new MatchedValuesFilter[filterList.size()];
                for (int i = 0; i < matchedValuesFilters.length; ++i) {
                    try {
                        matchedValuesFilters[i] = MatchedValuesFilter.create(filterList.get(i));
                        continue;
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_INVALID_MATCHED_VALUES_FILTER.get(filterList.get(i).toString()), exception);
                    }
                }
                this.matchedValuesRequestControl = new MatchedValuesRequestControl(true, matchedValuesFilters);
            }
            if (this.matchingEntryCountControl.isPresent()) {
                boolean bl;
                boolean allowUnindexed = false;
                boolean alwaysExamine = false;
                boolean debug = false;
                boolean bl2 = false;
                Integer examineCount = null;
                Long fastShortCircuitThreshold = null;
                Long slowShortCircuitThreshold = null;
                try {
                    for (String element : this.matchingEntryCountControl.getValue().toLowerCase().split(":")) {
                        if (element.startsWith("examinecount=")) {
                            examineCount = Integer.parseInt(element.substring(13));
                            continue;
                        }
                        if (element.equals("allowunindexed")) {
                            allowUnindexed = true;
                            continue;
                        }
                        if (element.equals("alwaysexamine")) {
                            alwaysExamine = true;
                            continue;
                        }
                        if (element.equals("skipresolvingexplodedindexes")) {
                            bl = true;
                            continue;
                        }
                        if (element.startsWith("fastshortcircuitthreshold=")) {
                            fastShortCircuitThreshold = Long.parseLong(element.substring(26));
                            continue;
                        }
                        if (element.startsWith("slowshortcircuitthreshold=")) {
                            slowShortCircuitThreshold = Long.parseLong(element.substring(26));
                            continue;
                        }
                        if (element.equals("debug")) {
                            debug = true;
                            continue;
                        }
                        throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_MATCHING_ENTRY_COUNT_INVALID_VALUE.get(this.matchingEntryCountControl.getIdentifierString()));
                    }
                }
                catch (ArgumentException ae) {
                    Debug.debugException(ae);
                    throw ae;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_MATCHING_ENTRY_COUNT_INVALID_VALUE.get(this.matchingEntryCountControl.getIdentifierString()), e);
                }
                if (examineCount == null) {
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_MATCHING_ENTRY_COUNT_INVALID_VALUE.get(this.matchingEntryCountControl.getIdentifierString()));
                }
                this.matchingEntryCountRequestControl = new MatchingEntryCountRequestControl(true, examineCount, alwaysExamine, allowUnindexed, bl, fastShortCircuitThreshold, slowShortCircuitThreshold, debug);
            }
            if (this.overrideSearchLimit.isPresent()) {
                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(10));
                for (String value : this.overrideSearchLimit.getValues()) {
                    int n = value.indexOf(61);
                    if (n < 0) {
                        throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_OVERRIDE_LIMIT_NO_EQUAL.get(this.overrideSearchLimit.getIdentifierString()));
                    }
                    if (n == 0) {
                        throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_OVERRIDE_LIMIT_EMPTY_PROPERTY_NAME.get(this.overrideSearchLimit.getIdentifierString()));
                    }
                    String propertyName = value.substring(0, n);
                    if (properties.containsKey(propertyName)) {
                        throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_OVERRIDE_LIMIT_DUPLICATE_PROPERTY_NAME.get(this.overrideSearchLimit.getIdentifierString(), propertyName));
                    }
                    if (n == value.length() - 1) {
                        throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_OVERRIDE_LIMIT_EMPTY_PROPERTY_VALUE.get(this.overrideSearchLimit.getIdentifierString(), propertyName));
                    }
                    properties.put(propertyName, value.substring(n + 1));
                }
                this.overrideSearchLimitsRequestControl = new OverrideSearchLimitsRequestControl(properties, false);
            }
            if (this.persistentSearch.isPresent()) {
                EnumSet<PersistentSearchChangeType> changeTypes;
                boolean returnECs;
                boolean changesOnly;
                block115: {
                    changesOnly = true;
                    returnECs = true;
                    changeTypes = EnumSet.allOf(PersistentSearchChangeType.class);
                    try {
                        String[] stringArray = this.persistentSearch.getValue().toLowerCase().split(":");
                        if (stringArray.length == 0) {
                            throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_PERSISTENT_SEARCH_INVALID_VALUE.get(this.persistentSearch.getIdentifierString()));
                        }
                        String header = StaticUtils.toLowerCase(stringArray[0]);
                        if (!(header.equals("ps") || header.equals("persist") || header.equals("persistent") || header.equals("psearch") || header.equals("persistentsearch"))) {
                            throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_PERSISTENT_SEARCH_INVALID_VALUE.get(this.persistentSearch.getIdentifierString()));
                        }
                        if (stringArray.length > 1) {
                            String ctString = StaticUtils.toLowerCase(stringArray[1]);
                            if (ctString.equals("any")) {
                                changeTypes = EnumSet.allOf(PersistentSearchChangeType.class);
                            } else {
                                changeTypes.clear();
                                for (String t : ctString.split(",")) {
                                    if (t.equals("add")) {
                                        changeTypes.add(PersistentSearchChangeType.ADD);
                                        continue;
                                    }
                                    if (t.equals("del") || t.equals("delete")) {
                                        changeTypes.add(PersistentSearchChangeType.DELETE);
                                        continue;
                                    }
                                    if (t.equals("mod") || t.equals("modify")) {
                                        changeTypes.add(PersistentSearchChangeType.MODIFY);
                                        continue;
                                    }
                                    if (t.equals("moddn") || t.equals("modrdn") || t.equals("modifydn") || t.equals("modifyrdn")) {
                                        changeTypes.add(PersistentSearchChangeType.MODIFY_DN);
                                        continue;
                                    }
                                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_PERSISTENT_SEARCH_INVALID_VALUE.get(this.persistentSearch.getIdentifierString()));
                                }
                            }
                        }
                        if (stringArray.length > 2) {
                            if (stringArray[2].equalsIgnoreCase("true") || stringArray[2].equals("1")) {
                                changesOnly = true;
                            } else if (stringArray[2].equalsIgnoreCase("false") || stringArray[2].equals("0")) {
                                changesOnly = false;
                            } else {
                                throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_PERSISTENT_SEARCH_INVALID_VALUE.get(this.persistentSearch.getIdentifierString()));
                            }
                        }
                        if (stringArray.length <= 3) break block115;
                        if (stringArray[3].equalsIgnoreCase("true") || stringArray[3].equals("1")) {
                            returnECs = true;
                            break block115;
                        }
                        if (stringArray[3].equalsIgnoreCase("false") || stringArray[3].equals("0")) {
                            returnECs = false;
                            break block115;
                        }
                        throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_PERSISTENT_SEARCH_INVALID_VALUE.get(this.persistentSearch.getIdentifierString()));
                    }
                    catch (ArgumentException argumentException) {
                        Debug.debugException(argumentException);
                        throw argumentException;
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_PERSISTENT_SEARCH_INVALID_VALUE.get(this.persistentSearch.getIdentifierString()), exception);
                    }
                }
                this.persistentSearchRequestControl = new PersistentSearchRequestControl(changeTypes, changesOnly, returnECs, true);
            }
            if (this.sortOrder.isPresent()) {
                ArrayList<SortKey> sortKeyList = new ArrayList<SortKey>(5);
                StringTokenizer tokenizer = new StringTokenizer(this.sortOrder.getValue(), ", ");
                while (tokenizer.hasMoreTokens()) {
                    void var5_46;
                    String matchingRuleID;
                    String attributeName;
                    String token = tokenizer.nextToken();
                    if (token.startsWith("-")) {
                        boolean bl = false;
                        attributeName = token.substring(1);
                    } else if (token.startsWith("+")) {
                        boolean bl = true;
                        attributeName = token.substring(1);
                    } else {
                        boolean bl = true;
                        attributeName = token;
                    }
                    int colonPos = attributeName.indexOf(58);
                    if (colonPos >= 0) {
                        matchingRuleID = attributeName.substring(colonPos + 1);
                        attributeName = attributeName.substring(0, colonPos);
                    } else {
                        matchingRuleID = null;
                    }
                    StringBuilder invalidReason = new StringBuilder();
                    if (!PersistUtils.isValidLDAPName(attributeName, false, invalidReason)) {
                        throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_SORT_ORDER_INVALID_VALUE.get(this.sortOrder.getIdentifierString()));
                    }
                    sortKeyList.add(new SortKey(attributeName, matchingRuleID, var5_46 == false));
                }
                if (sortKeyList.isEmpty()) {
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_SORT_ORDER_INVALID_VALUE.get(this.sortOrder.getIdentifierString()));
                }
                SortKey[] sortKeyArray = new SortKey[sortKeyList.size()];
                sortKeyList.toArray(sortKeyArray);
                this.sortRequestControl = new ServerSideSortRequestControl(sortKeyArray);
            }
            if (this.virtualListView.isPresent()) {
                try {
                    String[] elements = this.virtualListView.getValue().split(":");
                    if (elements.length == 4) {
                        this.vlvRequestControl = new VirtualListViewRequestControl(Integer.parseInt(elements[2]), Integer.parseInt(elements[0]), Integer.parseInt(elements[1]), Integer.parseInt(elements[3]), null);
                        break block116;
                    }
                    if (elements.length == 3) {
                        this.vlvRequestControl = new VirtualListViewRequestControl(elements[2], Integer.parseInt(elements[0]), Integer.parseInt(elements[1]), null);
                        break block116;
                    }
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_VLV_INVALID_VALUE.get(this.virtualListView.getIdentifierString()));
                }
                catch (ArgumentException ae) {
                    Debug.debugException(ae);
                    throw ae;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_VLV_INVALID_VALUE.get(this.virtualListView.getIdentifierString()), e);
                }
            }
        }
        if (this.joinRule.isPresent()) {
            String[] joinAttrs;
            JoinBaseDN joinBase;
            JoinRule rule;
            block117: {
                try {
                    String[] elements = this.joinRule.getValue().toLowerCase().split(":");
                    String ruleName = StaticUtils.toLowerCase(elements[0]);
                    if (ruleName.equals("dn")) {
                        rule = JoinRule.createDNJoin(elements[1]);
                        break block117;
                    }
                    if (ruleName.equals("reverse-dn") || ruleName.equals("reversedn")) {
                        rule = JoinRule.createReverseDNJoin(elements[1]);
                        break block117;
                    }
                    if (ruleName.equals("equals") || ruleName.equals("equality")) {
                        rule = JoinRule.createEqualityJoin(elements[1], elements[2], false);
                        break block117;
                    }
                    if (ruleName.equals("contains") || ruleName.equals("substring")) {
                        rule = JoinRule.createContainsJoin(elements[1], elements[2], false);
                        break block117;
                    }
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_JOIN_RULE_INVALID_VALUE.get(this.joinRule.getIdentifierString()));
                }
                catch (ArgumentException ae) {
                    Debug.debugException(ae);
                    throw ae;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_JOIN_RULE_INVALID_VALUE.get(this.joinRule.getIdentifierString()), e);
                }
            }
            if (this.joinBaseDN.isPresent()) {
                String s = StaticUtils.toLowerCase(this.joinBaseDN.getValue());
                if (s.equals("search-base") || s.equals("search-base-dn")) {
                    joinBase = JoinBaseDN.createUseSearchBaseDN();
                } else if (s.equals("source-entry-dn") || s.equals("source-dn")) {
                    joinBase = JoinBaseDN.createUseSourceEntryDN();
                } else {
                    try {
                        DN dN = new DN(this.joinBaseDN.getValue());
                        joinBase = JoinBaseDN.createUseCustomBaseDN(this.joinBaseDN.getValue());
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_JOIN_BASE_DN_INVALID_VALUE.get(this.joinBaseDN.getIdentifierString()), exception);
                    }
                }
            } else {
                joinBase = JoinBaseDN.createUseSearchBaseDN();
            }
            if (this.joinRequestedAttribute.isPresent()) {
                List<String> list = this.joinRequestedAttribute.getValues();
                joinAttrs = new String[list.size()];
                list.toArray(joinAttrs);
            } else {
                joinAttrs = null;
            }
            this.joinRequestControl = new JoinRequestControl(new JoinRequestValue(rule, joinBase, this.joinScope.getValue(), DereferencePolicy.NEVER, this.joinSizeLimit.getValue(), this.joinFilter.getValue(), joinAttrs, this.joinRequireMatch.isPresent(), null));
        }
        if (this.routeToBackendSet.isPresent()) {
            List<String> values = this.routeToBackendSet.getValues();
            LinkedHashMap<String, ArrayList<String>> idsByRP = new LinkedHashMap<String, ArrayList<String>>(StaticUtils.computeMapCapacity(values.size()));
            for (String string : values) {
                int colonPos = string.indexOf(58);
                if (colonPos <= 0) {
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_ROUTE_TO_BACKEND_SET_INVALID_FORMAT.get(string, this.routeToBackendSet.getIdentifierString()));
                }
                String rpID = string.substring(0, colonPos);
                String bsID = string.substring(colonPos + 1);
                ArrayList<String> idsForRP = (ArrayList<String>)idsByRP.get(rpID);
                if (idsForRP == null) {
                    idsForRP = new ArrayList<String>(values.size());
                    idsByRP.put(rpID, idsForRP);
                }
                idsForRP.add(bsID);
            }
            for (Map.Entry entry : idsByRP.entrySet()) {
                String rpID = (String)entry.getKey();
                List bsIDs = (List)entry.getValue();
                this.routeToBackendSetRequestControls.add(RouteToBackendSetRequestControl.createAbsoluteRoutingRequest(true, rpID, bsIDs));
            }
        }
        this.derefPolicy = (derefStr = StaticUtils.toLowerCase(this.dereferencePolicy.getValue())).equals("always") ? DereferencePolicy.ALWAYS : (derefStr.equals("search") ? DereferencePolicy.SEARCHING : (derefStr.equals("find") ? DereferencePolicy.FINDING : DereferencePolicy.NEVER));
        ArrayList<EntryTransformation> transformations = new ArrayList<EntryTransformation>(5);
        if (this.excludeAttribute.isPresent()) {
            transformations.add(new ExcludeAttributeTransformation(null, this.excludeAttribute.getValues()));
        }
        if (this.redactAttribute.isPresent()) {
            transformations.add(new RedactAttributeTransformation(null, true, !this.hideRedactedValueCount.isPresent(), this.redactAttribute.getValues()));
        }
        if (this.scrambleAttribute.isPresent()) {
            Long randomSeed = this.scrambleRandomSeed.isPresent() ? Long.valueOf(this.scrambleRandomSeed.getValue().longValue()) : null;
            transformations.add(new ScrambleAttributeTransformation(null, randomSeed, true, this.scrambleAttribute.getValues(), this.scrambleJSONField.getValues()));
        }
        if (this.renameAttributeFrom.isPresent()) {
            if (this.renameAttributeFrom.getNumOccurrences() != this.renameAttributeTo.getNumOccurrences()) {
                throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_RENAME_ATTRIBUTE_MISMATCH.get());
            }
            Iterator<String> sourceIterator = this.renameAttributeFrom.getValues().iterator();
            Iterator<String> iterator = this.renameAttributeTo.getValues().iterator();
            while (sourceIterator.hasNext()) {
                transformations.add(new RenameAttributeTransformation(null, sourceIterator.next(), iterator.next(), true));
            }
        }
        if (this.moveSubtreeFrom.isPresent()) {
            if (this.moveSubtreeFrom.getNumOccurrences() != this.moveSubtreeTo.getNumOccurrences()) {
                throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_MOVE_SUBTREE_MISMATCH.get());
            }
            Iterator<DN> sourceIterator = this.moveSubtreeFrom.getValues().iterator();
            Iterator<DN> iterator = this.moveSubtreeTo.getValues().iterator();
            while (sourceIterator.hasNext()) {
                transformations.add(new MoveSubtreeTransformation(sourceIterator.next(), iterator.next()));
            }
        }
        if (!transformations.isEmpty()) {
            this.entryTransformations = transformations;
        }
        if ((outputFormatStr = StaticUtils.toLowerCase(this.outputFormat.getValue())).equals("json")) {
            this.outputHandler = new JSONLDAPSearchOutputHandler(this);
        } else if (outputFormatStr.equals("csv") || outputFormatStr.equals("tab-delimited")) {
            if (this.ldapURLFile.isPresent()) {
                throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_OUTPUT_FORMAT_NOT_SUPPORTED_WITH_URLS.get(this.outputFormat.getValue(), this.ldapURLFile.getIdentifierString()));
            }
            List<String> list = this.requestedAttribute.getValues();
            if (list == null || list.isEmpty()) {
                throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_OUTPUT_FORMAT_REQUIRES_REQUESTED_ATTR_ARG.get(this.outputFormat.getValue(), this.requestedAttribute.getIdentifierString()));
            }
            switch (trailingArgs.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!this.filter.isPresent() && !this.filterFile.isPresent()) break;
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_OUTPUT_FORMAT_REQUIRES_REQUESTED_ATTR_ARG.get(this.outputFormat.getValue(), this.requestedAttribute.getIdentifierString()));
                }
                default: {
                    throw new ArgumentException(ToolMessages.ERR_LDAPSEARCH_OUTPUT_FORMAT_REQUIRES_REQUESTED_ATTR_ARG.get(this.outputFormat.getValue(), this.requestedAttribute.getIdentifierString()));
                }
            }
            this.outputHandler = new ColumnFormatterLDAPSearchOutputHandler(this, outputFormatStr.equals("csv") ? OutputFormat.CSV : OutputFormat.TAB_DELIMITED_TEXT, list, WRAP_COLUMN);
        } else {
            this.outputHandler = new LDIFLDAPSearchOutputHandler(this, WRAP_COLUMN);
        }
    }

    @Override
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(true);
        options.setFollowReferrals(this.followReferrals.isPresent());
        options.setUnsolicitedNotificationHandler(this);
        options.setResponseTimeoutMillis(0L);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode doToolProcessing() {
        if (this.encryptOutput.isPresent()) {
            if (this.encryptionPassphraseFile.isPresent()) {
                try {
                    this.encryptionPassphrase = ToolUtils.readEncryptionPassphraseFromFile(this.encryptionPassphraseFile.getValue());
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, e.getMessage());
                    return e.getResultCode();
                }
            }
            try {
                this.encryptionPassphrase = ToolUtils.promptForEncryptionPassphrase(false, true, this.getOut(), this.getErr());
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, e.getMessage());
                return e.getResultCode();
            }
        }
        if (this.outputFile.isPresent()) {
            if (!this.separateOutputFilePerSearch.isPresent()) {
                try {
                    OutputStream s = new FileOutputStream(this.outputFile.getValue());
                    if (this.encryptOutput.isPresent()) {
                        s = new PassphraseEncryptedOutputStream(this.encryptionPassphrase, s);
                    }
                    if (this.compressOutput.isPresent()) {
                        s = new GZIPOutputStream(s);
                    }
                    this.outStream = this.teeResultsToStandardOut.isPresent() ? new PrintStream(new TeeOutputStream(s, this.getOut())) : new PrintStream(s);
                    this.errStream = this.outStream;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.wrapErr(0, WRAP_COLUMN, ToolMessages.ERR_LDAPSEARCH_CANNOT_OPEN_OUTPUT_FILE.get(this.outputFile.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                    return ResultCode.LOCAL_ERROR;
                }
                this.outputHandler.formatHeader();
            }
        } else {
            this.outputHandler.formatHeader();
        }
        List<Control> searchControls = this.getSearchControls();
        boolean originalCommentAboutBase64EncodedValues = LDIFWriter.commentAboutBase64EncodedValues();
        LDIFWriter.setCommentAboutBase64EncodedValues(!this.suppressBase64EncodedValueComments.isPresent());
        LDAPConnectionPool pool = null;
        try {
            List<String> trailingArgs;
            if (!this.dryRun.isPresent()) {
                try {
                    StartAdministrativeSessionPostConnectProcessor p = this.useAdministrativeSession.isPresent() ? new StartAdministrativeSessionPostConnectProcessor(new StartAdministrativeSessionExtendedRequest(this.getToolName(), true, new Control[0])) : null;
                    pool = this.getConnectionPool(1, 1, 0, p, null, true, new ReportBindResultLDAPConnectionPoolHealthCheck(this, true, false));
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.commentToErr(ToolMessages.ERR_LDAPSEARCH_CANNOT_CREATE_CONNECTION_POOL.get(StaticUtils.getExceptionMessage(le)));
                    ResultCode resultCode = le.getResultCode();
                    if (pool != null) {
                        try {
                            pool.close();
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    if (this.outStream != null) {
                        try {
                            this.outStream.close();
                            this.outStream = null;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    if (this.errStream != null) {
                        try {
                            this.errStream.close();
                            this.errStream = null;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    LDIFWriter.setCommentAboutBase64EncodedValues(originalCommentAboutBase64EncodedValues);
                    return resultCode;
                }
                if (this.retryFailedOperations.isPresent()) {
                    pool.setRetryFailedOperationsDueToInvalidConnections(true);
                }
            }
            FixedRateBarrier rateLimiter = this.ratePerSecond.isPresent() ? new FixedRateBarrier(1000L, this.ratePerSecond.getValue()) : null;
            if (this.ldapURLFile.isPresent()) {
                ResultCode resultCode = this.searchWithLDAPURLs(pool, rateLimiter, searchControls);
                return resultCode;
            }
            ArrayList<String> attrList = new ArrayList<String>(10);
            if (this.requestedAttribute.isPresent()) {
                attrList.addAll(this.requestedAttribute.getValues());
            }
            if (!(trailingArgs = this.parser.getTrailingArguments()).isEmpty()) {
                Iterator<String> trailingArgIterator = trailingArgs.iterator();
                if (!this.filter.isPresent() && !this.filterFile.isPresent()) {
                    trailingArgIterator.next();
                }
                while (trailingArgIterator.hasNext()) {
                    attrList.add(trailingArgIterator.next());
                }
            }
            String[] attributes = new String[attrList.size()];
            attrList.toArray(attributes);
            ResultCode resultCode = ResultCode.SUCCESS;
            if (this.filter.isPresent() || this.filterFile.isPresent()) {
                if (this.filter.isPresent()) {
                    for (Serializable f : this.filter.getValues()) {
                        ResultCode rc = this.searchWithFilter(pool, (Filter)f, attributes, rateLimiter, searchControls);
                        if (rc == ResultCode.SUCCESS) continue;
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = rc;
                        }
                        if (this.continueOnError.isPresent()) continue;
                        ResultCode resultCode2 = resultCode;
                        return resultCode2;
                    }
                }
                if (this.filterFile.isPresent()) {
                    ResultCode rc = this.searchWithFilterFile(pool, attributes, rateLimiter, searchControls);
                    if (rc != ResultCode.SUCCESS) {
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = rc;
                        }
                        if (!this.continueOnError.isPresent()) {
                            Serializable f;
                            f = resultCode;
                            return f;
                        }
                    }
                }
            } else {
                Filter f;
                try {
                    String filterStr = this.parser.getTrailingArguments().iterator().next();
                    f = Filter.create(filterStr);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.displayResult(le.toLDAPResult());
                    ResultCode resultCode3 = le.getResultCode();
                    if (pool != null) {
                        try {
                            pool.close();
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    if (this.outStream != null) {
                        try {
                            this.outStream.close();
                            this.outStream = null;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    if (this.errStream != null) {
                        try {
                            this.errStream.close();
                            this.errStream = null;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                        }
                    }
                    LDIFWriter.setCommentAboutBase64EncodedValues(originalCommentAboutBase64EncodedValues);
                    return resultCode3;
                }
                resultCode = this.searchWithFilter(pool, f, attributes, rateLimiter, searchControls);
            }
            ResultCode resultCode4 = resultCode;
            return resultCode4;
        }
        finally {
            if (pool != null) {
                try {
                    pool.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            if (this.outStream != null) {
                try {
                    this.outStream.close();
                    this.outStream = null;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            if (this.errStream != null) {
                try {
                    this.errStream.close();
                    this.errStream = null;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            LDIFWriter.setCommentAboutBase64EncodedValues(originalCommentAboutBase64EncodedValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultCode searchWithLDAPURLs(LDAPConnectionPool pool, FixedRateBarrier rateLimiter, List<Control> searchControls) {
        ResultCode resultCode = ResultCode.SUCCESS;
        for (File f : this.ldapURLFile.getValues()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(f));
                while ((line = reader.readLine()) != null) {
                    LDAPURL url;
                    if (line.length() == 0 || line.startsWith("#")) continue;
                    try {
                        url = new LDAPURL(line);
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.commentToErr(ToolMessages.ERR_LDAPSEARCH_MALFORMED_LDAP_URL.get(f.getAbsolutePath(), line));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = le.getResultCode();
                        }
                        if (this.continueOnError.isPresent()) continue;
                        ResultCode resultCode2 = resultCode;
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                            }
                        }
                        return resultCode2;
                    }
                    SearchRequest searchRequest = new SearchRequest((SearchResultListener)new LDAPSearchListener(this.outputHandler, this.entryTransformations), url.getBaseDN().toString(), url.getScope(), this.derefPolicy, (int)this.sizeLimit.getValue(), (int)this.timeLimitSeconds.getValue(), this.typesOnly.isPresent(), url.getFilter(), url.getAttributes());
                    ResultCode rc = this.doSearch(pool, searchRequest, rateLimiter, searchControls);
                    if (rc == ResultCode.SUCCESS) continue;
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = rc;
                    }
                    if (this.continueOnError.isPresent()) continue;
                    ResultCode resultCode3 = resultCode;
                    return resultCode3;
                }
            }
            catch (IOException ioe) {
                this.commentToErr(ToolMessages.ERR_LDAPSEARCH_CANNOT_READ_LDAP_URL_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(ioe)));
                ResultCode resultCode4 = ResultCode.LOCAL_ERROR;
                return resultCode4;
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return resultCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultCode searchWithFilterFile(LDAPConnectionPool pool, String[] attributes, FixedRateBarrier rateLimiter, List<Control> searchControls) {
        ResultCode resultCode = ResultCode.SUCCESS;
        block19: for (File f : this.filterFile.getValues()) {
            FilterFileReader reader = null;
            try {
                reader = new FilterFileReader(f);
                while (true) {
                    Filter searchFilter;
                    try {
                        searchFilter = reader.readFilter();
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.commentToErr(ToolMessages.ERR_LDAPSEARCH_MALFORMED_FILTER.get(f.getAbsolutePath(), le.getMessage()));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = le.getResultCode();
                        }
                        if (this.continueOnError.isPresent()) continue;
                        ResultCode resultCode2 = resultCode;
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                            }
                        }
                        return resultCode2;
                    }
                    if (searchFilter == null) continue block19;
                    ResultCode rc = this.searchWithFilter(pool, searchFilter, attributes, rateLimiter, searchControls);
                    if (rc == ResultCode.SUCCESS) continue;
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = rc;
                    }
                    if (this.continueOnError.isPresent()) continue;
                    ResultCode resultCode3 = resultCode;
                    return resultCode3;
                }
            }
            catch (IOException ioe) {
                Debug.debugException(ioe);
                this.commentToErr(ToolMessages.ERR_LDAPSEARCH_CANNOT_READ_FILTER_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(ioe)));
                ResultCode resultCode4 = ResultCode.LOCAL_ERROR;
                return resultCode4;
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return resultCode;
    }

    private ResultCode searchWithFilter(LDAPConnectionPool pool, Filter filter, String[] attributes, FixedRateBarrier rateLimiter, List<Control> searchControls) {
        String baseDNString = this.baseDN.isPresent() ? this.baseDN.getStringValue() : "";
        SearchRequest searchRequest = new SearchRequest((SearchResultListener)new LDAPSearchListener(this.outputHandler, this.entryTransformations), baseDNString, this.scope.getValue(), this.derefPolicy, (int)this.sizeLimit.getValue(), (int)this.timeLimitSeconds.getValue(), this.typesOnly.isPresent(), filter, attributes);
        return this.doSearch(pool, searchRequest, rateLimiter, searchControls);
    }

    /*
     * Exception decompiling
     */
    private ResultCode doSearch(LDAPConnectionPool pool, SearchRequest searchRequest, FixedRateBarrier rateLimiter, List<Control> searchControls) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 16[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Control> getSearchControls() {
        ArrayList<Control> controls = new ArrayList<Control>(10);
        if (this.searchControl.isPresent()) {
            controls.addAll(this.searchControl.getValues());
        }
        if (this.joinRequestControl != null) {
            controls.add(this.joinRequestControl);
        }
        if (this.matchedValuesRequestControl != null) {
            controls.add(this.matchedValuesRequestControl);
        }
        if (this.matchingEntryCountRequestControl != null) {
            controls.add(this.matchingEntryCountRequestControl);
        }
        if (this.overrideSearchLimitsRequestControl != null) {
            controls.add(this.overrideSearchLimitsRequestControl);
        }
        if (this.persistentSearchRequestControl != null) {
            controls.add(this.persistentSearchRequestControl);
        }
        if (this.sortRequestControl != null) {
            controls.add(this.sortRequestControl);
        }
        if (this.vlvRequestControl != null) {
            controls.add(this.vlvRequestControl);
        }
        controls.addAll(this.routeToBackendSetRequestControls);
        if (this.accountUsable.isPresent()) {
            controls.add(new AccountUsableRequestControl(true));
        }
        if (this.getBackendSetID.isPresent()) {
            controls.add(new GetBackendSetIDRequestControl(false));
        }
        if (this.getServerID.isPresent()) {
            controls.add(new GetServerIDRequestControl(false));
        }
        if (this.includeReplicationConflictEntries.isPresent()) {
            controls.add(new ReturnConflictEntriesRequestControl(true));
        }
        if (this.includeSoftDeletedEntries.isPresent()) {
            String valueStr = StaticUtils.toLowerCase(this.includeSoftDeletedEntries.getValue());
            if (valueStr.equals("with-non-deleted-entries")) {
                controls.add(new SoftDeletedEntryAccessRequestControl(true, true, false));
            } else if (valueStr.equals("without-non-deleted-entries")) {
                controls.add(new SoftDeletedEntryAccessRequestControl(true, false, false));
            } else {
                controls.add(new SoftDeletedEntryAccessRequestControl(true, false, true));
            }
        }
        if (this.includeSubentries.isPresent()) {
            controls.add(new SubentriesRequestControl(true));
        }
        if (this.manageDsaIT.isPresent()) {
            controls.add(new ManageDsaITRequestControl(true));
        }
        if (this.realAttributesOnly.isPresent()) {
            controls.add(new RealAttributesOnlyRequestControl(true));
        }
        if (this.routeToServer.isPresent()) {
            controls.add(new RouteToServerRequestControl(false, this.routeToServer.getValue(), false, false, false));
        }
        if (this.virtualAttributesOnly.isPresent()) {
            controls.add(new VirtualAttributesOnlyRequestControl(true));
        }
        if (this.excludeBranch.isPresent()) {
            ArrayList<String> dns = new ArrayList<String>(this.excludeBranch.getValues().size());
            for (DN dn : this.excludeBranch.getValues()) {
                dns.add(dn.toString());
            }
            controls.add(new ExcludeBranchRequestControl(true, dns));
        }
        if (this.assertionFilter.isPresent()) {
            controls.add(new AssertionRequestControl(this.assertionFilter.getValue(), true));
        }
        if (this.getEffectiveRightsAuthzID.isPresent()) {
            String[] attributes;
            if (this.getEffectiveRightsAttribute.isPresent()) {
                attributes = new String[this.getEffectiveRightsAttribute.getValues().size()];
                for (int i = 0; i < attributes.length; ++i) {
                    attributes[i] = this.getEffectiveRightsAttribute.getValues().get(i);
                }
            } else {
                attributes = StaticUtils.NO_STRINGS;
            }
            controls.add(new GetEffectiveRightsRequestControl(true, this.getEffectiveRightsAuthzID.getValue(), attributes));
        }
        if (this.operationPurpose.isPresent()) {
            controls.add(new OperationPurposeRequestControl(true, "ldapsearch", "5.0.0", "LDAPSearch.getSearchControls", this.operationPurpose.getValue()));
        }
        if (this.proxyAs.isPresent()) {
            controls.add(new ProxiedAuthorizationV2RequestControl(this.proxyAs.getValue()));
        }
        if (this.proxyV1As.isPresent()) {
            controls.add(new ProxiedAuthorizationV1RequestControl(this.proxyV1As.getValue()));
        }
        if (this.suppressOperationalAttributeUpdates.isPresent()) {
            EnumSet<SuppressType> suppressTypes = EnumSet.noneOf(SuppressType.class);
            for (String s : this.suppressOperationalAttributeUpdates.getValues()) {
                if (s.equalsIgnoreCase("last-access-time")) {
                    suppressTypes.add(SuppressType.LAST_ACCESS_TIME);
                    continue;
                }
                if (s.equalsIgnoreCase("last-login-time")) {
                    suppressTypes.add(SuppressType.LAST_LOGIN_TIME);
                    continue;
                }
                if (!s.equalsIgnoreCase("last-login-ip")) continue;
                suppressTypes.add(SuppressType.LAST_LOGIN_IP);
            }
            controls.add(new SuppressOperationalAttributeUpdateRequestControl(suppressTypes));
        }
        if (this.rejectUnindexedSearch.isPresent()) {
            controls.add(new RejectUnindexedSearchRequestControl());
        }
        if (this.permitUnindexedSearch.isPresent()) {
            controls.add(new PermitUnindexedSearchRequestControl());
        }
        return controls;
    }

    private void displayResult(LDAPResult result) {
        this.outputHandler.formatResult(result);
    }

    void writeOut(String message) {
        if (this.outStream == null) {
            this.out(message);
        } else {
            this.outStream.println(message);
        }
    }

    private void writeErr(String message) {
        if (this.errStream == null) {
            this.err(message);
        } else {
            this.errStream.println(message);
        }
    }

    private void commentToOut(String message) {
        if (this.terse.isPresent()) {
            return;
        }
        for (String line : StaticUtils.wrapLine(message, WRAP_COLUMN - 2)) {
            this.writeOut("# " + line);
        }
    }

    private void commentToErr(String message) {
        for (String line : StaticUtils.wrapLine(message, WRAP_COLUMN - 2)) {
            this.writeErr("# " + line);
        }
    }

    void setOutputHandler(LDAPSearchOutputHandler outputHandler) {
        this.outputHandler = outputHandler;
    }

    @Override
    public void handleUnsolicitedNotification(LDAPConnection connection, ExtendedResult notification) {
        this.outputHandler.formatUnsolicitedNotification(connection, notification);
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(5));
        String[] args = new String[]{"--hostname", "directory.example.com", "--port", "389", "--bindDN", "uid=jdoe,ou=People,dc=example,dc=com", "--bindPassword", "password", "--baseDN", "ou=People,dc=example,dc=com", "--searchScope", "sub", "(uid=jqpublic)", "givenName", "sn", "mail"};
        examples.put(args, ToolMessages.INFO_LDAPSEARCH_EXAMPLE_1.get());
        args = new String[]{"--hostname", "directory.example.com", "--port", "636", "--useSSL", "--saslOption", "mech=PLAIN", "--saslOption", "authID=u:jdoe", "--bindPasswordFile", "/path/to/password/file", "--baseDN", "ou=People,dc=example,dc=com", "--searchScope", "sub", "--filterFile", "/path/to/filter/file", "--outputFile", "/path/to/base/output/file", "--separateOutputFilePerSearch", "--requestedAttribute", "*", "--requestedAttribute", "+"};
        examples.put(args, ToolMessages.INFO_LDAPSEARCH_EXAMPLE_2.get());
        args = new String[]{"--hostname", "directory.example.com", "--port", "389", "--useStartTLS", "--trustStorePath", "/path/to/truststore/file", "--baseDN", "", "--searchScope", "base", "--outputFile", "/path/to/output/file", "--teeResultsToStandardOut", "(objectClass=*)", "*", "+"};
        examples.put(args, ToolMessages.INFO_LDAPSEARCH_EXAMPLE_3.get());
        args = new String[]{"--hostname", "directory.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--baseDN", "dc=example,dc=com", "--searchScope", "sub", "--outputFile", "/path/to/output/file", "--simplePageSize", "100", "(objectClass=*)", "*", "+"};
        examples.put(args, ToolMessages.INFO_LDAPSEARCH_EXAMPLE_4.get());
        args = new String[]{"--hostname", "directory.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--baseDN", "dc=example,dc=com", "--searchScope", "sub", "(&(givenName=John)(sn=Doe))", "debugsearchindex"};
        examples.put(args, ToolMessages.INFO_LDAPSEARCH_EXAMPLE_5.get());
        return examples;
    }
}

