/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotExtensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public abstract class LDAPSDKException
extends Exception {
    private static final long serialVersionUID = 8080186918165352228L;

    protected LDAPSDKException(String message) {
        super(message);
    }

    protected LDAPSDKException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append(super.toString());
    }

    public String getExceptionMessage() {
        boolean includeCause = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeCauseInExceptionMessages");
        boolean includeStackTrace = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeStackTraceInExceptionMessages");
        return this.getExceptionMessage(includeCause, includeStackTrace);
    }

    public String getExceptionMessage(boolean includeCause, boolean includeStackTrace) {
        Throwable cause;
        StringBuilder buffer = new StringBuilder();
        String message = this.getMessage();
        if (message == null || message.isEmpty()) {
            this.toString(buffer);
        } else {
            buffer.append(message);
        }
        if (includeStackTrace) {
            buffer.append(", trace=");
            StaticUtils.getStackTrace(this, buffer);
        } else if (includeCause && (cause = this.getCause()) != null) {
            buffer.append(", cause=");
            buffer.append(StaticUtils.getExceptionMessage(cause));
        }
        String ldapSDKVersionString = ", ldapSDKVersion=5.0.0, revision=cd5405842a48f17a07f646f536e2c0ce93b0ba05";
        if (buffer.indexOf(", ldapSDKVersion=5.0.0, revision=cd5405842a48f17a07f646f536e2c0ce93b0ba05") < 0) {
            buffer.append(", ldapSDKVersion=5.0.0, revision=cd5405842a48f17a07f646f536e2c0ce93b0ba05");
        }
        return buffer.toString();
    }
}

