/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.ServerSetBlacklistManager;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FewestConnectionsServerSet
extends ServerSet {
    static final String PROPERTY_DEFAULT_BLACKLIST_CHECK_INTERVAL_MILLIS = FewestConnectionsServerSet.class.getName() + ".defaultBlacklistCheckIntervalMillis";
    private final BindRequest bindRequest;
    private final LDAPConnectionOptions connectionOptions;
    private final Map<ObjectPair<String, Integer>, AtomicLong> connectionCountsByServer;
    private final PostConnectProcessor postConnectProcessor;
    private final ServerSetBlacklistManager blacklistManager;
    private final SocketFactory socketFactory;

    public FewestConnectionsServerSet(String[] addresses, int[] ports) {
        this(addresses, ports, null, null);
    }

    public FewestConnectionsServerSet(String[] addresses, int[] ports, LDAPConnectionOptions connectionOptions) {
        this(addresses, ports, null, connectionOptions);
    }

    public FewestConnectionsServerSet(String[] addresses, int[] ports, SocketFactory socketFactory) {
        this(addresses, ports, socketFactory, null);
    }

    public FewestConnectionsServerSet(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        this(addresses, ports, socketFactory, connectionOptions, null, null);
    }

    public FewestConnectionsServerSet(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, BindRequest bindRequest, PostConnectProcessor postConnectProcessor) {
        this(addresses, ports, socketFactory, connectionOptions, bindRequest, postConnectProcessor, FewestConnectionsServerSet.getDefaultBlacklistCheckIntervalMillis());
    }

    public FewestConnectionsServerSet(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, BindRequest bindRequest, PostConnectProcessor postConnectProcessor, long blacklistCheckIntervalMillis) {
        Validator.ensureNotNull(addresses, ports);
        Validator.ensureTrue(addresses.length > 0, "FewestConnectionsServerSet.addresses must not be empty.");
        Validator.ensureTrue(addresses.length == ports.length, "FewestConnectionsServerSet addresses and ports arrays must be the same size.");
        LinkedHashMap<ObjectPair<String, Integer>, AtomicLong> m = new LinkedHashMap<ObjectPair<String, Integer>, AtomicLong>(StaticUtils.computeMapCapacity(ports.length));
        for (int i = 0; i < addresses.length; ++i) {
            m.put(new ObjectPair<String, Integer>(addresses[i], ports[i]), new AtomicLong(0L));
        }
        this.connectionCountsByServer = Collections.unmodifiableMap(m);
        this.bindRequest = bindRequest;
        this.postConnectProcessor = postConnectProcessor;
        this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.connectionOptions = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions;
        this.blacklistManager = blacklistCheckIntervalMillis > 0L ? new ServerSetBlacklistManager(this, socketFactory, connectionOptions, bindRequest, postConnectProcessor, blacklistCheckIntervalMillis) : null;
    }

    private static long getDefaultBlacklistCheckIntervalMillis() {
        String propertyValue = StaticUtils.getSystemProperty(PROPERTY_DEFAULT_BLACKLIST_CHECK_INTERVAL_MILLIS);
        if (propertyValue != null) {
            try {
                return Long.parseLong(propertyValue);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return 30000L;
    }

    public String[] getAddresses() {
        int i = 0;
        String[] addresses = new String[this.connectionCountsByServer.size()];
        for (ObjectPair<String, Integer> hostPort : this.connectionCountsByServer.keySet()) {
            addresses[i++] = hostPort.getFirst();
        }
        return addresses;
    }

    public int[] getPorts() {
        int i = 0;
        int[] ports = new int[this.connectionCountsByServer.size()];
        for (ObjectPair<String, Integer> hostPort : this.connectionCountsByServer.keySet()) {
            ports[i++] = hostPort.getSecond();
        }
        return ports;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @Override
    public boolean includesAuthentication() {
        return this.bindRequest != null;
    }

    @Override
    public boolean includesPostConnectProcessing() {
        return this.postConnectProcessor != null;
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    @Override
    public LDAPConnection getConnection(LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        TreeMap<Long, ArrayList<ObjectPair<String, Integer>>> serversByCount = new TreeMap<Long, ArrayList<ObjectPair<String, Integer>>>();
        for (Map.Entry<ObjectPair<String, Integer>, AtomicLong> e : this.connectionCountsByServer.entrySet()) {
            ObjectPair<String, Integer> hostPort = e.getKey();
            long count = e.getValue().get();
            ArrayList<ObjectPair<String, Integer>> l = (ArrayList<ObjectPair<String, Integer>>)serversByCount.get(count);
            if (l == null) {
                l = new ArrayList<ObjectPair<String, Integer>>(this.connectionCountsByServer.size());
                serversByCount.put(count, l);
            }
            l.add(hostPort);
        }
        LDAPException lastException = null;
        ArrayList<ObjectPair> blacklistedServers = null;
        for (List l : serversByCount.values()) {
            if (l.size() > 1) {
                Collections.shuffle(l);
            }
            for (ObjectPair hostPort : l) {
                if (this.blacklistManager != null && this.blacklistManager.isBlacklisted(hostPort)) {
                    if (blacklistedServers == null) {
                        blacklistedServers = new ArrayList<ObjectPair>(this.connectionCountsByServer.size());
                    }
                    blacklistedServers.add(hostPort);
                    continue;
                }
                try {
                    LDAPConnection conn = new LDAPConnection(this.socketFactory, this.connectionOptions, (String)hostPort.getFirst(), (Integer)hostPort.getSecond());
                    FewestConnectionsServerSet.doBindPostConnectAndHealthCheckProcessing(conn, this.bindRequest, this.postConnectProcessor, healthCheck);
                    this.connectionCountsByServer.get(hostPort).incrementAndGet();
                    this.associateConnectionWithThisServerSet(conn);
                    return conn;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    lastException = le;
                    if (this.blacklistManager == null) continue;
                    this.blacklistManager.addToBlacklist(hostPort, healthCheck);
                }
            }
        }
        if (blacklistedServers != null) {
            for (ObjectPair hostPort : blacklistedServers) {
                try {
                    LDAPConnection c = new LDAPConnection(this.socketFactory, this.connectionOptions, (String)hostPort.getFirst(), (Integer)hostPort.getSecond());
                    FewestConnectionsServerSet.doBindPostConnectAndHealthCheckProcessing(c, this.bindRequest, this.postConnectProcessor, healthCheck);
                    this.associateConnectionWithThisServerSet(c);
                    this.blacklistManager.removeFromBlacklist(hostPort);
                    return c;
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    lastException = e;
                }
            }
        }
        throw lastException;
    }

    @Override
    protected void handleConnectionClosed(LDAPConnection connection, String host, int port, DisconnectType disconnectType, String message, Throwable cause) {
        long remainingCount;
        ObjectPair<String, Integer> hostPort = new ObjectPair<String, Integer>(host, port);
        AtomicLong counter = this.connectionCountsByServer.get(hostPort);
        if (counter != null && (remainingCount = counter.decrementAndGet()) < 0L) {
            counter.compareAndSet(remainingCount, 0L);
        }
    }

    ServerSetBlacklistManager getBlacklistManager() {
        return this.blacklistManager;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("FewestConnectionsServerSet(servers={");
        Iterator<Map.Entry<ObjectPair<String, Integer>, AtomicLong>> cbsIterator = this.connectionCountsByServer.entrySet().iterator();
        while (cbsIterator.hasNext()) {
            Map.Entry<ObjectPair<String, Integer>, AtomicLong> e = cbsIterator.next();
            ObjectPair<String, Integer> hostPort = e.getKey();
            long count = e.getValue().get();
            buffer.append('\'');
            buffer.append(hostPort.getFirst());
            buffer.append(':');
            buffer.append(hostPort.getSecond());
            buffer.append("':");
            buffer.append(count);
            if (!cbsIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, includesAuthentication=");
        buffer.append(this.bindRequest != null);
        buffer.append(", includesPostConnectProcessing=");
        buffer.append(this.postConnectProcessor != null);
        buffer.append(')');
    }
}

