/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.JSONLDAPConnectionLogger;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class JSONLDAPConnectionLoggerProperties
implements Serializable {
    private static final long serialVersionUID = 709385948984934296L;
    private boolean flushAfterConnectMessages;
    private boolean flushAfterDisconnectMessages;
    private boolean flushAfterRequestMessages;
    private boolean flushAfterFinalResultMessages;
    private boolean flushAfterNonFinalResultMessages;
    private boolean includeAddAttributeNames;
    private boolean includeAddAttributeValues;
    private boolean includeModifyAttributeNames;
    private boolean includeModifyAttributeValues;
    private boolean includeControlOIDs;
    private boolean includeSearchEntryAttributeNames;
    private boolean includeSearchEntryAttributeValues;
    private boolean logConnects;
    private boolean logDisconnects;
    private boolean logIntermediateResponses;
    private boolean logRequests;
    private boolean logFinalResults;
    private boolean logSearchEntries;
    private boolean logSearchReferences;
    private Schema schema;
    private final Set<OperationType> operationTypes;
    private final Set<String> attributesToRedact;

    public JSONLDAPConnectionLoggerProperties() {
        this.flushAfterConnectMessages = true;
        this.flushAfterDisconnectMessages = true;
        this.flushAfterRequestMessages = false;
        this.flushAfterFinalResultMessages = true;
        this.flushAfterNonFinalResultMessages = false;
        this.includeAddAttributeNames = true;
        this.includeAddAttributeValues = false;
        this.includeModifyAttributeNames = true;
        this.includeModifyAttributeValues = false;
        this.includeControlOIDs = true;
        this.includeSearchEntryAttributeNames = true;
        this.includeSearchEntryAttributeValues = false;
        this.logConnects = true;
        this.logDisconnects = true;
        this.logIntermediateResponses = true;
        this.logRequests = true;
        this.logFinalResults = true;
        this.logSearchEntries = false;
        this.logSearchReferences = false;
        this.operationTypes = EnumSet.allOf(OperationType.class);
        try {
            this.schema = Schema.getDefaultStandardSchema();
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.schema = null;
        }
        this.attributesToRedact = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(10));
        this.attributesToRedact.add("userPassword");
        this.attributesToRedact.add("authPassword");
        this.attributesToRedact.add("unicodePwd");
    }

    public JSONLDAPConnectionLoggerProperties(JSONLDAPConnectionLoggerProperties properties) {
        this.flushAfterConnectMessages = properties.flushAfterConnectMessages;
        this.flushAfterDisconnectMessages = properties.flushAfterDisconnectMessages;
        this.flushAfterRequestMessages = properties.flushAfterRequestMessages;
        this.flushAfterFinalResultMessages = properties.flushAfterFinalResultMessages;
        this.flushAfterNonFinalResultMessages = properties.flushAfterNonFinalResultMessages;
        this.includeAddAttributeNames = properties.includeAddAttributeNames;
        this.includeAddAttributeValues = properties.includeAddAttributeValues;
        this.includeModifyAttributeNames = properties.includeModifyAttributeNames;
        this.includeModifyAttributeValues = properties.includeModifyAttributeValues;
        this.includeControlOIDs = properties.includeControlOIDs;
        this.includeSearchEntryAttributeNames = properties.includeSearchEntryAttributeNames;
        this.includeSearchEntryAttributeValues = properties.includeSearchEntryAttributeValues;
        this.logConnects = properties.logConnects;
        this.logDisconnects = properties.logDisconnects;
        this.logIntermediateResponses = properties.logIntermediateResponses;
        this.logRequests = properties.logRequests;
        this.logFinalResults = properties.logFinalResults;
        this.logSearchEntries = properties.logSearchEntries;
        this.logSearchReferences = properties.logSearchReferences;
        this.schema = properties.schema;
        this.attributesToRedact = new LinkedHashSet<String>(properties.attributesToRedact);
        this.operationTypes = EnumSet.noneOf(OperationType.class);
        this.operationTypes.addAll(properties.operationTypes);
    }

    public JSONLDAPConnectionLoggerProperties(JSONLDAPConnectionLogger logger) {
        this.flushAfterConnectMessages = logger.flushAfterConnectMessages();
        this.flushAfterDisconnectMessages = logger.flushAfterDisconnectMessages();
        this.flushAfterRequestMessages = logger.flushAfterRequestMessages();
        this.flushAfterFinalResultMessages = logger.flushAfterFinalResultMessages();
        this.flushAfterNonFinalResultMessages = logger.flushAfterNonFinalResultMessages();
        this.includeAddAttributeNames = logger.includeAddAttributeNames();
        this.includeAddAttributeValues = logger.includeAddAttributeValues();
        this.includeModifyAttributeNames = logger.includeModifyAttributeNames();
        this.includeModifyAttributeValues = logger.includeModifyAttributeValues();
        this.includeControlOIDs = logger.includeControlOIDs();
        this.includeSearchEntryAttributeNames = logger.includeSearchEntryAttributeNames();
        this.includeSearchEntryAttributeValues = logger.includeSearchEntryAttributeValues();
        this.logConnects = logger.logConnects();
        this.logDisconnects = logger.logDisconnects();
        this.logIntermediateResponses = logger.logIntermediateResponses();
        this.logRequests = logger.logRequests();
        this.logFinalResults = logger.logFinalResults();
        this.logSearchEntries = logger.logSearchEntries();
        this.logSearchReferences = logger.logSearchReferences();
        this.schema = logger.getSchema();
        this.attributesToRedact = new LinkedHashSet<String>(logger.getAttributesToRedact());
        this.operationTypes = EnumSet.noneOf(OperationType.class);
        this.operationTypes.addAll(logger.getOperationTypes());
    }

    public boolean logConnects() {
        return this.logConnects;
    }

    public void setLogConnects(boolean logConnects) {
        this.logConnects = logConnects;
    }

    public boolean logDisconnects() {
        return this.logDisconnects;
    }

    public void setLogDisconnects(boolean logDisconnects) {
        this.logDisconnects = logDisconnects;
    }

    public boolean logRequests() {
        return this.logRequests;
    }

    public void setLogRequests(boolean logRequests) {
        this.logRequests = logRequests;
    }

    public boolean logFinalResults() {
        return this.logFinalResults;
    }

    public void setLogFinalResults(boolean logFinalResults) {
        this.logFinalResults = logFinalResults;
    }

    public boolean logSearchEntries() {
        return this.logSearchEntries;
    }

    public void setLogSearchEntries(boolean logSearchEntries) {
        this.logSearchEntries = logSearchEntries;
    }

    public boolean logSearchReferences() {
        return this.logSearchReferences;
    }

    public void setLogSearchReferences(boolean logSearchReferences) {
        this.logSearchReferences = logSearchReferences;
    }

    public boolean logIntermediateResponses() {
        return this.logIntermediateResponses;
    }

    public void setLogIntermediateResponses(boolean logIntermediateResponses) {
        this.logIntermediateResponses = logIntermediateResponses;
    }

    public Set<OperationType> getOperationTypes() {
        return this.operationTypes;
    }

    public void setOperationTypes(OperationType ... operationTypes) {
        this.operationTypes.clear();
        if (operationTypes != null) {
            this.operationTypes.addAll(Arrays.asList(operationTypes));
        }
    }

    public void setOperationTypes(Collection<OperationType> operationTypes) {
        this.operationTypes.clear();
        if (operationTypes != null) {
            this.operationTypes.addAll(operationTypes);
        }
    }

    public boolean includeAddAttributeNames() {
        return this.includeAddAttributeNames;
    }

    public void setIncludeAddAttributeNames(boolean includeAddAttributeNames) {
        this.includeAddAttributeNames = includeAddAttributeNames;
    }

    public boolean includeAddAttributeValues() {
        return this.includeAddAttributeValues;
    }

    public void setIncludeAddAttributeValues(boolean includeAddAttributeValues) {
        this.includeAddAttributeValues = includeAddAttributeValues;
    }

    public boolean includeModifyAttributeNames() {
        return this.includeModifyAttributeNames;
    }

    public void setIncludeModifyAttributeNames(boolean includeModifyAttributeNames) {
        this.includeModifyAttributeNames = includeModifyAttributeNames;
    }

    public boolean includeModifyAttributeValues() {
        return this.includeModifyAttributeValues;
    }

    public void setIncludeModifyAttributeValues(boolean includeModifyAttributeValues) {
        this.includeModifyAttributeValues = includeModifyAttributeValues;
    }

    public boolean includeSearchEntryAttributeNames() {
        return this.includeSearchEntryAttributeNames;
    }

    public void setIncludeSearchEntryAttributeNames(boolean includeSearchEntryAttributeNames) {
        this.includeSearchEntryAttributeNames = includeSearchEntryAttributeNames;
    }

    public boolean includeSearchEntryAttributeValues() {
        return this.includeSearchEntryAttributeValues;
    }

    public void setIncludeSearchEntryAttributeValues(boolean includeSearchEntryAttributeValues) {
        this.includeSearchEntryAttributeValues = includeSearchEntryAttributeValues;
    }

    public Set<String> getAttributesToRedact() {
        return this.attributesToRedact;
    }

    public void setAttributesToRedact(String ... attributesToRedact) {
        this.attributesToRedact.clear();
        if (attributesToRedact != null) {
            this.attributesToRedact.addAll(Arrays.asList(attributesToRedact));
        }
    }

    public void setAttributesToRedact(Collection<String> attributesToRedact) {
        this.attributesToRedact.clear();
        if (attributesToRedact != null) {
            this.attributesToRedact.addAll(attributesToRedact);
        }
    }

    public boolean includeControlOIDs() {
        return this.includeControlOIDs;
    }

    public void setIncludeControlOIDs(boolean includeControlOIDs) {
        this.includeControlOIDs = includeControlOIDs;
    }

    public boolean flushAfterConnectMessages() {
        return this.flushAfterConnectMessages;
    }

    public void setFlushAfterConnectMessages(boolean flushAfterConnectMessages) {
        this.flushAfterConnectMessages = flushAfterConnectMessages;
    }

    public boolean flushAfterDisconnectMessages() {
        return this.flushAfterDisconnectMessages;
    }

    public void setFlushAfterDisconnectMessages(boolean flushAfterDisconnectMessages) {
        this.flushAfterDisconnectMessages = flushAfterDisconnectMessages;
    }

    public boolean flushAfterRequestMessages() {
        return this.flushAfterRequestMessages;
    }

    public void setFlushAfterRequestMessages(boolean flushAfterRequestMessages) {
        this.flushAfterRequestMessages = flushAfterRequestMessages;
    }

    public boolean flushAfterNonFinalResultMessages() {
        return this.flushAfterNonFinalResultMessages;
    }

    public void setFlushAfterNonFinalResultMessages(boolean flushAfterNonFinalResultMessages) {
        this.flushAfterNonFinalResultMessages = flushAfterNonFinalResultMessages;
    }

    public boolean flushAfterFinalResultMessages() {
        return this.flushAfterFinalResultMessages;
    }

    public void setFlushAfterFinalResultMessages(boolean flushAfterFinalResultMessages) {
        this.flushAfterFinalResultMessages = flushAfterFinalResultMessages;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("JSONLDAPConnectionLoggerProperties(logConnects=");
        buffer.append(this.logConnects);
        buffer.append(", logDisconnects=");
        buffer.append(this.logDisconnects);
        buffer.append(", logRequests=");
        buffer.append(this.logRequests);
        buffer.append(", logFinalResults=");
        buffer.append(this.logFinalResults);
        buffer.append(", logSearchEntries=");
        buffer.append(this.logSearchEntries);
        buffer.append(", logSearchReferences=");
        buffer.append(this.logSearchReferences);
        buffer.append(", logIntermediateResponses=");
        buffer.append(this.logIntermediateResponses);
        buffer.append(", operationTypes={");
        Iterator<OperationType> operationTypeIterator = this.operationTypes.iterator();
        while (operationTypeIterator.hasNext()) {
            buffer.append(operationTypeIterator.next().toString());
            if (!operationTypeIterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(", includeAddAttributeNames=");
        buffer.append(this.includeAddAttributeNames);
        buffer.append(", includeAddAttributeValues=");
        buffer.append(this.includeAddAttributeValues);
        buffer.append(", includeModifyAttributeNames=");
        buffer.append(this.includeModifyAttributeNames);
        buffer.append(", includeModifyAttributeValues=");
        buffer.append(this.includeModifyAttributeValues);
        buffer.append(", includeSearchEntryAttributeNames=");
        buffer.append(this.includeSearchEntryAttributeNames);
        buffer.append(", includeSearchEntryAttributeValues=");
        buffer.append(this.includeSearchEntryAttributeValues);
        buffer.append(", attributesToRedact={");
        Iterator<String> redactAttributeIterator = this.attributesToRedact.iterator();
        while (redactAttributeIterator.hasNext()) {
            buffer.append('\'');
            buffer.append(redactAttributeIterator.next());
            buffer.append('\'');
            if (!redactAttributeIterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("}, includeControlOIDs=");
        buffer.append(this.includeControlOIDs);
        buffer.append(", flushAfterConnectMessages");
        buffer.append(this.flushAfterConnectMessages);
        buffer.append(", flushAfterDisconnectMessages");
        buffer.append(this.flushAfterDisconnectMessages);
        buffer.append(", flushAfterRequestMessages");
        buffer.append(this.flushAfterRequestMessages);
        buffer.append(", flushAfterFinalResultMessages");
        buffer.append(this.flushAfterFinalResultMessages);
        buffer.append(", flushAfterNonFinalResultMessages");
        buffer.append(this.flushAfterNonFinalResultMessages);
        buffer.append(')');
    }
}

