/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1IA5String;
import com.unboundid.asn1.ASN1ObjectIdentifier;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.OID;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.X509Certificate;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GeneralNames
implements Serializable {
    private static final byte NAME_TYPE_OTHER_NAME = -96;
    private static final byte NAME_TYPE_RFC_822_NAME = -127;
    private static final byte NAME_TYPE_DNS_NAME = -126;
    private static final byte NAME_TYPE_X400_ADDRESS = -93;
    private static final byte NAME_TYPE_DIRECTORY_NAME = -92;
    private static final byte NAME_TYPE_EDI_PARTY_NAME = -91;
    private static final byte NAME_TYPE_UNIFORM_RESOURCE_IDENTIFIER = -122;
    private static final byte NAME_TYPE_IP_ADDRESS = -121;
    private static final byte NAME_TYPE_REGISTERED_ID = -120;
    private static final byte NAME_TYPE_OTHER_NAME_VALUE = -96;
    private static final long serialVersionUID = -8789437423467093314L;
    private final List<ASN1Element> ediPartyNames;
    private final List<ASN1Element> x400Addresses;
    private final List<DN> directoryNames;
    private final List<InetAddress> ipAddresses;
    private final List<ObjectPair<OID, ASN1Element>> otherNames;
    private final List<OID> registeredIDs;
    private final List<String> dnsNames;
    private final List<String> rfc822Names;
    private final List<String> uniformResourceIdentifiers;

    GeneralNames(List<ObjectPair<OID, ASN1Element>> otherNames, List<String> rfc822Names, List<String> dnsNames, List<ASN1Element> x400Addresses, List<DN> directoryNames, List<ASN1Element> ediPartyNames, List<String> uniformResourceIdentifiers, List<InetAddress> ipAddresses, List<OID> registeredIDs) {
        this.otherNames = otherNames;
        this.rfc822Names = rfc822Names;
        this.dnsNames = dnsNames;
        this.x400Addresses = x400Addresses;
        this.directoryNames = directoryNames;
        this.ediPartyNames = ediPartyNames;
        this.uniformResourceIdentifiers = uniformResourceIdentifiers;
        this.ipAddresses = ipAddresses;
        this.registeredIDs = registeredIDs;
    }

    GeneralNames(ASN1Element element) throws CertException {
        try {
            ASN1Element[] elements = element.decodeAsSequence().elements();
            ArrayList<ASN1Element> ediPartyList = new ArrayList<ASN1Element>(elements.length);
            ArrayList<ASN1Element> x400AddressList = new ArrayList<ASN1Element>(elements.length);
            ArrayList<DN> directoryNameList = new ArrayList<DN>(elements.length);
            ArrayList<InetAddress> ipAddressList = new ArrayList<InetAddress>(elements.length);
            ArrayList<ObjectPair<OID, ASN1Element>> otherNameList = new ArrayList<ObjectPair<OID, ASN1Element>>(elements.length);
            ArrayList<OID> registeredIDList = new ArrayList<OID>(elements.length);
            ArrayList<String> dnsNameList = new ArrayList<String>(elements.length);
            ArrayList<String> rfc822NameList = new ArrayList<String>(elements.length);
            ArrayList<String> uriList = new ArrayList<String>(elements.length);
            block13: for (ASN1Element e : elements) {
                switch (e.getType()) {
                    case -96: {
                        ASN1Element[] otherNameElements = ASN1Sequence.decodeAsSequence(e).elements();
                        OID otherNameOID = ASN1ObjectIdentifier.decodeAsObjectIdentifier(otherNameElements[0]).getOID();
                        ASN1Element otherNameValue = ASN1Element.decode(otherNameElements[1].getValue());
                        otherNameList.add(new ObjectPair<OID, ASN1Element>(otherNameOID, otherNameValue));
                        continue block13;
                    }
                    case -127: {
                        rfc822NameList.add(ASN1IA5String.decodeAsIA5String(e).stringValue());
                        continue block13;
                    }
                    case -126: {
                        dnsNameList.add(ASN1IA5String.decodeAsIA5String(e).stringValue());
                        continue block13;
                    }
                    case -93: {
                        x400AddressList.add(e);
                        continue block13;
                    }
                    case -92: {
                        ASN1Element innerElement = ASN1Element.decode(e.getValue());
                        directoryNameList.add(X509Certificate.decodeName(innerElement));
                        continue block13;
                    }
                    case -91: {
                        ediPartyList.add(e);
                        continue block13;
                    }
                    case -122: {
                        uriList.add(ASN1IA5String.decodeAsIA5String(e).stringValue());
                        continue block13;
                    }
                    case -121: {
                        ipAddressList.add(InetAddress.getByAddress(e.getValue()));
                        continue block13;
                    }
                    case -120: {
                        registeredIDList.add(ASN1ObjectIdentifier.decodeAsObjectIdentifier(e).getOID());
                    }
                }
            }
            this.ediPartyNames = Collections.unmodifiableList(ediPartyList);
            this.otherNames = Collections.unmodifiableList(otherNameList);
            this.registeredIDs = Collections.unmodifiableList(registeredIDList);
            this.x400Addresses = Collections.unmodifiableList(x400AddressList);
            this.directoryNames = Collections.unmodifiableList(directoryNameList);
            this.ipAddresses = Collections.unmodifiableList(ipAddressList);
            this.dnsNames = Collections.unmodifiableList(dnsNameList);
            this.rfc822Names = Collections.unmodifiableList(rfc822NameList);
            this.uniformResourceIdentifiers = Collections.unmodifiableList(uriList);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_GENERAL_NAMES_CANNOT_PARSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    ASN1Element encode() throws CertException {
        try {
            ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(10);
            for (ObjectPair<OID, ASN1Element> otherName : this.otherNames) {
                elements.add(new ASN1Sequence(-96, new ASN1ObjectIdentifier(otherName.getFirst()), new ASN1Element(-96, otherName.getSecond().encode())));
            }
            for (String rfc822Name : this.rfc822Names) {
                elements.add(new ASN1IA5String(-127, rfc822Name));
            }
            for (String dnsName : this.dnsNames) {
                elements.add(new ASN1IA5String(-126, dnsName));
            }
            for (ASN1Element x400Address : this.x400Addresses) {
                elements.add(new ASN1Element(-93, x400Address.getValue()));
            }
            for (DN directoryName : this.directoryNames) {
                elements.add(new ASN1Element(-92, X509Certificate.encodeName(directoryName).encode()));
            }
            for (ASN1Element ediPartyName : this.ediPartyNames) {
                elements.add(new ASN1Element(-91, ediPartyName.getValue()));
            }
            for (String uri : this.uniformResourceIdentifiers) {
                elements.add(new ASN1IA5String(-122, uri));
            }
            for (InetAddress ipAddress : this.ipAddresses) {
                elements.add(new ASN1OctetString(-121, ipAddress.getAddress()));
            }
            for (OID registeredID : this.registeredIDs) {
                elements.add(new ASN1ObjectIdentifier(-120, registeredID));
            }
            return new ASN1Sequence(elements);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_GENERAL_NAMES_CANNOT_ENCODE.get(this.toString(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public List<ObjectPair<OID, ASN1Element>> getOtherNames() {
        return this.otherNames;
    }

    public List<String> getRFC822Names() {
        return this.rfc822Names;
    }

    public List<String> getDNSNames() {
        return this.dnsNames;
    }

    public List<ASN1Element> getX400Addresses() {
        return this.x400Addresses;
    }

    public List<DN> getDirectoryNames() {
        return this.directoryNames;
    }

    public List<ASN1Element> getEDIPartyNames() {
        return this.ediPartyNames;
    }

    public List<String> getUniformResourceIdentifiers() {
        return this.uniformResourceIdentifiers;
    }

    public List<InetAddress> getIPAddresses() {
        return this.ipAddresses;
    }

    public List<OID> getRegisteredIDs() {
        return this.registeredIDs;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        Iterator<Object> iterator;
        buffer.append("GeneralNames(");
        boolean appended = false;
        if (!this.dnsNames.isEmpty()) {
            buffer.append("dnsNames={");
            iterator = this.dnsNames.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append((String)iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
            appended = true;
        }
        if (!this.ipAddresses.isEmpty()) {
            if (appended) {
                buffer.append(", ");
            }
            buffer.append("ipAddresses={");
            iterator = this.ipAddresses.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(((InetAddress)iterator.next()).getHostAddress());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
            appended = true;
        }
        if (!this.rfc822Names.isEmpty()) {
            if (appended) {
                buffer.append(", ");
            }
            buffer.append("rfc822Names={");
            iterator = this.rfc822Names.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append((String)iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
            appended = true;
        }
        if (!this.directoryNames.isEmpty()) {
            if (appended) {
                buffer.append(", ");
            }
            buffer.append("directoryNames={");
            iterator = this.directoryNames.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
            appended = true;
        }
        if (!this.uniformResourceIdentifiers.isEmpty()) {
            if (appended) {
                buffer.append(", ");
            }
            buffer.append("uniformResourceIdentifiers={");
            iterator = this.uniformResourceIdentifiers.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append((String)iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
            appended = true;
        }
        if (!this.registeredIDs.isEmpty()) {
            if (appended) {
                buffer.append(", ");
            }
            buffer.append("registeredIDs={");
            iterator = this.registeredIDs.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
            appended = true;
        }
        if (!this.otherNames.isEmpty()) {
            if (appended) {
                buffer.append(", ");
            }
            buffer.append("otherNameCount=");
            buffer.append(this.otherNames.size());
        }
        if (!this.x400Addresses.isEmpty()) {
            if (appended) {
                buffer.append(", ");
            }
            buffer.append("x400AddressCount=");
            buffer.append(this.x400Addresses.size());
        }
        if (!this.ediPartyNames.isEmpty()) {
            if (appended) {
                buffer.append(", ");
            }
            buffer.append("ediPartyNameCount=");
            buffer.append(this.ediPartyNames.size());
        }
        buffer.append(')');
    }
}

