/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.experimental;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00Entry;
import com.unboundid.ldap.sdk.experimental.ExperimentalMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DraftChuLDAPLogSchema00ModifyEntry
extends DraftChuLDAPLogSchema00Entry {
    public static final String ATTR_ATTRIBUTE_CHANGES = "reqMod";
    public static final String ATTR_FORMER_ATTRIBUTE = "reqOld";
    private static final long serialVersionUID = 5787071409404025072L;
    private final List<Attribute> formerAttributes;
    private final List<Modification> modifications;

    public DraftChuLDAPLogSchema00ModifyEntry(Entry entry) throws LDAPException {
        super(entry, OperationType.MODIFY);
        byte[][] changes = entry.getAttributeValueByteArrays(ATTR_ATTRIBUTE_CHANGES);
        if (changes == null || changes.length == 0) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES));
        }
        ArrayList<Modification> mods = new ArrayList<Modification>(changes.length);
        for (byte[] changeBytes : changes) {
            boolean needValue;
            ModificationType modType;
            int colonPos = -1;
            for (int i = 0; i < changeBytes.length; ++i) {
                if (changeBytes[i] != 58) continue;
                colonPos = i;
                break;
            }
            if (colonPos < 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MODIFY_CHANGE_MISSING_COLON.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES, StaticUtils.toUTF8String(changeBytes)));
            }
            if (colonPos == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MODIFY_CHANGE_MISSING_ATTR.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES, StaticUtils.toUTF8String(changeBytes)));
            }
            String attrName = StaticUtils.toUTF8String(changeBytes, 0, colonPos);
            if (colonPos == changeBytes.length - 1) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MODIFY_CHANGE_MISSING_CHANGE_TYPE.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES, StaticUtils.toUTF8String(changeBytes)));
            }
            switch (changeBytes[colonPos + 1]) {
                case 43: {
                    modType = ModificationType.ADD;
                    needValue = true;
                    break;
                }
                case 45: {
                    modType = ModificationType.DELETE;
                    needValue = false;
                    break;
                }
                case 61: {
                    modType = ModificationType.REPLACE;
                    needValue = false;
                    break;
                }
                case 35: {
                    modType = ModificationType.INCREMENT;
                    needValue = true;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MODIFY_CHANGE_INVALID_CHANGE_TYPE.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES, StaticUtils.toUTF8String(changeBytes)));
                }
            }
            if (changeBytes.length == colonPos + 2) {
                if (needValue) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MODIFY_CHANGE_MISSING_VALUE.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES, StaticUtils.toUTF8String(changeBytes), modType.getName()));
                }
                mods.add(new Modification(modType, attrName));
                continue;
            }
            if (changeBytes.length == colonPos + 3 || changeBytes[colonPos + 2] != 32) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MODIFY_CHANGE_MISSING_SPACE.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES, StaticUtils.toUTF8String(changeBytes), modType.getName()));
            }
            byte[] attrValue = new byte[changeBytes.length - colonPos - 3];
            if (attrValue.length > 0) {
                System.arraycopy(changeBytes, colonPos + 3, attrValue, 0, attrValue.length);
            }
            if (mods.isEmpty()) {
                mods.add(new Modification(modType, attrName, attrValue));
                continue;
            }
            Modification lastMod = (Modification)mods.get(mods.size() - 1);
            if (lastMod.getModificationType() == modType && lastMod.getAttributeName().equalsIgnoreCase(attrName)) {
                byte[][] lastModValues = lastMod.getValueByteArrays();
                byte[][] newValues = new byte[lastModValues.length + 1][];
                System.arraycopy(lastModValues, 0, newValues, 0, lastModValues.length);
                newValues[lastModValues.length] = attrValue;
                mods.set(mods.size() - 1, new Modification(modType, lastMod.getAttributeName(), newValues));
                continue;
            }
            mods.add(new Modification(modType, attrName, attrValue));
        }
        this.modifications = Collections.unmodifiableList(mods);
        byte[][] formerAttrBytes = entry.getAttributeValueByteArrays(ATTR_FORMER_ATTRIBUTE);
        if (formerAttrBytes == null || formerAttrBytes.length == 0) {
            this.formerAttributes = Collections.emptyList();
            return;
        }
        LinkedHashMap attrMap = new LinkedHashMap(StaticUtils.computeMapCapacity(formerAttrBytes.length));
        for (byte[] attrBytes : formerAttrBytes) {
            byte[] attrValue;
            int colonPos = -1;
            for (int i = 0; i < attrBytes.length; ++i) {
                if (attrBytes[i] != 58) continue;
                colonPos = i;
                break;
            }
            if (colonPos < 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MODIFY_OLD_ATTR_MISSING_COLON.get(entry.getDN(), ATTR_FORMER_ATTRIBUTE, StaticUtils.toUTF8String(attrBytes)));
            }
            if (colonPos == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MODIFY_OLD_ATTR_MISSING_ATTR.get(entry.getDN(), ATTR_FORMER_ATTRIBUTE, StaticUtils.toUTF8String(attrBytes)));
            }
            if (colonPos == attrBytes.length - 1 || attrBytes[colonPos + 1] != 32) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MODIFY_OLD_ATTR_MISSING_SPACE.get(entry.getDN(), ATTR_FORMER_ATTRIBUTE, StaticUtils.toUTF8String(attrBytes)));
            }
            String attrName = StaticUtils.toUTF8String(attrBytes, 0, colonPos);
            String lowerName = StaticUtils.toLowerCase(attrName);
            ArrayList<Attribute> attrList = (ArrayList<Attribute>)attrMap.get(lowerName);
            if (attrList == null) {
                attrList = new ArrayList<Attribute>(10);
                attrMap.put(lowerName, attrList);
            }
            if ((attrValue = new byte[attrBytes.length - colonPos - 2]).length > 0) {
                System.arraycopy(attrBytes, colonPos + 2, attrValue, 0, attrValue.length);
            }
            attrList.add(new Attribute(attrName, attrValue));
        }
        ArrayList<Attribute> oldAttributes = new ArrayList<Attribute>(attrMap.size());
        for (List attrList : attrMap.values()) {
            if (attrList.size() == 1) {
                oldAttributes.addAll(attrList);
                continue;
            }
            byte[][] valueArray = new byte[attrList.size()][];
            for (int i = 0; i < attrList.size(); ++i) {
                valueArray[i] = ((Attribute)attrList.get(i)).getValueByteArray();
            }
            oldAttributes.add(new Attribute(((Attribute)attrList.get(0)).getName(), valueArray));
        }
        this.formerAttributes = Collections.unmodifiableList(oldAttributes);
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    public List<Attribute> getFormerAttributes() {
        return this.formerAttributes;
    }

    public ModifyRequest toModifyRequest() {
        return new ModifyRequest(this.getTargetEntryDN(), this.modifications, this.getRequestControlArray());
    }
}

