/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaElementType;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NameFormDefinition
extends SchemaElement {
    private static final long serialVersionUID = -816231530223449984L;
    private final boolean isObsolete;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String nameFormString;
    private final String oid;
    private final String[] names;
    private final String structuralClass;
    private final String[] optionalAttributes;
    private final String[] requiredAttributes;

    public NameFormDefinition(String s) throws LDAPException {
        String oc;
        String descr;
        Boolean obsolete;
        LinkedHashMap<String, String[]> exts;
        ArrayList<String> optAttrs;
        ArrayList<String> reqAttrs;
        ArrayList<String> nameList;
        block22: {
            String token;
            Validator.ensureNotNull(s);
            this.nameFormString = s.trim();
            int length = this.nameFormString.length();
            if (length == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_EMPTY.get());
            }
            if (this.nameFormString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_NO_OPENING_PAREN.get(this.nameFormString));
            }
            int pos = NameFormDefinition.skipSpaces(this.nameFormString, 1, length);
            StringBuilder buffer = new StringBuilder();
            pos = NameFormDefinition.readOID(this.nameFormString, pos, length, buffer);
            this.oid = buffer.toString();
            nameList = new ArrayList<String>(1);
            reqAttrs = new ArrayList<String>(10);
            optAttrs = new ArrayList<String>(10);
            exts = new LinkedHashMap<String, String[]>(StaticUtils.computeMapCapacity(5));
            obsolete = null;
            descr = null;
            oc = null;
            while (true) {
                String lowerToken;
                int tokenStartPos = pos = NameFormDefinition.skipSpaces(this.nameFormString, pos, length);
                while (pos < length && this.nameFormString.charAt(pos) != ' ') {
                    ++pos;
                }
                token = this.nameFormString.substring(tokenStartPos, pos);
                if (token.length() > 1 && token.endsWith(")")) {
                    token = token.substring(0, token.length() - 1);
                    --pos;
                }
                if ((lowerToken = StaticUtils.toLowerCase(token)).equals(")")) {
                    if (pos < length) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_CLOSE_NOT_AT_END.get(this.nameFormString));
                    }
                    break block22;
                }
                if (lowerToken.equals("name")) {
                    if (nameList.isEmpty()) {
                        pos = NameFormDefinition.skipSpaces(this.nameFormString, pos, length);
                        pos = NameFormDefinition.readQDStrings(this.nameFormString, pos, length, token, nameList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "NAME"));
                }
                if (lowerToken.equals("desc")) {
                    if (descr == null) {
                        pos = NameFormDefinition.skipSpaces(this.nameFormString, pos, length);
                        buffer = new StringBuilder();
                        pos = NameFormDefinition.readQDString(this.nameFormString, pos, length, token, buffer);
                        descr = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "DESC"));
                }
                if (lowerToken.equals("obsolete")) {
                    if (obsolete == null) {
                        obsolete = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "OBSOLETE"));
                }
                if (lowerToken.equals("oc")) {
                    if (oc == null) {
                        pos = NameFormDefinition.skipSpaces(this.nameFormString, pos, length);
                        buffer = new StringBuilder();
                        pos = NameFormDefinition.readOID(this.nameFormString, pos, length, buffer);
                        oc = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "OC"));
                }
                if (lowerToken.equals("must")) {
                    if (reqAttrs.isEmpty()) {
                        pos = NameFormDefinition.skipSpaces(this.nameFormString, pos, length);
                        pos = NameFormDefinition.readOIDs(this.nameFormString, pos, length, token, reqAttrs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "MUST"));
                }
                if (lowerToken.equals("may")) {
                    if (optAttrs.isEmpty()) {
                        pos = NameFormDefinition.skipSpaces(this.nameFormString, pos, length);
                        pos = NameFormDefinition.readOIDs(this.nameFormString, pos, length, token, optAttrs);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "MAY"));
                }
                if (!lowerToken.startsWith("x-")) break;
                pos = NameFormDefinition.skipSpaces(this.nameFormString, pos, length);
                ArrayList<String> valueList = new ArrayList<String>(5);
                pos = NameFormDefinition.readQDStrings(this.nameFormString, pos, length, token, valueList);
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                if (exts.containsKey(token)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_DUP_EXT.get(this.nameFormString, token));
                }
                exts.put(token, values);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_UNEXPECTED_TOKEN.get(this.nameFormString, token));
        }
        this.description = descr;
        this.structuralClass = oc;
        if (this.structuralClass == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_NO_OC.get(this.nameFormString));
        }
        this.names = new String[nameList.size()];
        nameList.toArray(this.names);
        this.requiredAttributes = new String[reqAttrs.size()];
        reqAttrs.toArray(this.requiredAttributes);
        if (reqAttrs.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_NO_MUST.get(this.nameFormString));
        }
        this.optionalAttributes = new String[optAttrs.size()];
        optAttrs.toArray(this.optionalAttributes);
        this.isObsolete = obsolete != null;
        this.extensions = Collections.unmodifiableMap(exts);
    }

    public NameFormDefinition(String oid, String name, String description, String structuralClass, String requiredAttribute, Map<String, String[]> extensions) {
        String[] stringArray;
        if (name == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        }
        this(oid, stringArray, description, false, structuralClass, new String[]{requiredAttribute}, null, extensions);
    }

    public NameFormDefinition(String oid, String[] names, String description, boolean isObsolete, String structuralClass, String[] requiredAttributes, String[] optionalAttributes, Map<String, String[]> extensions) {
        Validator.ensureNotNull(oid, structuralClass, requiredAttributes);
        Validator.ensureFalse(requiredAttributes.length == 0);
        this.oid = oid;
        this.isObsolete = isObsolete;
        this.description = description;
        this.structuralClass = structuralClass;
        this.requiredAttributes = requiredAttributes;
        this.names = names == null ? StaticUtils.NO_STRINGS : names;
        this.optionalAttributes = optionalAttributes == null ? StaticUtils.NO_STRINGS : optionalAttributes;
        this.extensions = extensions == null ? Collections.emptyMap() : Collections.unmodifiableMap(extensions);
        StringBuilder buffer = new StringBuilder();
        this.createDefinitionString(buffer);
        this.nameFormString = buffer.toString();
    }

    private void createDefinitionString(StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.oid);
        if (this.names.length == 1) {
            buffer.append(" NAME '");
            buffer.append(this.names[0]);
            buffer.append('\'');
        } else if (this.names.length > 1) {
            buffer.append(" NAME (");
            for (String name : this.names) {
                buffer.append(" '");
                buffer.append(name);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        if (this.description != null) {
            buffer.append(" DESC '");
            NameFormDefinition.encodeValue(this.description, buffer);
            buffer.append('\'');
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" OC ");
        buffer.append(this.structuralClass);
        if (this.requiredAttributes.length == 1) {
            buffer.append(" MUST ");
            buffer.append(this.requiredAttributes[0]);
        } else if (this.requiredAttributes.length > 1) {
            buffer.append(" MUST (");
            for (int i = 0; i < this.requiredAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.requiredAttributes[i]);
            }
            buffer.append(" )");
        }
        if (this.optionalAttributes.length == 1) {
            buffer.append(" MAY ");
            buffer.append(this.optionalAttributes[0]);
        } else if (this.optionalAttributes.length > 1) {
            buffer.append(" MAY (");
            for (int i = 0; i < this.optionalAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(" $ ");
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.optionalAttributes[i]);
            }
            buffer.append(" )");
        }
        for (Map.Entry<String, String[]> e : this.extensions.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            if (values.length == 1) {
                buffer.append(' ');
                buffer.append(name);
                buffer.append(" '");
                NameFormDefinition.encodeValue(values[0], buffer);
                buffer.append('\'');
                continue;
            }
            buffer.append(' ');
            buffer.append(name);
            buffer.append(" (");
            for (String value : values) {
                buffer.append(" '");
                NameFormDefinition.encodeValue(value, buffer);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        buffer.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(String s) {
        for (String name : this.names) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return s.equalsIgnoreCase(this.oid);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String getStructuralClass() {
        return this.structuralClass;
    }

    public String[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public SchemaElementType getSchemaElementType() {
        return SchemaElementType.NAME_FORM;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof NameFormDefinition)) {
            return false;
        }
        NameFormDefinition d = (NameFormDefinition)o;
        return this.oid.equals(d.oid) && this.structuralClass.equalsIgnoreCase(d.structuralClass) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, d.names) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.requiredAttributes, d.requiredAttributes) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.optionalAttributes, d.optionalAttributes) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, d.description) && this.isObsolete == d.isObsolete && NameFormDefinition.extensionsEqual(this.extensions, d.extensions);
    }

    @Override
    public String toString() {
        return this.nameFormString;
    }
}

