/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum SchemaElementType {
    ATTRIBUTE_SYNTAX("attribute-syntax", "ldapSyntaxes"),
    MATCHING_RULE("matching-rule", "matchingRules"),
    ATTRIBUTE_TYPE("attribute-type", "attributeTypes"),
    OBJECT_CLASS("object-class", "objectClasses"),
    NAME_FORM("name-form", "nameForms"),
    DIT_CONTENT_RULE("dit-content-rule", "dITContentRules"),
    DIT_STRUCTURE_RULE("dit-structure-rule", "dITStructureRules"),
    MATCHING_RULE_USE("matching-rule-use", "matchingRuleUse");

    private final String name;
    private final String subschemaAttributeTypeName;

    private SchemaElementType(String name, String subschemaAttributeTypeName) {
        this.name = name;
        this.subschemaAttributeTypeName = subschemaAttributeTypeName;
    }

    public String getName() {
        return this.name;
    }

    public String getSubschemaAttributeTypeName() {
        return this.subschemaAttributeTypeName;
    }

    public static SchemaElementType forName(String name) {
        String lowerName;
        switch (lowerName = StaticUtils.toLowerCase(name.replace('_', '-'))) {
            case "as": 
            case "syntax": 
            case "syntaxes": 
            case "attributesyntax": 
            case "attribute-syntax": 
            case "attributesyntaxes": 
            case "attribute-syntaxes": 
            case "attributetypesyntax": 
            case "attribute-type-syntax": 
            case "attributetypesyntaxes": 
            case "attribute-type-syntaxes": 
            case "attrsyntax": 
            case "attr-syntax": 
            case "attrsyntaxes": 
            case "attr-syntaxes": 
            case "attrtypesyntax": 
            case "attr-type-syntax": 
            case "attrtypesyntaxes": 
            case "attr-type-syntaxes": 
            case "ldapsyntax": 
            case "ldap-syntax": 
            case "ldapsyntaxes": 
            case "ldap-syntaxes": {
                return ATTRIBUTE_SYNTAX;
            }
            case "mr": 
            case "matchingrule": 
            case "matching-rule": 
            case "matchingrules": 
            case "matching-rules": {
                return MATCHING_RULE;
            }
            case "at": 
            case "type": 
            case "types": 
            case "attributetype": 
            case "attribute-type": 
            case "attributetypes": 
            case "attribute-types": 
            case "attrtype": 
            case "attr-type": 
            case "attrtypes": 
            case "attr-types": {
                return ATTRIBUTE_TYPE;
            }
            case "oc": 
            case "class": 
            case "classes": 
            case "objectclass": 
            case "object-class": 
            case "objectclasses": 
            case "object-classes": {
                return OBJECT_CLASS;
            }
            case "nf": 
            case "form": 
            case "forms": 
            case "nameform": 
            case "name-form": 
            case "nameforms": 
            case "name-forms": {
                return NAME_FORM;
            }
            case "dcr": 
            case "contentrule": 
            case "content-rule": 
            case "contentrules": 
            case "content-rules": 
            case "ditcontentrule": 
            case "dit-content-rule": 
            case "ditcontentrules": 
            case "dit-content-rules": {
                return DIT_CONTENT_RULE;
            }
            case "dsr": 
            case "structurerule": 
            case "structure-rule": 
            case "structurerules": 
            case "structure-rules": 
            case "ditstructurerule": 
            case "dit-structure-rule": 
            case "ditstructurerules": 
            case "dit-structure-rules": {
                return DIT_STRUCTURE_RULE;
            }
            case "mru": 
            case "use": 
            case "uses": 
            case "matchingruleuse": 
            case "matching-rule-use": 
            case "matchingruleuses": 
            case "matching-rule-uses": {
                return MATCHING_RULE_USE;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

